/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.command;

import ch.epfl.biop.atlas.aligner.gui.bdv.ABBABdvStartCommand;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.json.JSONObject;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;
import org.scijava.util.VersionUtils;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Atlas>Multi Image To Atlas>Help>ABBA - Check for updates", description="Check for updates")
public class ABBACheckForUpdateCommand
implements Command {
    private static final String REPO_API_URL = "https://api.github.com/repos/BIOP/ijp-imagetoatlas/releases/latest";

    public void run() {
        String currentVersion = VersionUtils.getVersion(ABBABdvStartCommand.class);
        try {
            String latestVersion = ABBACheckForUpdateCommand.getLatestReleaseTag();
            StringBuilder bodyBuilder = new StringBuilder();
            bodyBuilder.append("<html> Current version: ").append(currentVersion).append("<br>");
            bodyBuilder.append("Latest release: ").append(latestVersion).append("<br>");
            if (ABBACheckForUpdateCommand.isLatestVersion(currentVersion, latestVersion)) {
                ABBACheckForUpdateCommand.showMessage("You are running the latest version.", bodyBuilder.toString(), 1);
            } else {
                ABBACheckForUpdateCommand.showMessage("A newer version is available !", bodyBuilder.toString(), 2);
            }
        }
        catch (Exception e) {
            ABBACheckForUpdateCommand.showMessage("Error occurred while checking for updates: ", e.getMessage(), 0);
        }
    }

    public static void showMessage(String title, String message, int messageType) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(message);
        panel.add(label);
        JOptionPane.showConfirmDialog(null, panel, title, -1, messageType);
    }

    private static String getLatestReleaseTag() throws Exception {
        String output;
        URL url = new URL(REPO_API_URL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/vnd.github.v3+json");
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((output = br.readLine()) != null) {
            response.append(output);
        }
        conn.disconnect();
        JSONObject jsonResponse = new JSONObject(response.toString());
        return jsonResponse.getString("tag_name");
    }

    private static boolean isLatestVersion(String currentVersion, String latestVersion) {
        String[] currentParts = currentVersion.split("\\.");
        String[] latestParts = latestVersion.split("\\.");
        for (int i = 0; i < Math.min(currentParts.length, latestParts.length); ++i) {
            int latestPart;
            int currentPart = Integer.parseInt(currentParts[i]);
            if (currentPart < (latestPart = Integer.parseInt(latestParts[i]))) {
                return false;
            }
            if (currentPart <= latestPart) continue;
            return true;
        }
        return currentParts.length >= latestParts.length;
    }
}

