/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.adapter;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.adapter.AlignerState;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.imglib2.realtransform.AffineTransform3D;

public class SliceSourcesStateDeserializer
implements JsonDeserializer<AlignerState.SliceSourcesState> {
    final Consumer<SliceSources> sliceSourceConsumer;
    SliceSources slice;

    public SliceSourcesStateDeserializer(Consumer<SliceSources> sliceSourceConsumer) {
        this.sliceSourceConsumer = sliceSourceConsumer;
    }

    public AlignerState.SliceSourcesState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<CancelableAction> actions = new ArrayList<CancelableAction>();
        JsonObject obj = json.getAsJsonObject();
        obj.get("actions").getAsJsonArray().forEach(jsonElement -> {
            CancelableAction action = (CancelableAction)context.deserialize(jsonElement, CancelableAction.class);
            action.runRequest();
            this.sliceSourceConsumer.accept(action.getSliceSources());
            this.slice = action.getSliceSources();
            actions.add(action);
        });
        AffineTransform3D preTransform = (AffineTransform3D)context.deserialize(obj.get("preTransform"), AffineTransform3D.class);
        AlignerState.SliceSourcesState sliceState = new AlignerState.SliceSourcesState();
        sliceState.actions = actions;
        sliceState.slice = this.slice;
        sliceState.preTransform = preTransform;
        return sliceState;
    }
}

