/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.adapter;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.registration.Registration;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterSliceAdapter
implements JsonSerializer<RegisterSliceAction>,
JsonDeserializer<RegisterSliceAction> {
    protected static final Logger logger = LoggerFactory.getLogger(RegisterSliceAdapter.class);
    final MultiSlicePositioner mp;
    final Supplier<SliceSources> currentSliceGetter;

    public RegisterSliceAdapter(MultiSlicePositioner mp, Supplier<SliceSources> sliceGetter) {
        this.mp = mp;
        this.currentSliceGetter = sliceGetter;
    }

    public RegisterSliceAction deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        Registration reg = (Registration)jsonDeserializationContext.deserialize(obj.get("registration"), Registration.class);
        SourcesProcessor fixed_sources_preprocess = (SourcesProcessor)jsonDeserializationContext.deserialize(obj.get("fixed_sources_preprocess"), SourcesProcessor.class);
        SourcesProcessor moving_sources_preprocess = (SourcesProcessor)jsonDeserializationContext.deserialize(obj.get("moving_sources_preprocess"), SourcesProcessor.class);
        RegisterSliceAction registerSlice = new RegisterSliceAction(this.mp, this.currentSliceGetter.get(), (Registration<SourceAndConverter<?>[]>)reg, fixed_sources_preprocess, moving_sources_preprocess);
        registerSlice.setRegistration((Registration<SourceAndConverter<?>[]>)reg);
        return registerSlice;
    }

    public JsonElement serialize(RegisterSliceAction regSlice, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        logger.debug("RegisterSlice serialization start, class " + RegisterSliceAction.class.getSimpleName());
        obj.addProperty("type", RegisterSliceAction.class.getSimpleName());
        logger.debug("Serializing moving sources preprocessing");
        obj.add("fixed_sources_preprocess", jsonSerializationContext.serialize((Object)regSlice.getFixedSourcesProcessor()));
        logger.debug("Serializing fixed sources preprocessing");
        obj.add("moving_sources_preprocess", jsonSerializationContext.serialize((Object)regSlice.getMovingSourcesProcessor()));
        logger.debug("Serializing registration");
        obj.add("registration", jsonSerializationContext.serialize(regSlice.getRegistration()));
        logger.debug("RegisterSlice serialization end");
        return obj;
    }
}

