/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.adapter;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.CreateSliceAction;
import ch.epfl.biop.atlas.aligner.DeleteLastRegistrationAction;
import ch.epfl.biop.atlas.aligner.EditLastRegistrationAction;
import ch.epfl.biop.atlas.aligner.LockAndRunOnceSliceAction;
import ch.epfl.biop.atlas.aligner.MoveSliceAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RasterDeformationAction;
import ch.epfl.biop.atlas.aligner.RasterSliceAction;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.UnMirrorSliceAction;
import ch.epfl.biop.atlas.aligner.action.ExportAtlasSliceToImagePlusAction;
import ch.epfl.biop.atlas.aligner.action.ExportSliceRegionsToFileAction;
import ch.epfl.biop.atlas.aligner.action.ExportSliceRegionsToQuPathProjectAction;
import ch.epfl.biop.atlas.aligner.action.ExportSliceRegionsToRoiManagerAction;
import ch.epfl.biop.atlas.aligner.action.ExportSliceToImagePlusAction;
import ch.epfl.biop.atlas.aligner.action.KeySliceOffAction;
import ch.epfl.biop.atlas.aligner.action.KeySliceOnAction;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.imglib2.realtransform.RealTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignerState {
    protected static final Logger logger = LoggerFactory.getLogger(AlignerState.class);
    public String version;
    public double rotationX;
    public double rotationY;
    public final List<SliceSourcesState> slices_state_list = new ArrayList<SliceSourcesState>();
    static final Set<String> toReplace = new HashSet<String>();

    public AlignerState(MultiSlicePositioner mp) {
        this.rotationX = mp.getReslicedAtlas().getRotateX();
        this.rotationY = mp.getReslicedAtlas().getRotateY();
        mp.getSlices().forEach(sliceSource -> {
            SliceSourcesState slice_state = new SliceSourcesState();
            slice_state.actions.addAll(AlignerState.filterSerializedActions(mp.getActionsFromSlice((SliceSources)sliceSource)));
            slice_state.preTransform = sliceSource.getTransformSourceOrigin();
            this.slices_state_list.add(slice_state);
        });
    }

    public static List<CancelableAction> filterSerializedActions(List<CancelableAction> ini_actions) {
        HashSet<Class> serializableActions = new HashSet<Class>();
        serializableActions.add(CreateSliceAction.class);
        serializableActions.add(MoveSliceAction.class);
        serializableActions.add(RegisterSliceAction.class);
        serializableActions.add(KeySliceOnAction.class);
        serializableActions.add(KeySliceOffAction.class);
        serializableActions.add(UnMirrorSliceAction.class);
        HashSet<Class<ExportSliceToImagePlusAction>> skipableActions = new HashSet<Class<ExportSliceToImagePlusAction>>();
        skipableActions.add(ExportSliceRegionsToFileAction.class);
        skipableActions.add(ExportSliceRegionsToQuPathProjectAction.class);
        skipableActions.add(ExportSliceRegionsToRoiManagerAction.class);
        skipableActions.add(EditLastRegistrationAction.class);
        skipableActions.add(ExportAtlasSliceToImagePlusAction.class);
        skipableActions.add(RasterDeformationAction.class);
        skipableActions.add(LockAndRunOnceSliceAction.class);
        skipableActions.add(RasterSliceAction.class);
        skipableActions.add(ExportSliceToImagePlusAction.class);
        ArrayList<CancelableAction> compiledActions = new ArrayList<CancelableAction>();
        if (ini_actions == null || ini_actions.size() == 0) {
            logger.error("Wrong number of actions to be serialized");
            return compiledActions;
        }
        if (!(ini_actions.get(0) instanceof CreateSliceAction)) {
            logger.error("Error : the first action is not a CreateSlice action");
            return compiledActions;
        }
        int idxCompiledActions = 0;
        int idxIniActions = 0;
        while (ini_actions.size() > idxIniActions) {
            CancelableAction nextAction = ini_actions.get(idxIniActions);
            if (serializableActions.contains(nextAction.getClass())) {
                ++idxCompiledActions;
                ++idxIniActions;
                compiledActions.add(nextAction);
                continue;
            }
            if (skipableActions.contains(nextAction.getClass())) {
                ++idxIniActions;
                continue;
            }
            if (nextAction instanceof DeleteLastRegistrationAction) {
                int idxLastRegistration;
                for (idxLastRegistration = idxCompiledActions - 1; idxLastRegistration > 0 && !(compiledActions.get(idxLastRegistration) instanceof RegisterSliceAction); --idxLastRegistration) {
                }
                if (idxLastRegistration >= 0) {
                    if (compiledActions.get(idxLastRegistration) instanceof RegisterSliceAction) {
                        compiledActions.remove(idxLastRegistration);
                        --idxCompiledActions;
                        ++idxIniActions;
                        continue;
                    }
                    logger.error("Error : issue with DeleteLastRegistrationAction action!!!!");
                    ++idxIniActions;
                    continue;
                }
                logger.error("Error : issue with DeleteLastRegistrationAction action!!!!");
                ++idxIniActions;
                continue;
            }
            logger.warn("Error : issue with filtering serializable actions. Action class = " + nextAction.getClass());
            ++idxIniActions;
        }
        return compiledActions;
    }

    public static JsonElement convertOldJson(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject object = (JsonObject)element;
            object.entrySet().forEach(e -> {
                if (((String)e.getKey()).equals("type")) {
                    String val = ((JsonElement)e.getValue()).getAsString();
                    if (toReplace.contains(val)) {
                        e.setValue(new JsonPrimitive(val + "Action"));
                    }
                } else {
                    e.setValue(AlignerState.convertOldJson((JsonElement)e.getValue()));
                }
            });
        } else if (element.isJsonArray()) {
            JsonArray array = (JsonArray)element;
            JsonArray converted = new JsonArray();
            for (JsonElement e2 : array) {
                converted.add(AlignerState.convertOldJson(e2));
            }
            element = converted;
        }
        return element;
    }

    static {
        toReplace.add("MoveSlice");
        toReplace.add("CreateSlice");
        toReplace.add("RegisterSlice");
        toReplace.add("KeySliceOff");
        toReplace.add("KeySliceOn");
    }

    public static class SliceSourcesState {
        public transient SliceSources slice;
        public RealTransform preTransform;
        public List<CancelableAction> actions = new ArrayList<CancelableAction>();
    }
}

