/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.action;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Graphics2D;

public class KeySliceOnAction
extends CancelableAction {
    private final SliceSources sliceSource;

    public KeySliceOnAction(MultiSlicePositioner mp, SliceSources sliceSource) {
        super(mp);
        this.sliceSource = sliceSource;
        this.hide();
    }

    @Override
    public SliceSources getSliceSources() {
        return this.sliceSource;
    }

    @Override
    protected boolean run() {
        if (!this.sliceSource.isKeySlice()) {
            this.sliceSource.keySliceOn();
            this.getMP().stateHasBeenChanged();
            return true;
        }
        return true;
    }

    public String toString() {
        return "Key slice";
    }

    @Override
    protected boolean cancel() {
        if (this.sliceSource.isKeySlice()) {
            this.sliceSource.keySliceOff();
            this.getMP().stateHasBeenChanged();
        }
        return true;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        g.drawString("K", (int)px - 5, (int)py + 5);
    }
}

