/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.action;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.SliceToImagePlus;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Graphics2D;

public class ExportSliceToImagePlusAction
extends CancelableAction {
    final SliceSources slice;
    final SourcesProcessor preprocess;
    final double px;
    final double py;
    final double sx;
    final double sy;
    final double pixel_size_mm;
    final int timepoint;
    final boolean interpolate;
    ImagePlus resultImage = null;

    public ExportSliceToImagePlusAction(MultiSlicePositioner mp, SliceSources slice, SourcesProcessor preprocess, double px, double py, double sx, double sy, double pixel_size_millimeter, int timepoint, boolean interpolate) {
        super(mp);
        this.slice = slice;
        this.preprocess = preprocess;
        this.px = px;
        this.py = py;
        this.sx = sx;
        this.sy = sy;
        this.pixel_size_mm = pixel_size_millimeter;
        this.timepoint = timepoint;
        this.interpolate = interpolate;
    }

    @Override
    public SliceSources getSliceSources() {
        return this.slice;
    }

    @Override
    protected boolean run() {
        this.resultImage = SliceToImagePlus.export(this.slice, this.preprocess, this.px, this.py, this.sx, this.sy, this.pixel_size_mm, this.timepoint, this.interpolate);
        return this.resultImage != null;
    }

    @Override
    protected boolean cancel() {
        this.clean();
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.resultImage;
    }

    public void clean() {
        this.resultImage = null;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        switch (this.slice.getActionState(this)) {
            case "(done)": {
                g.setColor(new Color(0, 255, 0, 200));
                break;
            }
            case "(locked)": {
                g.setColor(new Color(255, 0, 0, 200));
                break;
            }
            case "(pending)": {
                g.setColor(new Color(255, 255, 0, 200));
            }
        }
        g.fillRect((int)(px - 7.0), (int)(py - 7.0), 14, 14);
        g.setColor(new Color(255, 255, 255, 200));
        g.drawString("E", (int)px - 4, (int)py + 5);
    }
}

