/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.action;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Color;
import java.awt.Graphics2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportSliceRegionsToQuPathProjectAction
extends CancelableAction {
    protected static final Logger logger = LoggerFactory.getLogger(ExportSliceRegionsToQuPathProjectAction.class);
    final SliceSources slice;
    final boolean erasePreviousFile;

    public ExportSliceRegionsToQuPathProjectAction(MultiSlicePositioner mp, SliceSources slice, boolean erasePreviousFile) {
        super(mp);
        this.slice = slice;
        this.erasePreviousFile = erasePreviousFile;
    }

    @Override
    protected boolean run() {
        logger.info("Exporting slice " + this.slice + " registration to QuPath");
        this.slice.exportToQuPathProject(this.erasePreviousFile);
        return true;
    }

    public String toString() {
        return "Export";
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        switch (this.slice.getActionState(this)) {
            case "(done)": {
                g.setColor(new Color(0, 255, 0, 200));
                break;
            }
            case "(locked)": {
                g.setColor(new Color(255, 0, 0, 200));
                break;
            }
            case "(pending)": {
                g.setColor(new Color(255, 255, 0, 200));
            }
        }
        g.fillOval((int)(px - 7.0), (int)(py - 7.0), 14, 14);
        g.setColor(new Color(255, 255, 255, 200));
        g.drawString("E", (int)px - 4, (int)py + 5);
    }

    @Override
    protected boolean cancel() {
        logger.debug("Export to QuPath cancel : no action");
        return true;
    }

    @Override
    public SliceSources getSliceSources() {
        return this.slice;
    }
}

