/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner.action;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.DeformationFieldToImagePlus;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Graphics2D;

public class ExportDeformationFieldToImagePlusAction
extends CancelableAction {
    final SliceSources slice;
    final int timepoint;
    final int resolutionLevel;
    final int maxIteration;
    final int downsample;
    final double toleranceInMm;
    ImagePlus resultImage = null;

    public ExportDeformationFieldToImagePlusAction(MultiSlicePositioner mp, SliceSources slice, int resolutionLevel, int downsample, int timepoint, double toleranceInMm, int maxIteration) {
        super(mp);
        this.slice = slice;
        this.timepoint = timepoint;
        this.resolutionLevel = resolutionLevel;
        this.toleranceInMm = toleranceInMm;
        this.maxIteration = maxIteration;
        this.downsample = downsample;
    }

    @Override
    public SliceSources getSliceSources() {
        return this.slice;
    }

    @Override
    protected boolean run() {
        this.resultImage = DeformationFieldToImagePlus.export(this.slice, this.resolutionLevel, this.downsample, this.timepoint, this.toleranceInMm, this.maxIteration);
        return this.resultImage != null;
    }

    @Override
    protected boolean cancel() {
        this.clean();
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.resultImage;
    }

    public void clean() {
        this.resultImage = null;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        switch (this.slice.getActionState(this)) {
            case "(done)": {
                g.setColor(new Color(0, 255, 0, 200));
                break;
            }
            case "(locked)": {
                g.setColor(new Color(255, 0, 0, 200));
                break;
            }
            case "(pending)": {
                g.setColor(new Color(255, 255, 0, 200));
            }
        }
        g.fillRect((int)(px - 7.0), (int)(py - 7.0), 14, 14);
        g.setColor(new Color(255, 255, 255, 200));
        g.drawString("E", (int)px - 4, (int)py + 5);
    }
}

