/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Color;
import java.awt.Graphics2D;

public class UnMirrorSliceAction
extends CancelableAction {
    private final SliceSources sliceSource;
    boolean isValid = true;

    public UnMirrorSliceAction(MultiSlicePositioner mp, SliceSources sliceSource) {
        super(mp);
        this.sliceSource = sliceSource;
    }

    @Override
    public SliceSources getSliceSources() {
        return this.sliceSource;
    }

    @Override
    protected boolean run() {
        this.isValid = this.sliceSource.hideLastMirrorRegistration();
        this.mp.slicePreTransformChanged(this.sliceSource);
        return this.isValid;
    }

    public String toString() {
        return "UnMirror";
    }

    @Override
    protected boolean cancel() {
        boolean success = this.sliceSource.restoreLastMirrorRegistration();
        this.mp.slicePreTransformChanged(this.sliceSource);
        return success;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        double size = 7.0 * scale;
        if (this.isValid) {
            if (scale < 0.9) {
                g.setColor(new Color(128, 128, 128, 200));
            } else {
                switch (this.sliceSource.getActionState(this)) {
                    case "(done)": {
                        g.setColor(new Color(0, 255, 0, 200));
                        break;
                    }
                    case "(locked)": {
                        g.setColor(new Color(205, 1, 106, 200));
                        break;
                    }
                    case "(pending)": {
                        g.setColor(new Color(255, 255, 0, 200));
                    }
                }
            }
            g.fillRect((int)(px - size), (int)(py - size), (int)(2.0 * size), (int)(2.0 * size));
            g.setColor(new Color(255, 255, 255, 200));
            g.drawString("R", (int)px - 4, (int)py + 5);
        } else {
            g.setColor(new Color(205, 1, 106, 199));
            g.drawString("X", (int)px - 4, (int)py + 5);
        }
    }
}

