/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

public class SliceToImagePlus {
    static final Logger logger = LoggerFactory.getLogger(SliceToImagePlus.class);

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus export(List<SourceAndConverter<?>> sourceList, SliceSources slice, SourcesProcessor preprocess, double px, double py, double sx, double sy, double pixelSizeMillimeter, int timepoint, boolean interpolate) {
        AffineTransform3D at3D = new AffineTransform3D();
        SourceAndConverter model = SliceToImagePlus.createModelSource(slice, px, py, sx, sy, pixelSizeMillimeter, at3D);
        List resampledSourceList = sourceList.stream().map(sac -> new SourceResampler(sac, model, sac.getSpimSource().getName() + "_ResampledLike_" + model.getSpimSource().getName(), true, false, interpolate, 0).get()).collect(Collectors.toList());
        if (sourceList.size() > 1) {
            HashMap mapMipmap = new HashMap();
            sourceList.forEach(src -> {
                int mipmapLevel = SourceAndConverterHelper.bestLevel((SourceAndConverter)src, (int)timepoint, (double)pixelSizeMillimeter);
                logger.debug("Mipmap level chosen for source [" + src.getSpimSource().getName() + "] : " + mipmapLevel);
                mapMipmap.put(resampledSourceList.get(sourceList.indexOf(src)), mipmapLevel);
            });
            ImagePlus resultImage = ImagePlusHelper.wrap(resampledSourceList, mapMipmap, (int)timepoint, (int)1, (int)1);
            resultImage.setTitle(slice.getName() + "-[" + px + ":" + (px + sx) + " | " + py + ":" + (py + sy) + "]");
            ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)resultImage, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
            return resultImage;
        }
        SourceAndConverter source = (SourceAndConverter)resampledSourceList.get(0);
        int mipmapLevel = SourceAndConverterHelper.bestLevel(sourceList.get(0), (int)timepoint, (double)pixelSizeMillimeter);
        ImagePlus singleChannel = ImagePlusHelper.wrap((SourceAndConverter)source, (int)mipmapLevel, (int)timepoint, (int)1, (int)1);
        singleChannel.setTitle(source.getSpimSource().getName());
        ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)singleChannel, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
        return singleChannel;
    }

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus export(SliceSources slice, SourcesProcessor preprocess, double px, double py, double sx, double sy, double pixelSizeMillimeter, int timepoint, boolean interpolate) {
        List<Object> sourceList = Arrays.asList((Object[])preprocess.apply(slice.getRegisteredSources()));
        AffineTransform3D at3D = new AffineTransform3D();
        SourceAndConverter model = SliceToImagePlus.createModelSource(slice, px, py, sx, sy, pixelSizeMillimeter, at3D);
        List resampledSourceList = sourceList.stream().map(sac -> new SourceResampler(sac, model, sac.getSpimSource().getName() + "_ResampledLike_" + model.getSpimSource().getName(), true, false, interpolate, 0).get()).collect(Collectors.toList());
        if (sourceList.size() > 1) {
            HashMap mapMipmap = new HashMap();
            sourceList.forEach(src -> {
                int mipmapLevel = SourceAndConverterHelper.bestLevel((SourceAndConverter)src, (int)timepoint, (double)pixelSizeMillimeter);
                logger.debug("Mipmap level chosen for source [" + src.getSpimSource().getName() + "] : " + mipmapLevel);
                mapMipmap.put(resampledSourceList.get(sourceList.indexOf(src)), mipmapLevel);
            });
            ImagePlus resultImage = ImagePlusHelper.wrap(resampledSourceList, mapMipmap, (int)timepoint, (int)1, (int)1);
            resultImage.setTitle(slice.getName() + "-[" + px + ":" + (px + sx) + " | " + py + ":" + (py + sy) + "]");
            ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)resultImage, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
            return resultImage;
        }
        SourceAndConverter source = (SourceAndConverter)resampledSourceList.get(0);
        int mipmapLevel = SourceAndConverterHelper.bestLevel((SourceAndConverter)((SourceAndConverter)sourceList.get(0)), (int)timepoint, (double)pixelSizeMillimeter);
        ImagePlus singleChannel = ImagePlusHelper.wrap((SourceAndConverter)source, (int)mipmapLevel, (int)timepoint, (int)1, (int)1);
        singleChannel.setTitle(source.getSpimSource().getName());
        ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)singleChannel, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
        return singleChannel;
    }

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus exportAtlas(MultiSlicePositioner mp, SliceSources slice, SourcesProcessor preprocess, double px, double py, double sx, double sy, double pixelSizeMillimeter, int timepoint, boolean interpolate) throws UnsupportedOperationException {
        List<Object> sourceList = Arrays.asList((Object[])preprocess.apply((Object)mp.getReslicedAtlas().nonExtendedSlicedSources));
        Class<?> firstSourceType = ((SourceAndConverter)sourceList.get(0)).getSpimSource().getType().getClass();
        ArrayList<Class> allowedClasses = new ArrayList<Class>();
        allowedClasses.add(UnsignedShortType.class);
        allowedClasses.add(UnsignedByteType.class);
        allowedClasses.add(FloatType.class);
        allowedClasses.add(ARGBType.class);
        if (!allowedClasses.contains(firstSourceType)) {
            throw new UnsupportedOperationException("Can't export pixel type " + firstSourceType.getClass().getSimpleName() + " to ImagePlus");
        }
        for (SourceAndConverter sourceAndConverter : sourceList) {
            if (sourceAndConverter.getSpimSource().getType().getClass() == firstSourceType) continue;
            throw new UnsupportedOperationException("Can't export combined pixel types (" + firstSourceType.getSimpleName() + ") and (" + sourceAndConverter.getSpimSource().getType().getClass().getSimpleName() + "). Please select less channels.");
        }
        AffineTransform3D at3D = new AffineTransform3D();
        SourceAndConverter sourceAndConverter = SliceToImagePlus.createModelSource(slice, px, py, sx, sy, pixelSizeMillimeter, at3D);
        List resampledSourceList = sourceList.stream().map(sac -> new SourceResampler(sac, model, sac.getSpimSource().getName() + "_ResampledLike_" + model.getSpimSource().getName(), true, false, interpolate, 0).get()).collect(Collectors.toList());
        if (sourceList.size() > 1) {
            HashMap mapMipmap = new HashMap();
            sourceList.forEach(src -> {
                int mipmapLevel = SourceAndConverterHelper.bestLevel((SourceAndConverter)src, (int)timepoint, (double)pixelSizeMillimeter);
                if (!interpolate) {
                    mipmapLevel = 0;
                }
                logger.debug("Mipmap level chosen for source [" + src.getSpimSource().getName() + "] : " + mipmapLevel);
                mapMipmap.put(resampledSourceList.get(sourceList.indexOf(src)), mipmapLevel);
            });
            ImagePlus resultImage = ImagePlusHelper.wrap(resampledSourceList, mapMipmap, (int)timepoint, (int)1, (int)1);
            resultImage.setTitle(slice.getName() + "-[" + px + ":" + (px + sx) + " | " + py + ":" + (py + sy) + "]");
            ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)resultImage, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
            return resultImage;
        }
        SourceAndConverter source = (SourceAndConverter)resampledSourceList.get(0);
        int mipmapLevel = SourceAndConverterHelper.bestLevel((SourceAndConverter)((SourceAndConverter)sourceList.get(0)), (int)timepoint, (double)pixelSizeMillimeter);
        ImagePlus singleChannel = ImagePlusHelper.wrap((SourceAndConverter)source, (int)mipmapLevel, (int)timepoint, (int)1, (int)1);
        singleChannel.setTitle(source.getSpimSource().getName());
        ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)singleChannel, (AffineTransform3D)at3D.inverse(), (String)"mm", (int)timepoint);
        return singleChannel;
    }

    private static SourceAndConverter createModelSource(SliceSources slice, double px, double py, double sx, double sy, double pixel_size_mm, AffineTransform3D transform) {
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.translate(new double[]{-px, -py, -slice.getSlicingAxisPosition()});
        at3D.scale(1.0 / pixel_size_mm);
        long nPx = (long)(sx / pixel_size_mm);
        long nPy = (long)(sy / pixel_size_mm);
        long nPz = 1L;
        if (nPz == 0L) {
            nPz = 1L;
        }
        if (nPx == 0L) {
            nPx = 1L;
        }
        if (nPy == 0L) {
            nPy = 1L;
        }
        transform.set(at3D);
        return new EmptySourceAndConverterCreator("model", at3D.inverse(), nPx, nPy, nPz).get();
    }
}

