/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import bdv.AbstractSpimSource;
import bdv.SpimSource;
import bdv.img.WarpedSource;
import bdv.tools.transformation.TransformedSource;
import bdv.util.BoundedRealTransform;
import bdv.util.DefaultInterpolators;
import bdv.util.QuPathBdvHelper;
import bdv.util.RealTransformHelper;
import bdv.util.ResampledSource;
import bdv.util.source.alpha.AlphaSourceHelper;
import bdv.util.source.alpha.AlphaSourceRAI;
import bdv.util.source.alpha.IAlphaSource;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.CreateSliceAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.mouse.allen.ccfv3.command.AllenBrainAdultMouseAtlasCCF2017Command;
import ch.epfl.biop.atlas.struct.AtlasHelper;
import ch.epfl.biop.atlas.struct.AtlasNode;
import ch.epfl.biop.atlas.struct.AtlasOntology;
import ch.epfl.biop.bdv.img.entity.ImageName;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import ch.epfl.biop.java.utilities.roi.ConvertibleRois;
import ch.epfl.biop.java.utilities.roi.SelectToROIKeepLines;
import ch.epfl.biop.java.utilities.roi.types.CompositeFloatPoly;
import ch.epfl.biop.java.utilities.roi.types.IJShapeRoiArray;
import ch.epfl.biop.java.utilities.roi.types.ImageJRoisFile;
import ch.epfl.biop.java.utilities.roi.types.RealPointList;
import ch.epfl.biop.registration.Registration;
import ch.epfl.biop.registration.plugin.RegistrationPluginHelper;
import ch.epfl.biop.registration.sourceandconverter.affine.AffineTransformedSourceWrapperRegistration;
import ch.epfl.biop.registration.sourceandconverter.affine.CenterZeroRegistration;
import ch.epfl.biop.registration.sourceandconverter.mirror.MirrorXRegistration;
import ch.epfl.biop.registration.sourceandconverter.mirror.MirrorXTransform;
import ch.epfl.biop.registration.sourceandconverter.spline.RealTransformSourceAndConverterRegistration;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesIdentity;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessComposer;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import com.google.gson.Gson;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.position.FunctionRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.Wrapped2DTransformAs3D;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterInspector;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceRealTransformer;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;
import sc.fiji.persist.ScijavaGsonHelper;
import spimdata.util.Displaysettings;

public class SliceSources {
    protected static final Logger logger = LoggerFactory.getLogger(SliceSources.class);
    final SourceAndConverter<?>[] original_sacs;
    public final int nChannels;
    private volatile SourceAndConverter<?>[] registered_sacs;
    private final List<RegistrationAndSources> registered_sacs_sequence = new ArrayList<RegistrationAndSources>();
    private double slicingAxisPosition;
    private boolean isSelected = false;
    private final MultiSlicePositioner mp;
    private final AffineTransformedSourceWrapperRegistration zPositioner;
    private final AffineTransformedSourceWrapperRegistration preTransform;
    private final CenterZeroRegistration centerPositioner;
    private ImagePlus impLabelImage;
    private AffineTransform3D at3DLastLabelImage;
    private boolean labelImageBeingComputed = false;
    private ConvertibleRois cvtRoisOrigin;
    private ConvertibleRois cvtRoisTransformed;
    private ConvertibleRois leftRightTranformed;
    private final List<Registration<SourceAndConverter<?>[]>> registrations = new ArrayList<Registration<SourceAndConverter<?>[]>>();
    private final List<CompletableFuture<Boolean>> tasks = new ArrayList<CompletableFuture<Boolean>>();
    private final Map<CancelableAction, CompletableFuture<Boolean>> mapActionTask = new ConcurrentHashMap<CancelableAction, CompletableFuture<Boolean>>();
    private volatile CancelableAction actionInProgress = null;
    private final ConvertibleRois leftRightOrigin = new ConvertibleRois();
    private int currentSliceIndex = -1;
    protected String name = "";
    final IAlphaSource alphaSource;
    protected final DefaultInterpolators<FloatType> interpolators = new DefaultInterpolators();
    protected double zThicknessCorrection;
    protected double zShiftCorrection;
    double thicknessInMm;
    Executor executor = ForkJoinPool.commonPool();
    double rotXLastExport = Double.MAX_VALUE;
    double rotYLastExport = Double.MAX_VALUE;
    boolean setAsKeySlice = false;
    double tempAxisPosition;
    final LinkedList<SourceAndConverter<?>[]> sourcesDeformationFieldNonRasterized = new LinkedList();
    final LinkedList<SourceAndConverter<?>[]> sourcesNonRasterized = new LinkedList();
    final SliceInterval si = new SliceInterval();

    protected SliceSources(SourceAndConverter<?>[] sacs, double slicingAxisPosition, final MultiSlicePositioner mp, double thicknessCorrection, double zShiftCorrection) {
        this.zThicknessCorrection = thicknessCorrection;
        this.zShiftCorrection = zShiftCorrection;
        this.nChannels = sacs.length;
        this.mp = mp;
        this.original_sacs = sacs;
        this.slicingAxisPosition = slicingAxisPosition;
        this.registered_sacs = this.original_sacs;
        this.centerPositioner = new CenterZeroRegistration();
        this.centerPositioner.setMovingImage(this.registered_sacs);
        this.zPositioner = new AffineTransformedSourceWrapperRegistration();
        this.preTransform = new AffineTransformedSourceWrapperRegistration();
        String unit = this.original_sacs[0].getSpimSource().getVoxelDimensions().unit();
        double voxX = this.original_sacs[0].getSpimSource().getVoxelDimensions().dimension(0);
        double voxY = this.original_sacs[0].getSpimSource().getVoxelDimensions().dimension(1);
        double voxZ = this.original_sacs[0].getSpimSource().getVoxelDimensions().dimension(2);
        final FinalVoxelDimensions voxD = new FinalVoxelDimensions(unit, new double[]{voxX, voxY, voxZ});
        final FinalInterval interval = new FinalInterval(new long[]{mp.nPixX, mp.nPixY, 1L});
        this.alphaSource = new IAlphaSource(){

            public boolean doBoundingBoxCulling() {
                return false;
            }

            public boolean intersectBox(AffineTransform3D affineTransform, Interval cell, int timepoint) {
                AlphaSourceRAI.Box3D box_cell = new AlphaSourceRAI.Box3D(affineTransform, cell);
                AffineTransform3D affineTransform3D = new AffineTransform3D();
                this.getSourceTransform(timepoint, 0, affineTransform3D);
                AlphaSourceRAI.Box3D box_this = new AlphaSourceRAI.Box3D(affineTransform3D, this.getSource(timepoint, 0));
                return box_this.intersects(box_cell);
            }

            public boolean isPresent(int t) {
                return t == 0;
            }

            public RandomAccessibleInterval<FloatType> getSource(int t, int level) {
                FunctionRandomAccessible randomAccessible = new FunctionRandomAccessible(3, () -> (loc, out) -> out.setReal(1.0f), FloatType::new);
                return Views.interval((RandomAccessible)randomAccessible, (Interval)interval);
            }

            public RealRandomAccessible<FloatType> getInterpolatedSource(int t, int level, Interpolation interpolation) {
                ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
                RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)SliceSources.this.interpolators.get(Interpolation.NEARESTNEIGHBOR));
                return realRandomAccessible;
            }

            public void getSourceTransform(int t, int level, AffineTransform3D affineTransform3D) {
                affineTransform3D.identity();
                affineTransform3D.scale(mp.sizePixX, mp.sizePixY, SliceSources.this.thicknessInMm);
                affineTransform3D.translate(new double[]{-mp.sX / 2.0, -mp.sY / 2.0, SliceSources.this.getSlicingAxisPosition() + SliceSources.this.getZShiftCorrection()});
            }

            public FloatType getType() {
                return new FloatType();
            }

            public String getName() {
                return "alpha-slice";
            }

            public VoxelDimensions getVoxelDimensions() {
                return voxD;
            }

            public int getNumMipmapLevels() {
                return 1;
            }
        };
        this.runRegistration((Registration<SourceAndConverter<?>[]>)this.centerPositioner, (SourcesProcessor)new SourcesIdentity(), (SourcesProcessor)new SourcesIdentity());
        this.runRegistration((Registration<SourceAndConverter<?>[]>)this.preTransform, (SourcesProcessor)new SourcesIdentity(), (SourcesProcessor)new SourcesIdentity());
        this.runRegistration((Registration<SourceAndConverter<?>[]>)this.zPositioner, (SourcesProcessor)new SourcesIdentity(), (SourcesProcessor)new SourcesIdentity());
        this.waitForEndOfTasks();
        this.updateZPosition();
        this.positionChanged();
        this.computeZThickness();
        try {
            SourceAndConverter rootSac = SourceAndConverterInspector.getRootSourceAndConverter(this.original_sacs[0]);
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(rootSac, "SPIMDATA") == null) {
                this.name = rootSac.getSpimSource().getName();
            } else {
                AbstractSpimData asd = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSac, (String)"SPIMDATA")).asd;
                int viewSetupId = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSac, (String)"SPIMDATA")).setupId;
                BasicViewSetup bvs = (BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(viewSetupId);
                this.name = bvs.getAttribute(ImageName.class) != null ? ((ImageName)bvs.getAttribute(ImageName.class)).getName() : rootSac.getSpimSource().getName();
            }
        }
        catch (Exception e) {
            this.name = "Slice name couldn't be found";
            mp.warningMessageForUser.accept("Slice naming issue", "Couldn't name slice, empty name chosen");
            e.printStackTrace();
        }
    }

    private void positionChanged() {
    }

    public double getZThicknessCorrection() {
        return this.zThicknessCorrection;
    }

    public double getZShiftCorrection() {
        return this.zShiftCorrection;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SourceAndConverter<?>[] getRegisteredSources() {
        return this.registered_sacs;
    }

    public double getSlicingAxisPosition() {
        return this.slicingAxisPosition;
    }

    protected void setSlicingAxisPosition(double newSlicingAxisPosition) {
        this.slicingAxisPosition = newSlicingAxisPosition;
        try {
            this.updateZPosition();
        }
        catch (Exception e) {
            System.out.println("CAUGHT ERROR IN UPDATE POSITION (You can safely ignore it, it will just affect the display temporarily)" + e.getMessage());
        }
    }

    public void setSliceThickness(double zBeginInMm, double zEndInMm) {
        if (this.slicingAxisPosition < zBeginInMm || this.slicingAxisPosition > zEndInMm) {
            this.mp.errorMessageForUser.accept("Wrong slice bounds.", "Cannot set slice bounds");
            return;
        }
        if (zBeginInMm > zEndInMm) {
            this.mp.errorMessageForUser.accept("Wrong slice bounds.", "z(End) inferior to z(Begin). Cannot set slice bounds");
            return;
        }
        this.setSliceThickness(zEndInMm - zBeginInMm);
        this.zShiftCorrection = (zEndInMm + zBeginInMm) / 2.0 - this.slicingAxisPosition;
        this.updateZPosition();
    }

    public void setSliceThickness(double sizeInMm) {
        RealPoint pt1 = new RealPoint(3);
        RealPoint pt2 = new RealPoint(3);
        SourceAndConverter sourceUsedForInitialMeasurement = this.registered_sacs_sequence.get((int)1).sacs[0];
        long[] dimensions = new long[3];
        sourceUsedForInitialMeasurement.getSpimSource().getSource(0, 0).dimensions(dimensions);
        pt2.setPosition(dimensions);
        AffineTransform3D at3D = new AffineTransform3D();
        sourceUsedForInitialMeasurement.getSpimSource().getSourceTransform(0, 0, at3D);
        at3D.apply((RealLocalizable)pt1, (RealPositionable)pt1);
        at3D.apply((RealLocalizable)pt2, (RealPositionable)pt2);
        double currentZSliceOccupancy = Math.abs(pt1.getDoublePosition(2) - pt2.getDoublePosition(2));
        if (currentZSliceOccupancy == 0.0) {
            this.mp.errorMessageForUser.accept("Slice thickness error!", "Error : slice thickness is 0! Cannot set slice thickness");
            return;
        }
        this.zThicknessCorrection = sizeInMm / currentZSliceOccupancy;
        this.computeZThickness();
        this.updateZPosition();
    }

    public double getThicknessInMm() {
        return this.thicknessInMm;
    }

    private void computeZThickness() {
        RealPoint pt1 = new RealPoint(3);
        RealPoint pt2 = new RealPoint(3);
        SourceAndConverter sourceUsedForInitialMeasurement = this.registered_sacs_sequence.get((int)1).sacs[0];
        long[] dimensions = new long[3];
        sourceUsedForInitialMeasurement.getSpimSource().getSource(0, 0).dimensions(dimensions);
        pt2.setPosition(dimensions);
        AffineTransform3D at3D = new AffineTransform3D();
        sourceUsedForInitialMeasurement.getSpimSource().getSourceTransform(0, 0, at3D);
        at3D.apply((RealLocalizable)pt1, (RealPositionable)pt1);
        at3D.apply((RealLocalizable)pt2, (RealPositionable)pt2);
        double currentZSliceOccupancy = Math.abs(pt1.getDoublePosition(2) - pt2.getDoublePosition(2));
        this.thicknessInMm = this.zThicknessCorrection * currentZSliceOccupancy;
    }

    public SourceAndConverter<?>[] getOriginalSources() {
        return this.original_sacs;
    }

    public void select() {
        if (!this.isSelected) {
            this.isSelected = true;
            this.mp.sliceSelected(this);
        }
    }

    public void deSelect() {
        if (this.isSelected) {
            this.isSelected = false;
            this.mp.sliceDeselected(this);
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public int getIndex() {
        return this.currentSliceIndex;
    }

    private void updateZPosition() {
        AffineTransform3D zShiftAffineTransform = new AffineTransform3D();
        zShiftAffineTransform.scale(1.0, 1.0, this.zThicknessCorrection);
        zShiftAffineTransform.translate(new double[]{0.0, 0.0, this.slicingAxisPosition + this.zShiftCorrection});
        this.zPositioner.setAffineTransform(zShiftAffineTransform);
        this.si.updateBox();
        this.mp.positionZChanged(this);
    }

    protected void setIndex(int idx) {
        this.currentSliceIndex = idx;
    }

    public String getActionState(CancelableAction action) {
        if (action != null && action == this.actionInProgress) {
            return "(pending)";
        }
        if (this.mapActionTask.containsKey(action)) {
            if (this.tasks.contains(this.mapActionTask.get(action))) {
                CompletableFuture<Boolean> future = this.tasks.get(this.tasks.indexOf(this.mapActionTask.get(action)));
                if (future.isDone()) {
                    return "(done)";
                }
                if (future.isCancelled()) {
                    return "(cancelled)";
                }
                return "(locked)";
            }
            return "future not found";
        }
        return "unknown action";
    }

    protected boolean exactMatch(List<SourceAndConverter<?>> testSacs) {
        HashSet originalSacsSet = new HashSet(Arrays.asList(this.original_sacs));
        return originalSacsSet.containsAll(testSacs) && testSacs.containsAll(originalSacsSet);
    }

    protected boolean isContainingAny(Collection<SourceAndConverter<?>> sacs) {
        HashSet originalSacsSet = new HashSet();
        originalSacsSet.addAll(Arrays.asList(this.original_sacs));
        return sacs.stream().distinct().anyMatch(originalSacsSet::contains);
    }

    public void waitForEndOfTasks() {
        if (this.tasks.size() > 0) {
            try {
                CompletableFuture<Boolean> lastTask = this.tasks.get(this.tasks.size() - 1);
                lastTask.get();
            }
            catch (Exception e) {
                this.mp.errorMessageForUser.accept("Tasks were cancelled for slice " + this, "Error:" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public boolean waitForEndOfAction(CancelableAction action) {
        if (!this.mapActionTask.containsKey(action)) {
            logger.debug("(waitForEndOfAction) action " + action + " not found or unrelated to slice " + this);
            return false;
        }
        try {
            return this.mapActionTask.get(action).get();
        }
        catch (InterruptedException e) {
            logger.debug("(waitForEndOfAction) slice [" + this + "] interrupted action " + action + " " + e.getMessage());
            return false;
        }
        catch (ExecutionException e) {
            logger.debug("(waitForEndOfAction) slice [\"+this+\"] execution exception for action " + action + " " + e.getMessage());
            return false;
        }
    }

    public void transformSourceOrigin(AffineTransform3D at3D) {
        this.preTransform.setAffineTransform(at3D);
        this.mp.slicePreTransformChanged(this);
    }

    public AffineTransform3D getTransformSourceOrigin() {
        return this.preTransform.getAffineTransform();
    }

    public void rotateSourceOrigin(int axis, double angle) {
        AffineTransform3D at3d = this.preTransform.getAffineTransform();
        at3d.rotate(axis, angle);
        this.transformSourceOrigin(at3d);
    }

    public int getNumberOfRegistrations() {
        return this.registrations.size() - 3;
    }

    protected boolean hideLastMirrorRegistration() {
        boolean performed = false;
        for (int iReg = this.registered_sacs_sequence.size() - 1; iReg > 0; --iReg) {
            RegistrationAndSources ras = this.registered_sacs_sequence.get(iReg);
            if (!(ras.sacs[0].getSpimSource() instanceof WarpedSource)) continue;
            WarpedSource ws = (WarpedSource)ras.sacs[0].getSpimSource();
            RealTransform transform = ws.getTransform();
            if (transform instanceof BoundedRealTransform) {
                transform = ((BoundedRealTransform)transform).getTransform();
            }
            if (!(transform instanceof MirrorXTransform) || !ws.isTransformed()) continue;
            performed = true;
            for (int iCh = 0; iCh < ras.sacs.length; ++iCh) {
                ((WarpedSource)ras.sacs[iCh].getSpimSource()).setIsTransformed(false);
                if (ras.sacs[iCh].asVolatile() == null) continue;
                ((WarpedSource)ras.sacs[iCh].asVolatile().getSpimSource()).setIsTransformed(false);
            }
            break;
        }
        if (!performed) {
            logger.error("No mirror transformation found!");
        }
        return performed;
    }

    protected boolean restoreLastMirrorRegistration() {
        boolean performed = false;
        for (RegistrationAndSources ras : this.registered_sacs_sequence) {
            if (!(ras.sacs[0].getSpimSource() instanceof WarpedSource)) continue;
            WarpedSource ws = (WarpedSource)ras.sacs[0].getSpimSource();
            RealTransform transform = ws.getTransform();
            if (transform instanceof BoundedRealTransform) {
                transform = ((BoundedRealTransform)transform).getTransform();
            }
            if (!(transform instanceof MirrorXTransform) || ws.isTransformed()) continue;
            performed = true;
            for (int iCh = 0; iCh < ras.sacs.length; ++iCh) {
                ((WarpedSource)ras.sacs[iCh].getSpimSource()).setIsTransformed(true);
                if (ras.sacs[iCh].asVolatile() == null) continue;
                ((WarpedSource)ras.sacs[iCh].asVolatile().getSpimSource()).setIsTransformed(true);
            }
        }
        if (!performed) {
            logger.error("No mirror transformation to restore!");
        }
        return performed;
    }

    protected void appendRegistration(Registration<SourceAndConverter<?>[]> reg) {
        if (reg instanceof RealTransformSourceAndConverterRegistration) {
            RealTransformSourceAndConverterRegistration sreg = (RealTransformSourceAndConverterRegistration)reg;
            if (!(sreg.getRealTransform() instanceof BoundedRealTransform)) {
                if (sreg.getRealTransform() instanceof InvertibleRealTransform) {
                    BoundedRealTransform brt = new BoundedRealTransform((InvertibleRealTransform)sreg.getRealTransform(), (RealInterval)this.si);
                    this.si.updateBox();
                    sreg.setRealTransform((RealTransform)brt);
                }
            } else {
                RealTransform rt = ((BoundedRealTransform)sreg.getRealTransform()).getTransform();
                BoundedRealTransform brt = new BoundedRealTransform((InvertibleRealTransform)rt, (RealInterval)this.si);
                this.si.updateBox();
                sreg.setRealTransform((RealTransform)brt);
            }
        }
        this.registered_sacs = (SourceAndConverter[])reg.getTransformedImageMovingToFixed(this.registered_sacs);
        this.registered_sacs_sequence.add(new RegistrationAndSources(reg, this.registered_sacs));
        this.registrations.add(reg);
    }

    public void sourcesChanged() {
        this.mp.notifySourcesChanged(this);
    }

    private boolean performRegistration(Registration<SourceAndConverter<?>[]> reg, SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving) {
        reg.setFixedImage(preprocessFixed.apply((Object)this.mp.reslicedAtlas.nonExtendedSlicedSources));
        reg.setMovingImage(preprocessMoving.apply(this.registered_sacs));
        SourcesProcessor fixedProcessor = SourcesProcessorHelper.removeChannelsSelect((SourcesProcessor)preprocessFixed);
        fixedProcessor = new SourcesProcessComposer(fixedProcessor, (SourcesProcessor)new SourcesChannelsSelect(this.mp.reslicedAtlas.getLabelSourceIndex()));
        reg.setFixedMask(fixedProcessor.apply((Object)this.mp.reslicedAtlas.nonExtendedSlicedSources));
        boolean out = reg.register();
        if (!out) {
            this.mp.errorMessageForUser.accept("Error during registration", "Registration " + reg.getClass().getSimpleName() + " errored:\n " + reg.getExceptionMessage());
        } else {
            this.appendRegistration(reg);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runRegistration(Registration<SourceAndConverter<?>[]> reg, SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving) {
        if (RegistrationPluginHelper.isManual(reg)) {
            Object object = MultiSlicePositioner.manualActionLock;
            synchronized (object) {
                return this.performRegistration(reg, preprocessFixed, preprocessMoving);
            }
        }
        return this.performRegistration(reg, preprocessFixed, preprocessMoving);
    }

    protected boolean removeRegistration(Registration reg) {
        if (this.registrations.contains(reg)) {
            int idx = this.registrations.indexOf(reg);
            if (idx == this.registrations.size() - 1) {
                this.registrations.remove(reg);
                this.registered_sacs_sequence.remove(this.registered_sacs_sequence.get(this.registered_sacs_sequence.size() - 1));
                this.registered_sacs = this.registered_sacs_sequence.get((int)(this.registered_sacs_sequence.size() - 1)).sacs;
                this.sourcesChanged();
                return true;
            }
            logger.error("Could not remove a registration which is not the last one.");
            return false;
        }
        logger.error("Registration not found, can't remove it.");
        return false;
    }

    protected void enqueueRunAction(CancelableAction action, Runnable postRun, boolean runInExtraThread) {
        CompletableFuture<Boolean> startingPoint = this.tasks.size() == 0 ? CompletableFuture.supplyAsync(() -> true) : this.tasks.get(this.tasks.size() - 1);
        Executor e = this.executor;
        if (runInExtraThread) {
            e = new ThreadPerTaskExecutor();
        }
        this.tasks.add((CompletableFuture<Boolean>)startingPoint.thenApplyAsync(out -> {
            if (out.booleanValue()) {
                this.mp.addTask();
                this.actionInProgress = action;
                logger.debug(this + ": action " + action + " started");
                for (MultiSlicePositioner.SliceChangeListener sliceChangeListener : this.mp.listeners) {
                    sliceChangeListener.actionStarted(action.getSliceSources(), action);
                }
                boolean result = action.run();
                for (MultiSlicePositioner.SliceChangeListener listener : this.mp.listeners) {
                    listener.actionFinished(action.getSliceSources(), action, result);
                }
                logger.debug(this + ": action " + action + " result " + result);
                if (result) {
                    this.actionInProgress = null;
                    postRun.run();
                } else {
                    this.mp.errorMessageForUser.accept("Action failed", action.toString());
                    if (this.mapActionTask.containsKey(action)) {
                        CompletableFuture<Boolean> completableFuture = this.mapActionTask.get(action);
                        this.tasks.remove(completableFuture);
                    }
                    this.mapActionTask.remove(action);
                    this.mp.userActions.remove(action);
                    this.mp.getActionsFromSlice(this).remove(action);
                }
                this.mp.removeTask();
                return result;
            }
            this.mp.errorMessageForUser.accept("Action not started", "Upstream tasked failed, canceling action " + action);
            if (this.mapActionTask.containsKey(action)) {
                CompletableFuture<Boolean> future = this.mapActionTask.get(action);
                this.tasks.remove(future);
            }
            this.mapActionTask.remove(action);
            this.mp.userActions.remove(action);
            this.mp.getActionsFromSlice(this).remove(action);
            return false;
        }, e));
        this.mapActionTask.put(action, this.tasks.get(this.tasks.size() - 1));
    }

    protected void enqueueCancelAction(CancelableAction action, Runnable postRun) {
        if (this.mapActionTask.containsKey(action)) {
            if (this.mapActionTask.get(action).isDone() || action != null && action == this.actionInProgress) {
                if (action == this.actionInProgress) {
                    if (this.actionInProgress instanceof RegisterSliceAction) {
                        this.mp.addTask();
                        this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelStarted(action.getSliceSources(), action));
                        logger.debug("Aborting register slice action :  " + this.actionInProgress);
                        ((RegisterSliceAction)this.actionInProgress).getRegistration().abort();
                        boolean result = action.cancel();
                        if (this.mapActionTask.containsKey(action)) {
                            CompletableFuture<Boolean> future = this.mapActionTask.get(action);
                            this.tasks.remove(future);
                        }
                        this.mapActionTask.remove(action);
                        this.mp.userActions.remove(action);
                        postRun.run();
                        this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelFinished(action.getSliceSources(), action, result));
                        this.mp.removeTask();
                    }
                } else {
                    CompletableFuture<Boolean> startingPoint = this.tasks.size() == 0 ? CompletableFuture.supplyAsync(() -> true) : this.tasks.get(this.tasks.size() - 1);
                    this.tasks.add((CompletableFuture<Boolean>)startingPoint.thenApplyAsync(out -> {
                        if (out.booleanValue()) {
                            this.mp.addTask();
                            this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelStarted(action.getSliceSources(), action));
                            boolean result = action.cancel();
                            this.tasks.remove(this.mapActionTask.get(action));
                            this.mapActionTask.remove(action);
                            postRun.run();
                            this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelFinished(action.getSliceSources(), action, result));
                            this.mp.removeTask();
                            return result;
                        }
                        logger.error("Weird edge case!");
                        return false;
                    }));
                }
            } else {
                this.mp.addTask();
                this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelStarted(action.getSliceSources(), action));
                boolean result = this.mapActionTask.get(action).cancel(true);
                this.tasks.remove(this.mapActionTask.get(action));
                this.mapActionTask.remove(action);
                postRun.run();
                this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelFinished(action.getSliceSources(), action, result));
                this.mp.removeTask();
            }
        } else if (action instanceof CreateSliceAction) {
            this.mp.addTask();
            this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelStarted(action.getSliceSources(), action));
            this.waitForEndOfTasks();
            boolean result = action.cancel();
            this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelFinished(action.getSliceSources(), action, result));
            this.mp.removeTask();
        } else {
            this.mp.errorMessageForUser.accept("Can't cancel action", "Unregistered action " + action);
        }
    }

    <T extends NumericType<T> & NativeType<T>> void computeLabelImage(AffineTransform3D at3D) {
        this.labelImageBeingComputed = true;
        SourceAndConverter singleSliceModel = new EmptySourceAndConverterCreator("SlicingModel", at3D, (long)this.mp.nPixX, (long)this.mp.nPixY, 1L).get();
        SourceResampler resampler = new SourceResampler(null, singleSliceModel, this + "_Model", false, false, false, 0);
        AffineTransform3D translateZ = new AffineTransform3D();
        translateZ.translate(new double[]{0.0, 0.0, -this.slicingAxisPosition});
        SourceAndConverter sac = this.mp.reslicedAtlas.nonExtendedSlicedSources[this.mp.reslicedAtlas.getLabelSourceIndex()];
        sac = resampler.apply(sac);
        sac = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)translateZ, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(sac, 0));
        HashMap<SourceAndConverter, Integer> mapSacToMml = new HashMap<SourceAndConverter, Integer>();
        mapSacToMml.put(sac, 0);
        ArrayList<SourceAndConverter> sourceList = new ArrayList<SourceAndConverter>();
        sourceList.add(sac);
        if (!(((SourceAndConverter)sourceList.get(0)).getSpimSource().getType() instanceof IntegerType)) {
            logger.error("Label image is not integer typed! Type = " + ((SourceAndConverter)sourceList.get(0)).getSpimSource().getType().getClass().getSimpleName());
            return;
        }
        RandomAccessibleInterval raiLabel = ((SourceAndConverter)sourceList.get(0)).getSpimSource().getSource(0, 0);
        RandomAccessibleInterval<FloatType> cvtRai = this.convertedRai(raiLabel);
        this.impLabelImage = ImageJFunctions.wrap(cvtRai, (String)"Labels");
        this.cvtRoisOrigin = SliceSources.constructROIsFromImgLabel(this.mp.getAtlas().getOntology(), this.impLabelImage);
        this.at3DLastLabelImage = at3D;
        this.labelImageBeingComputed = false;
        sac = this.mp.reslicedAtlas.nonExtendedSlicedSources[this.mp.reslicedAtlas.getLeftRightSourceIndex()];
        sac = resampler.apply(sac);
        sac = SourceTransformHelper.createNewTransformedSourceAndConverter((AffineTransform3D)translateZ, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(sac, 0));
        mapSacToMml = new HashMap();
        mapSacToMml.put(sac, 0);
        sourceList = new ArrayList();
        sourceList.add(sac);
        ImagePlus leftRightImage = ImagePlusHelper.wrap(sourceList.stream().map(s -> s).collect(Collectors.toList()), mapSacToMml, (int)0, (int)1, (int)1);
        this.leftRightOrigin.set((Object)ConvertibleRois.labelImageToRoiArrayKeepSinglePixelPrecision((ImagePlus)leftRightImage));
    }

    private RandomAccessibleInterval<FloatType> convertedRai(RandomAccessibleInterval<IntegerType<?>> raiLabel) {
        Converter cvt = new Converter<IntegerType<?>, FloatType>(){

            public void convert(IntegerType<?> integerType, FloatType floatType) {
                floatType.set(Float.intBitsToFloat(integerType.getInteger()));
            }
        };
        return Converters.convert(raiLabel, (Converter)cvt, (Type)new FloatType());
    }

    void prepareExport(String namingChoice, int iChannel) {
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.translate(new double[]{(double)(-this.mp.nPixX) / 2.0, (double)(-this.mp.nPixY) / 2.0, 0.0});
        at3D.scale(this.mp.sizePixX, this.mp.sizePixY, this.mp.sizePixZ);
        at3D.translate(new double[]{0.0, 0.0, this.slicingAxisPosition});
        boolean computeLabelImageNecessary = true;
        if (!this.labelImageBeingComputed && this.at3DLastLabelImage != null && Arrays.equals(at3D.getRowPackedCopy(), this.at3DLastLabelImage.getRowPackedCopy()) && this.mp.getReslicedAtlas().getRotateX() == this.rotXLastExport && this.mp.getReslicedAtlas().getRotateY() == this.rotYLastExport) {
            logger.debug("Slice " + this + ": Label image already computed, skips computation.");
            computeLabelImageNecessary = false;
        }
        if (computeLabelImageNecessary) {
            logger.debug("Slice " + this + ": Computing label image BEGIN.");
            this.rotXLastExport = this.mp.getReslicedAtlas().getRotateX();
            this.rotYLastExport = this.mp.getReslicedAtlas().getRotateY();
            this.computeLabelImage(at3D);
            logger.debug("Slice " + this + ": Computing label image END.");
        }
        this.computeTransformedRois(iChannel);
        IJShapeRoiArray roiList = (IJShapeRoiArray)this.cvtRoisTransformed.to(IJShapeRoiArray.class);
        for (int i = 0; i < roiList.rois.size(); ++i) {
            CompositeFloatPoly roi = (CompositeFloatPoly)roiList.rois.get(i);
            int atlasId = Integer.parseInt(roi.name);
            AtlasNode node = this.mp.getAtlas().getOntology().getNodeFromId(atlasId);
            roi.name = (String)node.data().get(namingChoice);
            int[] color = node.getColor();
            roi.color = new Color(color[0], color[1], color[2], color[3]);
        }
        IJShapeRoiArray roiArray = (IJShapeRoiArray)this.leftRightTranformed.to(IJShapeRoiArray.class);
        for (CompositeFloatPoly cfp : roiArray.rois) {
            int value = Integer.parseInt(cfp.getRoi().getName());
            if (value == this.mp.getAtlas().getMap().labelLeft()) {
                logger.debug("Left region detected");
                Roi left = cfp.getRoi();
                left.setStrokeColor(new Color(0, 255, 0));
                left.setName("Left");
                roiList.rois.add(new CompositeFloatPoly(left));
                continue;
            }
            if (value == this.mp.getAtlas().getMap().labelRight()) {
                logger.debug("Right region detected");
                Roi right = cfp.getRoi();
                right.setStrokeColor(new Color(255, 0, 255));
                right.setName("Right");
                roiList.rois.add(new CompositeFloatPoly(right));
                continue;
            }
            logger.error("Unrecognized left right label : " + value);
        }
    }

    public void exportRegionsToROIManager(String namingChoice) {
        this.prepareExport(namingChoice, 0);
        this.cvtRoisTransformed.to(RoiManager.class);
    }

    public List<Roi> getRois(String namingChoice) {
        this.prepareExport(namingChoice, 0);
        IJShapeRoiArray roiArray = (IJShapeRoiArray)this.cvtRoisTransformed.to(IJShapeRoiArray.class);
        ArrayList<Roi> rois = new ArrayList<Roi>();
        for (CompositeFloatPoly cfp : roiArray.rois) {
            rois.add(cfp.getRoi());
        }
        return rois;
    }

    public void exportToQuPathProject(boolean erasePreviousFile) {
        if (this.simpleQuPathExportCase()) {
            this.prepareExport("id", 0);
            ImageJRoisFile ijroisfile = (ImageJRoisFile)this.cvtRoisTransformed.to(ImageJRoisFile.class);
            this.storeInQuPathProjectIfExists(ijroisfile, erasePreviousFile);
        } else {
            HashSet<File> dataEntries = new HashSet<File>();
            for (int iCh = 0; iCh < this.nChannels; ++iCh) {
                File dataEntryFolderTest;
                SourceAndConverter<?> source = this.original_sacs[iCh];
                if (!QuPathBdvHelper.isSourceLinkedToQuPath(source) || dataEntries.contains(dataEntryFolderTest = QuPathBdvHelper.getDataEntryFolder(source))) continue;
                dataEntries.add(dataEntryFolderTest);
                this.exportToQuPathProjectAdvanced(iCh, erasePreviousFile);
            }
        }
    }

    private InvertibleRealTransform getTransformedSequenceToRoot(SourceAndConverter<?> source) {
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        this.appendPreviousTransform(source.getSpimSource(), irts);
        return irts;
    }

    private void appendPreviousTransform(Source<?> source, InvertibleRealTransformSequence sequence) {
        if (source.getClass().equals(SpimSource.class)) {
            AbstractSpimSource castSource = (AbstractSpimSource)source;
            AffineTransform3D transform = new AffineTransform3D();
            castSource.getSourceTransform(0, 0, transform);
            sequence.add((RealTransform)transform.inverse());
        } else if (source.getClass().equals(TransformedSource.class)) {
            TransformedSource castSource = (TransformedSource)source;
            AffineTransform3D transform = new AffineTransform3D();
            castSource.getSourceTransform(0, 0, transform);
            sequence.add((RealTransform)transform.inverse());
            this.appendPreviousTransform(castSource.getWrappedSource(), sequence);
        } else if (source.getClass().equals(WarpedSource.class)) {
            WarpedSource castSource = (WarpedSource)source;
            RealTransform rt = castSource.getTransform().copy();
            if (rt instanceof InvertibleRealTransform) {
                sequence.add((RealTransform)((InvertibleRealTransform)rt));
                this.appendPreviousTransform(castSource.getWrappedSource(), sequence);
            } else {
                logger.error("The transform of the warped source is not invertible! ");
            }
        } else if (source.getClass().equals(ResampledSource.class)) {
            logger.error("Unhandled source of type " + source.getClass().getSimpleName());
        } else {
            logger.error("Unknown source of type " + source.getClass().getSimpleName());
        }
    }

    private void exportToQuPathProjectAdvanced(int iCh, boolean erasePreviousFile) {
        this.prepareExport("id", iCh);
        ImageJRoisFile ijroisfile = (ImageJRoisFile)this.cvtRoisTransformed.to(ImageJRoisFile.class);
        SourceAndConverter<?> source = this.original_sacs[iCh];
        File dataEntryFolder = QuPathBdvHelper.getDataEntryFolder(source);
        logger.debug("DataEntryFolder = " + dataEntryFolder);
        InvertibleRealTransform irts = this.getTransformedSequenceToRoot(source);
        try {
            String projectFolderPath = QuPathBdvHelper.getProjectFile(this.original_sacs[iCh]).getParent();
            logger.debug("QuPath Project Folder = " + projectFolderPath);
            File f = new File(dataEntryFolder, "ABBA-RoiSet-" + this.mp.getAtlas().getName() + ".zip");
            this.mp.infoMessageForUser.accept("Export to QuPath", "Save " + this.name + " ROIs to quPath project " + f.getAbsolutePath());
            if (f.exists() && !erasePreviousFile) {
                this.mp.errorMessageForUser.accept("Export to QuPath error", "Error : QuPath ROI file already exists");
            }
            if (!f.exists() || erasePreviousFile) {
                if (f.exists()) {
                    Files.delete(Paths.get(f.getAbsolutePath(), new String[0]));
                }
                Files.copy(Paths.get(ijroisfile.f.getAbsolutePath(), new String[0]), Paths.get(f.getAbsolutePath(), new String[0]), new CopyOption[0]);
                SliceSources.writeOntotogyIfNotPresent(this.mp, projectFolderPath);
            }
        }
        catch (Exception e) {
            this.mp.errorMessageForUser.accept("Export to QuPath error", "Error in QuPath export: " + e.getMessage() + "\n Please also check the stack trace.");
            e.printStackTrace();
        }
        try {
            InvertibleRealTransformSequence fullSequence;
            RealTransform transform = this.getSlicePhysicalToCCFRealTransform(0, this.getTolerance(), this.getMaxIteration());
            if (transform instanceof InvertibleRealTransform) {
                fullSequence = new InvertibleRealTransformSequence();
                fullSequence.add((RealTransform)((InvertibleRealTransform)transform));
                fullSequence.add((RealTransform)irts);
            } else {
                fullSequence = new RealTransformSequence();
                ((RealTransformSequence)fullSequence).add(transform);
                ((RealTransformSequence)fullSequence).add((RealTransform)irts);
            }
            if (fullSequence != null) {
                File ftransform = new File(dataEntryFolder, "ABBA-Transform-" + this.mp.getAtlas().getName() + ".json");
                this.mp.infoMessageForUser.accept("Export to Qupath", "Save transformation to quPath project " + ftransform.getAbsolutePath());
                Gson gson = ScijavaGsonHelper.getGsonBuilder((Context)this.mp.scijavaCtx, (boolean)false).setPrettyPrinting().create();
                String transform_string = gson.toJson((Object)fullSequence, RealTransform.class);
                if (ftransform.exists()) {
                    if (erasePreviousFile) {
                        Files.delete(Paths.get(ftransform.getAbsolutePath(), new String[0]));
                        FileWriter writer = new FileWriter(ftransform.getAbsolutePath());
                        writer.write(transform_string);
                        writer.flush();
                        writer.close();
                    } else {
                        this.mp.errorMessageForUser.accept("Export to QuPath error", "Error : Transformation file already exists");
                    }
                } else {
                    FileWriter writer = new FileWriter(ftransform.getAbsolutePath());
                    writer.write(transform_string);
                    writer.flush();
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            this.mp.errorMessageForUser.accept("Export to QuPath error", "Error while saving transform file!Message: " + e.getMessage() + "\nPlease also check the stack trace");
            e.printStackTrace();
        }
    }

    private boolean simpleQuPathExportCase() {
        File dataEntryFolder = null;
        for (SourceAndConverter<?> source : this.original_sacs) {
            if (!QuPathBdvHelper.isSourceLinkedToQuPath(source)) {
                this.mp.errorMessageForUser.accept("Export to QuPath error!", "Slice " + this + " not linked to a QuPath dataset");
                return false;
            }
            try {
                File dataEntryFolderTest = QuPathBdvHelper.getDataEntryFolder(source);
                if (dataEntryFolder == null) {
                    dataEntryFolder = dataEntryFolderTest;
                    continue;
                }
                if (dataEntryFolder.equals(dataEntryFolderTest)) continue;
                logger.info("Slice " + this + " targets multiple QuPath entries.");
                return false;
            }
            catch (Exception e) {
                this.mp.errorMessageForUser.accept("Export to QuPath error", e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        for (SourceAndConverter<?> source : this.original_sacs) {
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(source, "SPIMDATA") != null) continue;
            logger.info("Slice " + this + " is not directly a QuPath project entry. It could have been transformed before being imported in ABBA");
            return false;
        }
        return true;
    }

    public IJShapeRoiArray getOriginalAtlasRegions(String namingChoice) {
        this.prepareExport(namingChoice, 0);
        return (IJShapeRoiArray)this.cvtRoisOrigin.to(IJShapeRoiArray.class);
    }

    public void exportRegionsToFile(String namingChoice, File dirOutput, boolean erasePreviousFile) {
        this.prepareExport(namingChoice, 0);
        ImageJRoisFile ijroisfile = (ImageJRoisFile)this.cvtRoisTransformed.to(ImageJRoisFile.class);
        File f = new File(dirOutput, this + ".zip");
        try {
            if (f.exists()) {
                if (erasePreviousFile) {
                    Files.delete(Paths.get(f.getAbsolutePath(), new String[0]));
                    Files.copy(Paths.get(ijroisfile.f.getAbsolutePath(), new String[0]), Paths.get(f.getAbsolutePath(), new String[0]), new CopyOption[0]);
                } else {
                    this.mp.warningMessageForUser.accept("ROI file not saved", "ROI File already exists!");
                }
            } else {
                Files.copy(Paths.get(ijroisfile.f.getAbsolutePath(), new String[0]), Paths.get(f.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RealTransform getSlicePixToCCFRealTransform() {
        return this.getSlicePixToCCFRealTransform(0, this.getTolerance(), this.getMaxIteration());
    }

    boolean isWrapped(RealTransform rt) {
        return rt instanceof BoundedRealTransform || rt instanceof WrappedIterativeInvertibleRealTransform || rt instanceof Wrapped2DTransformAs3D;
    }

    RealTransform getWrapped(RealTransform rt) {
        if (rt instanceof BoundedRealTransform) {
            return ((BoundedRealTransform)rt).getTransform();
        }
        if (rt instanceof WrappedIterativeInvertibleRealTransform) {
            return ((WrappedIterativeInvertibleRealTransform)rt).getTransform();
        }
        if (rt instanceof Wrapped2DTransformAs3D) {
            return ((Wrapped2DTransformAs3D)rt).getTransform();
        }
        return rt;
    }

    void fixOptimizer(RealTransform rt, double tolerance, int maxIteration) {
        RealTransform transform = rt;
        while (this.isWrapped(transform)) {
            if (!((transform = this.getWrapped(transform)) instanceof WrappedIterativeInvertibleRealTransform)) continue;
            ((WrappedIterativeInvertibleRealTransform)transform).getOptimzer().setTolerance(tolerance);
            ((WrappedIterativeInvertibleRealTransform)transform).getOptimzer().setMaxIters(maxIteration);
            break;
        }
    }

    double getTolerance() {
        return this.mp.getAtlas().getMap().getAtlasPrecisionInMillimeter() / 5.0;
    }

    int getMaxIteration() {
        return 200;
    }

    public RealTransform getSlicePixToCCFRealTransform(int resolutionLevel, double tolerance, int maxIteration) {
        RealTransformSequence rts = new RealTransformSequence();
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        AffineTransform3D at3D = this.mp.getAffineTransformFromAlignerToAtlas();
        rts.add((RealTransform)at3D.inverse().copy());
        irts.add((RealTransform)at3D.inverse().copy());
        this.addAllRegistrations(rts, irts, tolerance, maxIteration);
        this.original_sacs[0].getSpimSource().getSourceTransform(0, resolutionLevel, at3D);
        rts.add((RealTransform)at3D.inverse().copy());
        if (irts != null) {
            irts.add((RealTransform)at3D.inverse().copy());
        }
        return irts == null ? rts : irts;
    }

    public RealTransform getSlicePhysicalToCCFRealTransform(int resolutionLevel, double tolerance, int maxIteration) {
        RealTransformSequence rts = new RealTransformSequence();
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        AffineTransform3D at3D = this.mp.getAffineTransformFromAlignerToAtlas();
        rts.add((RealTransform)at3D.inverse().copy());
        irts.add((RealTransform)at3D.inverse().copy());
        this.addAllRegistrations(rts, irts, tolerance, maxIteration);
        return irts == null ? rts : irts;
    }

    private void addAllRegistrations(RealTransformSequence rts, InvertibleRealTransformSequence irts, double tolerance, int maxIteration) {
        Collections.reverse(this.registrations);
        for (Registration<SourceAndConverter<?>[]> reg : this.registrations) {
            RealTransform current = reg.getTransformAsRealTransform();
            if (current == null) {
                this.mp.errorMessageForUser.accept("Error during trnasformation computation", "Error : null registration found!");
                return;
            }
            if (current instanceof BoundedRealTransform && ((BoundedRealTransform)current).getTransform() instanceof MirrorXTransform || current instanceof MirrorXTransform) continue;
            RealTransform copied = current.copy();
            this.fixOptimizer(copied, tolerance, maxIteration);
            rts.add(copied);
            if (copied instanceof InvertibleRealTransform && irts != null) {
                irts.add((RealTransform)((InvertibleRealTransform)copied));
                continue;
            }
            irts = null;
        }
        Collections.reverse(this.registrations);
    }

    private void storeInQuPathProjectIfExists(ImageJRoisFile ijroisfile, boolean erasePreviousFile) {
        if (!QuPathBdvHelper.isSourceLinkedToQuPath(this.original_sacs[0])) {
            this.mp.errorMessageForUser.accept("QuPath export error", "Slice " + this + " not linked to a QuPath dataset");
        }
        File dataEntryFolder = null;
        try {
            dataEntryFolder = QuPathBdvHelper.getDataEntryFolder(this.original_sacs[0]);
            logger.debug("DataEntryFolder = " + dataEntryFolder);
            String projectFolderPath = QuPathBdvHelper.getProjectFile(this.original_sacs[0]).getParent();
            logger.debug("QuPath Project Folder = " + projectFolderPath);
            File f = new File(dataEntryFolder, "ABBA-RoiSet-" + this.mp.getAtlas().getName() + ".zip");
            this.mp.infoMessageForUser.accept("Export to QuPath", "Save slice ROI to quPath project " + f.getAbsolutePath());
            if (f.exists()) {
                if (erasePreviousFile) {
                    Files.delete(Paths.get(f.getAbsolutePath(), new String[0]));
                    Files.copy(Paths.get(ijroisfile.f.getAbsolutePath(), new String[0]), Paths.get(f.getAbsolutePath(), new String[0]), new CopyOption[0]);
                    SliceSources.writeOntotogyIfNotPresent(this.mp, projectFolderPath);
                    if (this.mp.getAtlas() instanceof AllenBrainAdultMouseAtlasCCF2017Command) {
                        f = new File(dataEntryFolder, "ABBA-RoiSet.zip");
                        if (f.exists()) {
                            Files.delete(Paths.get(f.getAbsolutePath(), new String[0]));
                        }
                        Files.copy(Paths.get(ijroisfile.f.getAbsolutePath(), new String[0]), Paths.get(f.getAbsolutePath(), new String[0]), new CopyOption[0]);
                    }
                } else {
                    this.mp.errorMessageForUser.accept("Export to QuPath error", "Error : QuPath ROI file already exists");
                }
            } else {
                Files.copy(Paths.get(ijroisfile.f.getAbsolutePath(), new String[0]), Paths.get(f.getAbsolutePath(), new String[0]), new CopyOption[0]);
                SliceSources.writeOntotogyIfNotPresent(this.mp, projectFolderPath);
                if (this.mp.getAtlas() instanceof AllenBrainAdultMouseAtlasCCF2017Command) {
                    f = new File(dataEntryFolder, "ABBA-RoiSet.zip");
                    Files.copy(Paths.get(ijroisfile.f.getAbsolutePath(), new String[0]), Paths.get(f.getAbsolutePath(), new String[0]), new CopyOption[0]);
                }
            }
        }
        catch (Exception e) {
            this.mp.errorMessageForUser.accept("QuPath export error", "Error mesage: " + e.getMessage() + "\nPlease also check the stack trace");
            e.printStackTrace();
        }
        try {
            RealTransform transform = this.getSlicePixToCCFRealTransform();
            if (transform != null) {
                File ftransform = new File(dataEntryFolder, "ABBA-Transform-" + this.mp.getAtlas().getName() + ".json");
                this.mp.infoMessageForUser.accept("Export to QuPath", "Save transformation to quPath project " + ftransform.getAbsolutePath());
                Gson gson = ScijavaGsonHelper.getGsonBuilder((Context)this.mp.scijavaCtx, (boolean)false).setPrettyPrinting().create();
                String transform_string = gson.toJson((Object)transform, RealTransform.class);
                if (ftransform.exists()) {
                    if (erasePreviousFile) {
                        Files.delete(Paths.get(ftransform.getAbsolutePath(), new String[0]));
                        FileWriter writer = new FileWriter(ftransform.getAbsolutePath());
                        writer.write(transform_string);
                        writer.flush();
                        writer.close();
                        if (this.mp.getAtlas() instanceof AllenBrainAdultMouseAtlasCCF2017Command) {
                            ftransform = new File(dataEntryFolder, "ABBA-Transform.json");
                            writer = new FileWriter(ftransform.getAbsolutePath());
                            writer.write(transform_string);
                            writer.flush();
                            writer.close();
                        }
                    } else {
                        this.mp.errorMessageForUser.accept("QuPath export", "Error : Transformation file already exists");
                    }
                } else {
                    FileWriter writer = new FileWriter(ftransform.getAbsolutePath());
                    writer.write(transform_string);
                    writer.flush();
                    writer.close();
                    if (this.mp.getAtlas() instanceof AllenBrainAdultMouseAtlasCCF2017Command) {
                        ftransform = new File(dataEntryFolder, "ABBA-Transform.json");
                        writer = new FileWriter(ftransform.getAbsolutePath());
                        writer.write(transform_string);
                        writer.flush();
                        writer.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.mp.errorMessageForUser.accept("QuPath export error", "Error while saving transform file!\n" + e.getMessage() + "\nPlease also check the stack trace");
            e.printStackTrace();
        }
    }

    public static synchronized void writeOntotogyIfNotPresent(MultiSlicePositioner mp, String quPathFilePath) {
        File ontology = new File(quPathFilePath, mp.getAtlas().getName() + "-Ontology.json");
        if (!ontology.exists()) {
            AtlasHelper.saveOntologyToJsonFile((AtlasOntology)mp.getAtlas().getOntology(), (String)ontology.getAbsolutePath());
        }
        if (mp.getAtlas() instanceof AllenBrainAdultMouseAtlasCCF2017Command && !(ontology = new File(quPathFilePath, "AllenMouseBrainOntology.json")).exists()) {
            try {
                URL ontologyURL = mp.getAtlas().getOntology().getDataSource();
                if (ontologyURL.getFile() == null) {
                    mp.errorMessageForUser.accept("Error when writing Atlas ontology", "No ontology file found at location " + ontologyURL);
                    return;
                }
                Path originalOntologyFile = Paths.get(ontologyURL.toURI());
                Files.copy(originalOntologyFile, Paths.get(quPathFilePath, "AllenMouseBrainOntology.json"), new CopyOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        if (!this.name.equals("")) {
            return this.name;
        }
        int index = this.mp.getSlices().indexOf(this);
        return "Slice_" + index;
    }

    private void computeTransformedRois(int iChannel) {
        this.cvtRoisTransformed = new ConvertibleRois();
        this.leftRightTranformed = new ConvertibleRois();
        IJShapeRoiArray arrayIniRegions = (IJShapeRoiArray)this.cvtRoisOrigin.to(IJShapeRoiArray.class);
        this.cvtRoisTransformed.set((Object)arrayIniRegions);
        RealPointList listRegions = (RealPointList)this.cvtRoisTransformed.to(RealPointList.class);
        IJShapeRoiArray arrayIniLeftRight = (IJShapeRoiArray)this.leftRightOrigin.to(IJShapeRoiArray.class);
        this.leftRightTranformed.set((Object)arrayIniLeftRight);
        RealPointList listLeftRight = (RealPointList)this.leftRightOrigin.to(RealPointList.class);
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.translate(new double[]{(double)(-this.mp.nPixX) / 2.0, (double)(-this.mp.nPixY) / 2.0, 0.0});
        at3D.scale(this.mp.sizePixX, this.mp.sizePixY, this.mp.sizePixZ);
        at3D.translate(new double[]{0.0, 0.0, this.slicingAxisPosition});
        listRegions = SliceSources.transformPoints(listRegions, (InvertibleRealTransform)at3D);
        listLeftRight = SliceSources.transformPoints(listLeftRight, (InvertibleRealTransform)at3D);
        Collections.reverse(this.registrations);
        for (Registration<SourceAndConverter<?>[]> reg : this.registrations) {
            if (reg instanceof MirrorXRegistration) continue;
            listRegions = reg.getTransformedPtsFixedToMoving(listRegions);
            listLeftRight = reg.getTransformedPtsFixedToMoving(listLeftRight);
        }
        Collections.reverse(this.registrations);
        InvertibleRealTransform transform = this.getTransformedSequenceToRoot(this.original_sacs[iChannel]);
        listRegions = SliceSources.transformPoints(listRegions, transform);
        listLeftRight = SliceSources.transformPoints(listLeftRight, transform);
        this.cvtRoisTransformed.clear();
        listRegions.shapeRoiList = new IJShapeRoiArray(arrayIniRegions);
        this.leftRightTranformed.clear();
        listLeftRight.shapeRoiList = new IJShapeRoiArray(arrayIniLeftRight);
        this.cvtRoisTransformed.set((Object)listRegions);
        this.leftRightTranformed.set((Object)listLeftRight);
    }

    private static RealPointList transformPoints(RealPointList pts, InvertibleRealTransform transform) {
        ArrayList<RealPoint> cvtList = new ArrayList<RealPoint>();
        for (RealPoint p : pts.ptList) {
            RealPoint pt3d = new RealPoint(3);
            pt3d.setPosition(new double[]{p.getDoublePosition(0), p.getDoublePosition(1), 0.0});
            transform.apply((RealLocalizable)pt3d, (RealPositionable)pt3d);
            RealPoint cpt = new RealPoint(new double[]{pt3d.getDoublePosition(0), pt3d.getDoublePosition(1)});
            cvtList.add(cpt);
        }
        return new RealPointList(cvtList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editLastRegistration(SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving) {
        Registration<SourceAndConverter<?>[]> reg = this.registrations.get(this.registrations.size() - 1);
        if (RegistrationPluginHelper.isEditable(reg)) {
            this.mp.infoMessageForUser.accept("Edit registration", "Edition will begin when the manual lock is acquired");
            Object object = MultiSlicePositioner.manualActionLock;
            synchronized (object) {
                this.removeRegistration(reg);
                reg.setFixedImage(preprocessFixed.apply((Object)this.mp.reslicedAtlas.nonExtendedSlicedSources));
                reg.setMovingImage(preprocessMoving.apply(this.registered_sacs));
                SourcesProcessor fixedProcessor = SourcesProcessorHelper.removeChannelsSelect((SourcesProcessor)preprocessFixed);
                fixedProcessor = new SourcesProcessComposer(fixedProcessor, (SourcesProcessor)new SourcesChannelsSelect(this.mp.reslicedAtlas.getLabelSourceIndex()));
                reg.setFixedMask(fixedProcessor.apply((Object)this.mp.reslicedAtlas.nonExtendedSlicedSources));
                reg.edit();
                this.appendRegistration(reg);
            }
        } else {
            this.mp.warningMessageForUser.accept("Registration edition error", "The last registration of class " + reg.getClass().getSimpleName() + " is not editable.");
        }
    }

    public String getInfo() {
        String sliceInfo = "";
        SourceAndConverter rootSac = SourceAndConverterInspector.getRootSourceAndConverter(this.original_sacs[0]);
        if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(rootSac, "SPIMDATA") == null) {
            sliceInfo = sliceInfo + "No information available";
        } else if (QuPathBdvHelper.isSourceLinkedToQuPath(this.original_sacs[0])) {
            int entryId = QuPathBdvHelper.getEntryId(this.original_sacs[0]);
            sliceInfo = sliceInfo + "QuPath Project: " + QuPathBdvHelper.getProjectFile(this.original_sacs[0]).getParent() + "\n";
            sliceInfo = sliceInfo + "Entry Id: " + entryId;
        }
        return sliceInfo;
    }

    public void keySliceOn() {
        this.setAsKeySlice = true;
        this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.sliceKeyOn(this));
    }

    public void keySliceOff() {
        this.setAsKeySlice = false;
        this.mp.listeners.forEach(sliceChangeListener -> sliceChangeListener.sliceKeyOff(this));
    }

    public boolean isKeySlice() {
        return this.setAsKeySlice;
    }

    public void setTempSlicingAxisPosition() {
        this.tempAxisPosition = this.slicingAxisPosition;
    }

    public double getTempSlicingAxisPosition() {
        return this.tempAxisPosition;
    }

    public SourceAndConverter[] getRegisteredSources(int stepBack) {
        if (stepBack == 0) {
            return this.getRegisteredSources();
        }
        return this.registered_sacs_sequence.get((int)Math.max((int)2, (int)(this.registered_sacs_sequence.size() - 1 - stepBack))).sacs;
    }

    public IAlphaSource getAlpha() {
        return this.alphaSource;
    }

    protected void pushRasterDeformation(double gridSpacingInMicrometer) {
        this.sourcesDeformationFieldNonRasterized.push(this.registered_sacs);
        RealTransformSequence rts = new RealTransformSequence();
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        this.addAllRegistrations(rts, irts, this.getTolerance(), this.getMaxIteration());
        Source<?> model = this.getModelWithGridSize(gridSpacingInMicrometer);
        SourceRealTransformer srt = irts != null ? new SourceRealTransformer(RealTransformHelper.resampleTransform((RealTransform)irts, model)) : new SourceRealTransformer(RealTransformHelper.resampleTransform((RealTransform)rts, model));
        this.registered_sacs = new SourceAndConverter[this.nChannels];
        for (int iChannel = 0; iChannel < this.nChannels; ++iChannel) {
            this.registered_sacs[iChannel] = srt.apply(this.original_sacs[iChannel]);
        }
        this.si.updateBox();
    }

    private Source<?> getModelWithGridSize(double gridSpacingInMicrometer) {
        final double transform_field_subsampling = gridSpacingInMicrometer / (this.mp.getAtlas().getMap().getAtlasPrecisionInMillimeter() * 1000.0);
        final FinalInterval interval = new FinalInterval(new long[]{(int)((double)this.mp.nPixX / transform_field_subsampling), (int)((double)this.mp.nPixY / transform_field_subsampling), 1L});
        String unit = this.original_sacs[0].getSpimSource().getVoxelDimensions().unit();
        double voxX = this.original_sacs[0].getSpimSource().getVoxelDimensions().dimension(0);
        double voxY = this.original_sacs[0].getSpimSource().getVoxelDimensions().dimension(1);
        double voxZ = this.original_sacs[0].getSpimSource().getVoxelDimensions().dimension(2);
        final FinalVoxelDimensions voxD = new FinalVoxelDimensions(unit, new double[]{voxX, voxY, voxZ});
        return new IAlphaSource(){

            public boolean doBoundingBoxCulling() {
                return false;
            }

            public boolean intersectBox(AffineTransform3D affineTransform, Interval cell, int timepoint) {
                AlphaSourceRAI.Box3D box_cell = new AlphaSourceRAI.Box3D(affineTransform, cell);
                AffineTransform3D affineTransform3D = new AffineTransform3D();
                this.getSourceTransform(timepoint, 0, affineTransform3D);
                AlphaSourceRAI.Box3D box_this = new AlphaSourceRAI.Box3D(affineTransform3D, this.getSource(timepoint, 0));
                return box_this.intersects(box_cell);
            }

            public boolean isPresent(int t) {
                return t == 0;
            }

            public RandomAccessibleInterval<FloatType> getSource(int t, int level) {
                FunctionRandomAccessible randomAccessible = new FunctionRandomAccessible(3, () -> (loc, out) -> out.setReal(1.0f), FloatType::new);
                return Views.interval((RandomAccessible)randomAccessible, (Interval)interval);
            }

            public RealRandomAccessible<FloatType> getInterpolatedSource(int t, int level, Interpolation interpolation) {
                ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
                RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)SliceSources.this.interpolators.get(Interpolation.NEARESTNEIGHBOR));
                return realRandomAccessible;
            }

            public void getSourceTransform(int t, int level, AffineTransform3D affineTransform3D) {
                affineTransform3D.identity();
                affineTransform3D.scale(((SliceSources)SliceSources.this).mp.sizePixX * transform_field_subsampling, ((SliceSources)SliceSources.this).mp.sizePixY * transform_field_subsampling, SliceSources.this.thicknessInMm);
                affineTransform3D.translate(new double[]{-((SliceSources)SliceSources.this).mp.sX / 2.0, -((SliceSources)SliceSources.this).mp.sY / 2.0, SliceSources.this.getSlicingAxisPosition() + SliceSources.this.getZShiftCorrection()});
            }

            public FloatType getType() {
                return new FloatType();
            }

            public String getName() {
                return "alpha-slice";
            }

            public VoxelDimensions getVoxelDimensions() {
                return voxD;
            }

            public int getNumMipmapLevels() {
                return 1;
            }
        };
    }

    protected void popRasterDeformation() {
        this.registered_sacs = this.sourcesDeformationFieldNonRasterized.pop();
    }

    public void pushRasterSlice(double voxelSpacingInMicrometer, boolean interpolate) {
        SourceAndConverter<?>[] oriSources = this.registered_sacs;
        this.sourcesNonRasterized.push(this.registered_sacs);
        RealTransformSequence rts = new RealTransformSequence();
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        this.addAllRegistrations(rts, irts, this.getTolerance(), this.getMaxIteration());
        Source<?> model = this.getModelWithGridSize(voxelSpacingInMicrometer);
        SourceAndConverter modelSac = SourceAndConverterHelper.createSourceAndConverter(model);
        this.registered_sacs = new SourceAndConverter[this.nChannels];
        for (int iChannel = 0; iChannel < this.nChannels; ++iChannel) {
            SourceResampler resampler = new SourceResampler(null, modelSac, oriSources[iChannel].getSpimSource().getName() + "_raster_" + voxelSpacingInMicrometer + "_um", true, true, interpolate, 0);
            this.registered_sacs[iChannel] = resampler.apply(oriSources[iChannel]);
        }
        this.si.updateBox();
    }

    public void setAlphaSources() {
        for (SourceAndConverter<?> sac : this.registered_sacs) {
            SourceAndConverterServices.getSourceAndConverterService().register(sac);
            if (this.alphaSource == null) continue;
            AlphaSourceHelper.setAlphaSource(sac, (IAlphaSource)this.alphaSource);
        }
    }

    public void popRasterSlice() {
        this.registered_sacs = this.sourcesNonRasterized.pop();
    }

    private static ConvertibleRois constructROIsFromImgLabel(AtlasOntology ontology, ImagePlus labelImg) {
        ImageProcessor ip = labelImg.getProcessor();
        float[][] pixels = ip.getFloatArray();
        boolean[][] movablePx = new boolean[ip.getWidth() + 1][ip.getHeight() + 1];
        for (int x = 1; x < ip.getWidth(); ++x) {
            for (int y = 1; y < ip.getHeight(); ++y) {
                float max;
                boolean is3Colored = false;
                boolean isCrossed = false;
                float p1p1 = pixels[x][y];
                float p1m1 = pixels[x][y - 1];
                float m1p1 = pixels[x - 1][y];
                float m1m1 = pixels[x - 1][y - 1];
                float min = p1p1;
                if (p1m1 < min) {
                    min = p1m1;
                }
                if (m1p1 < min) {
                    min = m1p1;
                }
                if (m1m1 < min) {
                    min = m1m1;
                }
                if (p1m1 > (max = p1p1)) {
                    max = p1m1;
                }
                if (m1p1 > max) {
                    max = m1p1;
                }
                if (m1m1 > max) {
                    max = m1m1;
                }
                if (min != max) {
                    if (p1p1 != min && p1p1 != max) {
                        is3Colored = true;
                    }
                    if (m1p1 != min && m1p1 != max) {
                        is3Colored = true;
                    }
                    if (p1m1 != min && p1m1 != max) {
                        is3Colored = true;
                    }
                    if (m1m1 != min && m1m1 != max) {
                        is3Colored = true;
                    }
                    if (!is3Colored && p1p1 == m1m1 && p1m1 == m1p1) {
                        isCrossed = true;
                    }
                }
                movablePx[x][y] = !is3Colored && !isCrossed;
            }
        }
        HashSet<Integer> existingLabelValues = new HashSet<Integer>();
        for (int x = 0; x < ip.getWidth(); ++x) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                existingLabelValues.add(Float.floatToRawIntBits(pixels[x][y]));
            }
        }
        FloatProcessor fp = new FloatProcessor(ip.getWidth(), ip.getHeight());
        fp.setFloatArray(pixels);
        ImagePlus imgFloatCopy = new ImagePlus("FloatLabel", (ImageProcessor)fp);
        HashSet existingIdValues = new HashSet();
        existingLabelValues.forEach(v -> {
            fp.setThreshold((double)Float.intBitsToFloat(v), (double)Float.intBitsToFloat(v), 2);
            Roi roi = SelectToROIKeepLines.run((ImagePlus)imgFloatCopy, (boolean[][])movablePx, (boolean)true);
            AtlasNode node = ontology.getNodeFromId(v.intValue());
            if (node != null) {
                int correctedId = node.getId();
                existingIdValues.add(correctedId);
                fp.setColor((double)Float.intBitsToFloat(correctedId));
                fp.fill(roi);
            }
        });
        HashSet possibleIdValues = new HashSet();
        existingIdValues.forEach(id -> {
            possibleIdValues.addAll(AtlasHelper.getAllParentIds((AtlasOntology)ontology, (int)id));
            possibleIdValues.add(id);
        });
        HashMap<Integer, Set> childrenContained = new HashMap<Integer, Set>();
        possibleIdValues.forEach(idValue -> {
            AtlasNode node = ontology.getNodeFromId(idValue.intValue());
            if (node != null) {
                Set valuesMetInTheImage = node.children().stream().map(n -> n).map(AtlasNode::getId).filter(possibleIdValues::contains).collect(Collectors.toSet());
                childrenContained.put((Integer)idValue, valuesMetInTheImage);
            }
        });
        HashSet isLeaf = new HashSet();
        childrenContained.forEach((k, v) -> {
            if (v.size() == 0) {
                isLeaf.add(k);
            }
        });
        boolean containsLeaf = true;
        ArrayList roiArray = new ArrayList();
        while (containsLeaf) {
            List<Integer> leavesValues = existingIdValues.stream().filter(isLeaf::contains).collect(Collectors.toList());
            leavesValues.forEach(v -> {
                AtlasNode parent;
                fp.setThreshold((double)Float.intBitsToFloat(v), (double)Float.intBitsToFloat(v), 2);
                Roi roi = SelectToROIKeepLines.run((ImagePlus)imgFloatCopy, (boolean[][])movablePx, (boolean)true);
                roi.setName(Integer.toString(v));
                roiArray.add(roi);
                if (ontology.getNodeFromId(v.intValue()) != null && (parent = ontology.getNodeFromId(v.intValue()).parent()) != null) {
                    int parentId = parent.getId();
                    fp.setColor((double)Float.intBitsToFloat(parentId));
                    fp.fill(roi);
                    if (childrenContained.get(parentId) != null) {
                        if (((Set)childrenContained.get(v)).size() == 0) {
                            ((Set)childrenContained.get(parentId)).remove(v);
                        }
                        existingIdValues.add(parentId);
                    }
                }
            });
            existingIdValues.removeAll(leavesValues);
            leavesValues.forEach(childrenContained::remove);
            isLeaf.clear();
            childrenContained.forEach((k, v) -> {
                if (v.size() == 0) {
                    isLeaf.add(k);
                }
            });
            containsLeaf = existingIdValues.stream().anyMatch(isLeaf::contains);
        }
        ConvertibleRois cr_out = new ConvertibleRois();
        IJShapeRoiArray output = new IJShapeRoiArray(roiArray);
        output.smoothenWithConstrains(movablePx);
        output.smoothenWithConstrains(movablePx);
        cr_out.set((Object)output);
        return cr_out;
    }

    public void setDisplayRange(int channelIndex, double min, double max) {
        Displaysettings ds = new Displaysettings(-1);
        Displaysettings.GetDisplaySettingsFromCurrentConverter(this.getRegisteredSources()[channelIndex], (Displaysettings)ds);
        ds.min = min;
        ds.max = max;
        this.registered_sacs_sequence.stream().forEach(registrationAndSources -> Displaysettings.applyDisplaysettings((SourceAndConverter)registrationAndSources.sacs[channelIndex], (Displaysettings)ds));
        Displaysettings.applyDisplaysettings(this.registered_sacs[channelIndex], (Displaysettings)ds);
        this.mp.converterChanged(this);
    }

    public void setDisplayColor(int channelIndex, int r, int g, int b, int a) {
        Displaysettings ds = new Displaysettings(-1);
        Displaysettings.GetDisplaySettingsFromCurrentConverter(this.getRegisteredSources()[channelIndex], (Displaysettings)ds);
        ds.color = new int[]{r, g, b, a};
        this.registered_sacs_sequence.stream().forEach(registrationAndSources -> Displaysettings.applyDisplaysettings((SourceAndConverter)registrationAndSources.sacs[channelIndex], (Displaysettings)ds));
        Displaysettings.applyDisplaysettings(this.registered_sacs[channelIndex], (Displaysettings)ds);
        this.mp.converterChanged(this);
    }

    public void setDisplaySettings(Displaysettings[] displaysettings) {
        for (int channelIndex = 0; channelIndex < this.nChannels; ++channelIndex) {
            for (RegistrationAndSources registrationAndSources : this.registered_sacs_sequence) {
                Displaysettings.applyDisplaysettings((SourceAndConverter)registrationAndSources.sacs[channelIndex], (Displaysettings)displaysettings[channelIndex]);
            }
            Displaysettings.applyDisplaysettings(this.registered_sacs[channelIndex], (Displaysettings)displaysettings[channelIndex]);
        }
    }

    class SliceInterval
    implements RealInterval {
        final RealPoint ptMin = new RealPoint(3);
        final RealPoint ptMax = new RealPoint(3);

        SliceInterval() {
        }

        void updateBox() {
            this.ptMin.setPosition(((SliceSources)SliceSources.this).mp.reslicedAtlas.realMin(0), 0);
            this.ptMin.setPosition(((SliceSources)SliceSources.this).mp.reslicedAtlas.realMin(1), 1);
            this.ptMin.setPosition(SliceSources.this.slicingAxisPosition - SliceSources.this.thicknessInMm / 2.0, 2);
            this.ptMax.setPosition(((SliceSources)SliceSources.this).mp.reslicedAtlas.realMax(0), 0);
            this.ptMax.setPosition(((SliceSources)SliceSources.this).mp.reslicedAtlas.realMax(1), 1);
            this.ptMax.setPosition(SliceSources.this.slicingAxisPosition + SliceSources.this.thicknessInMm / 2.0, 2);
        }

        public double realMin(int i) {
            return this.ptMin.getDoublePosition(i);
        }

        public double realMax(int i) {
            return this.ptMax.getDoublePosition(i);
        }

        public int numDimensions() {
            return 3;
        }
    }

    private static class RegistrationAndSources {
        final Registration reg;
        final SourceAndConverter[] sacs;

        public RegistrationAndSources(Registration reg, SourceAndConverter[] sacs) {
            this.reg = reg;
            this.sacs = sacs;
        }
    }

    static final class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

