/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.CreateSliceAction;
import ch.epfl.biop.atlas.aligner.DeleteSliceAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceActionObserver
implements MultiSlicePositioner.SliceChangeListener {
    protected static final Logger logger = LoggerFactory.getLogger(SliceActionObserver.class);
    MultiSlicePositioner mp;
    Map<SliceSources, List<CancelableAction>> sliceSortedActions = new ConcurrentHashMap<SliceSources, List<CancelableAction>>();
    Map<SliceSources, String> actionPerSlice = new ConcurrentHashMap<SliceSources, String>();
    Set<CancelableAction> hiddenActions = ConcurrentHashMap.newKeySet();

    public void clear() {
        this.mp = null;
        this.sliceSortedActions.clear();
        this.sliceSortedActions = null;
        this.actionPerSlice.clear();
        this.actionPerSlice = null;
        this.hiddenActions.clear();
        this.hiddenActions = null;
    }

    public SliceActionObserver(MultiSlicePositioner mp) {
        this.mp = mp;
    }

    public void hide(CancelableAction action) {
        this.hiddenActions.add(action);
    }

    public void unhide(CancelableAction action) {
        this.hiddenActions.remove(action);
    }

    public synchronized List<CancelableAction> getActionsFromSlice(SliceSources slice) {
        return this.sliceSortedActions.get(slice);
    }

    @Override
    public void sliceDeleted(SliceSources slice) {
    }

    @Override
    public void sliceCreated(SliceSources slice) {
    }

    @Override
    public void sliceZPositionChanged(SliceSources slice) {
    }

    @Override
    public void sliceSelected(SliceSources slice) {
    }

    @Override
    public void sliceDeselected(SliceSources slice) {
    }

    @Override
    public void sliceSourcesChanged(SliceSources slice) {
    }

    @Override
    public void slicePretransformChanged(SliceSources slice) {
    }

    @Override
    public void sliceKeyOn(SliceSources slice) {
    }

    @Override
    public void sliceKeyOff(SliceSources slice) {
    }

    @Override
    public void roiChanged() {
    }

    @Override
    public void actionEnqueue(SliceSources slice, CancelableAction action) {
        if (action.getSliceSources() != null) {
            if (!this.sliceSortedActions.containsKey(action.getSliceSources())) {
                this.sliceSortedActions.put(action.getSliceSources(), new ArrayList());
            }
            this.sliceSortedActions.get(action.getSliceSources()).add(action);
            logger.debug("Action registered in observer: " + action);
        } else assert (action instanceof CreateSliceAction);
    }

    @Override
    public void actionStarted(SliceSources slice, CancelableAction action) {
    }

    @Override
    public void actionFinished(SliceSources slice, CancelableAction action, boolean result) {
        assert (action.getSliceSources() != null);
        if (action instanceof CreateSliceAction) {
            if (!this.sliceSortedActions.containsKey(action.getSliceSources())) {
                this.sliceSortedActions.put(action.getSliceSources(), new ArrayList());
            }
            logger.debug("Size of sliceSortedAction (normally 0) " + this.sliceSortedActions.get(action.getSliceSources()).size());
            if (!this.sliceSortedActions.get(action.getSliceSources()).contains(action)) {
                this.sliceSortedActions.get(action.getSliceSources()).add(action);
            } else {
                logger.debug("Ah, create slice was already contained, it's a redo!");
            }
            logger.debug("Action registered in observer: " + action);
        }
        if (!action.isValid()) {
            this.sliceSortedActions.get(action.getSliceSources()).remove(action);
        }
        if (action instanceof DeleteSliceAction) {
            this.sliceSortedActions.get(action.getSliceSources()).remove(action);
        }
    }

    @Override
    public void actionCancelEnqueue(SliceSources slice, CancelableAction action) {
    }

    @Override
    public void actionCancelStarted(SliceSources slice, CancelableAction action) {
    }

    @Override
    public void actionCancelFinished(SliceSources slice, CancelableAction action, boolean result) {
        if (action.getSliceSources() != null && this.sliceSortedActions.get(action.getSliceSources()) != null) {
            this.sliceSortedActions.get(action.getSliceSources()).remove(action);
            logger.debug("Action removed in observer: " + action);
        } else {
            logger.debug("Action not removed: " + action);
        }
    }

    @Override
    public void converterChanged(SliceSources slice) {
    }
}

