/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import bdv.tools.transformation.TransformedSource;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.struct.Atlas;
import ch.epfl.biop.atlas.struct.AtlasMap;
import ch.epfl.biop.registration.sourceandconverter.affine.AffineTransformedSourceWrapperRegistration;
import ch.epfl.biop.sourceandconverter.EmptyMultiResolutionSourceAndConverterCreator;
import ch.epfl.biop.sourceandconverter.transform.SourceMosaicZSlicer;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

public class ReslicedAtlas
implements RealInterval {
    static final double BOX_MARGIN = 0.15;
    double zMarginOffset = 0.0;
    protected static final Logger logger = LoggerFactory.getLogger(ReslicedAtlas.class);
    public final Atlas ba;
    AffineTransform3D slicingTransfom = new AffineTransform3D();
    double slicingResolution = -1.0;
    SourceAndConverter slicingModel;
    public SourceAndConverter[] extendedSlicedSources;
    public SourceAndConverter[] nonExtendedSlicedSources;
    AffineTransform3D centerTransform;
    final AffineTransformedSourceWrapperRegistration nonExtendedAffineTransform = new AffineTransformedSourceWrapperRegistration();
    private volatile int zStep = 1;
    private double rotx;
    private double roty;
    private double cX;
    private double cY;
    private double cZ;
    final List<Runnable> listeners = new ArrayList<Runnable>();
    double minZAxis = Double.MAX_VALUE;
    double maxZAxis = -1.7976931348623157E308;
    double minXAxis = Double.MAX_VALUE;
    double maxXAxis = -1.7976931348623157E308;
    double minYAxis = Double.MAX_VALUE;
    double maxYAxis = -1.7976931348623157E308;
    boolean lock = false;
    AffineTransform3D atlasToSlicingTransform = new AffineTransform3D();
    private int labelIndex = -1;

    public ReslicedAtlas(Atlas ba) {
        this.ba = ba;
    }

    public void addListener(Runnable runnable) {
        this.listeners.add(runnable);
    }

    public void setSlicingTransform(AffineTransform3D slicingTransfom) {
        this.slicingTransfom = slicingTransfom;
        this.computeReslicedSources();
    }

    public AffineTransform3D getSlicingTransform() {
        return this.slicingTransfom.copy();
    }

    public void setResolution(double slicingResolution) {
        this.slicingResolution = slicingResolution;
        this.computeReslicedSources();
    }

    public double getZOffset() {
        return this.zMarginOffset;
    }

    void computeReslicedSources() {
        if (this.slicingTransfom == null || this.slicingResolution <= 0.0) {
            logger.error("No slicing transform or slicing resolution specified");
            return;
        }
        SourceAndConverter sacForBoundsTesting = (SourceAndConverter)this.ba.getMap().getStructuralImages().get(this.ba.getMap().getImagesKeys().get(0));
        AffineTransform3D sacTransform = new AffineTransform3D();
        sacForBoundsTesting.getSpimSource().getSourceTransform(0, 0, sacTransform);
        RandomAccessibleInterval rai = sacForBoundsTesting.getSpimSource().getSource(0, 0);
        this.minZAxis = Double.MAX_VALUE;
        this.maxZAxis = -1.7976931348623157E308;
        this.minXAxis = Double.MAX_VALUE;
        this.maxXAxis = -1.7976931348623157E308;
        this.minYAxis = Double.MAX_VALUE;
        this.maxYAxis = -1.7976931348623157E308;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    double projectedPointOnSlicingYAxis;
                    double projectedPointOnSlicingXAxis;
                    RealPoint pt = new RealPoint(3);
                    pt.setPosition(new long[]{(long)x * rai.dimension(0), (long)y * rai.dimension(1), (long)z * rai.dimension(2)});
                    RealPoint ptRealSpace = new RealPoint(3);
                    sacTransform.apply((RealLocalizable)pt, (RealPositionable)ptRealSpace);
                    double projectedPointOnSlicingAxis = ptRealSpace.getDoublePosition(0) * this.slicingTransfom.get(0, 2) + ptRealSpace.getDoublePosition(1) * this.slicingTransfom.get(1, 2) + ptRealSpace.getDoublePosition(2) * this.slicingTransfom.get(2, 2);
                    if (projectedPointOnSlicingAxis < this.minZAxis) {
                        this.minZAxis = projectedPointOnSlicingAxis;
                    }
                    if (projectedPointOnSlicingAxis > this.maxZAxis) {
                        this.maxZAxis = projectedPointOnSlicingAxis;
                    }
                    if ((projectedPointOnSlicingXAxis = ptRealSpace.getDoublePosition(0) * this.slicingTransfom.get(0, 0) + ptRealSpace.getDoublePosition(1) * this.slicingTransfom.get(1, 0) + ptRealSpace.getDoublePosition(2) * this.slicingTransfom.get(2, 0)) < this.minXAxis) {
                        this.minXAxis = projectedPointOnSlicingXAxis;
                    }
                    if (projectedPointOnSlicingXAxis > this.maxXAxis) {
                        this.maxXAxis = projectedPointOnSlicingXAxis;
                    }
                    if ((projectedPointOnSlicingYAxis = ptRealSpace.getDoublePosition(0) * this.slicingTransfom.get(0, 1) + ptRealSpace.getDoublePosition(1) * this.slicingTransfom.get(1, 1) + ptRealSpace.getDoublePosition(2) * this.slicingTransfom.get(2, 1)) < this.minYAxis) {
                        this.minYAxis = projectedPointOnSlicingYAxis;
                    }
                    if (!(projectedPointOnSlicingYAxis > this.maxYAxis)) continue;
                    this.maxYAxis = projectedPointOnSlicingYAxis;
                }
            }
        }
        this.cZ = (this.minZAxis + this.maxZAxis) / 2.0;
        double dZ = (this.maxZAxis - this.minZAxis) / 2.0;
        this.minZAxis = this.cZ - dZ * 1.15;
        this.maxZAxis = this.cZ + dZ * 1.15;
        this.zMarginOffset = dZ * 0.15;
        this.cX = (this.maxXAxis + this.minXAxis) / 2.0;
        this.cY = (this.maxYAxis + this.minYAxis) / 2.0;
        double dX = (this.maxXAxis - this.minXAxis) / 2.0;
        double dY = (this.maxYAxis - this.minYAxis) / 2.0;
        this.maxXAxis = this.cX + dX * 1.15;
        this.maxYAxis = this.cY + dY * 1.15;
        this.minXAxis = this.cX - dX * 1.15;
        this.minYAxis = this.cY - dY * 1.15;
        RealPoint realCenter = new RealPoint(new double[]{this.cX, this.cY, this.cZ});
        this.slicingTransfom.apply((RealLocalizable)realCenter, (RealPositionable)realCenter);
        this.cX = realCenter.getDoublePosition(0);
        this.cY = realCenter.getDoublePosition(1);
        this.cZ = realCenter.getDoublePosition(2);
        this.slicingTransfom.scale(this.slicingResolution);
        long nPixX = (long)((this.maxXAxis - this.minXAxis) / this.slicingResolution);
        long nPixY = (long)((this.maxYAxis - this.minYAxis) / this.slicingResolution);
        long nPixZ = (long)((this.maxZAxis - this.minZAxis) / this.slicingResolution);
        ReslicedAtlas.adjustShiftSlicingTransform(this.slicingTransfom, this.cX, this.cY, this.cZ, nPixX, nPixY, nPixZ);
        AffineTransform3D m = new AffineTransform3D();
        SourceAndConverter nonWrappedSlicingModel = new EmptyMultiResolutionSourceAndConverterCreator("SlicingModel", m, nPixX, nPixY, nPixZ, 1L, 2, 2, 1, 5).get();
        if (this.slicingModel != null) {
            SourceAndConverterServices.getSourceAndConverterService().remove(new SourceAndConverter[]{this.slicingModel});
        }
        this.slicingModel = new SourceAffineTransformer(nonWrappedSlicingModel, this.slicingTransfom).get();
        SourceAndConverterServices.getSourceAndConverterService().register(this.slicingModel);
        AtlasMap map = this.ba.getMap();
        this.extendedSlicedSources = new SourceAndConverter[map.getStructuralImages().size() + 1];
        SourceAndConverter[] tempNonExtendedSlicedSources = new SourceAndConverter[map.getStructuralImages().size() + 1];
        SourceMosaicZSlicer mosaic = new SourceMosaicZSlicer(null, this.slicingModel, true, false, false, this::getStep);
        SourceResampler resampler = new SourceResampler(null, this.slicingModel, this.slicingModel.getSpimSource().getName(), true, false, false, 0);
        this.centerTransform = null;
        List keys = map.getImagesKeys();
        for (int index = 0; index < map.getStructuralImages().size() + 1; ++index) {
            SourceAndConverter sac;
            if (index < map.getStructuralImages().size()) {
                logger.debug("index = " + index + "| source key: " + (String)keys.get(index));
                sac = (SourceAndConverter)map.getStructuralImages().get(keys.get(index));
                logger.debug(sac.getSpimSource().getName());
            } else {
                this.labelIndex = index;
                logger.debug("index = " + index + "| LABELS");
                sac = map.getLabelImage();
                logger.debug(sac.getSpimSource().getName());
            }
            SourceAndConverter reslicedSac = mosaic.apply(sac);
            tempNonExtendedSlicedSources[index] = resampler.apply(sac);
            if (this.centerTransform == null) {
                this.centerTransform = new AffineTransform3D();
                reslicedSac.getSpimSource().getSourceTransform(0, 0, this.centerTransform);
                RealPoint ptCenterGlobal = new RealPoint(3);
                long[] dims = new long[3];
                reslicedSac.getSpimSource().getSource(0, 0).dimensions(dims);
                dims[0] = dims[0] / dims[2];
                RealPoint ptCenterPixel = new RealPoint(new double[]{(double)dims[0] - 1.0, ((double)dims[1] - 1.0) / 2.0, 0.0});
                this.centerTransform.apply((RealLocalizable)ptCenterPixel, (RealPositionable)ptCenterGlobal);
                this.centerTransform.identity();
                this.centerTransform.translate(new double[]{-ptCenterGlobal.getDoublePosition(0), -ptCenterGlobal.getDoublePosition(1), 0.0});
            }
            this.extendedSlicedSources[index] = reslicedSac = new SourceAffineTransformer(null, this.centerTransform).apply(reslicedSac);
        }
        this.nonExtendedSlicedSources = this.nonExtendedAffineTransform.getTransformedImageMovingToFixed(tempNonExtendedSlicedSources);
    }

    static void adjustShiftSlicingTransform(AffineTransform3D slicingTransfom, double cx, double cy, double cz, long nX, long nY, long nZ) {
        AffineTransform3D notShifted = new AffineTransform3D();
        notShifted.set(slicingTransfom);
        notShifted.set(0.0, 0, 3);
        notShifted.set(0.0, 1, 3);
        notShifted.set(0.0, 2, 3);
        RealPoint pt = new RealPoint(new double[]{(double)nX / 2.0, (double)nY / 2.0, (double)nZ / 2.0});
        RealPoint ptRealSpace = new RealPoint(3);
        notShifted.apply((RealLocalizable)pt, (RealPositionable)ptRealSpace);
        slicingTransfom.set(cx - ptRealSpace.getDoublePosition(0), 0, 3);
        slicingTransfom.set(cy - ptRealSpace.getDoublePosition(1), 1, 3);
        slicingTransfom.set(cz - ptRealSpace.getDoublePosition(2), 2, 3);
    }

    public void lock() {
        this.lock = true;
    }

    public void unlock() {
        this.lock = false;
    }

    public void setStep(int zStep) {
        if (!this.lock && zStep > 0 && zStep != this.zStep) {
            this.zStep = zStep;
            this.slicingUpdate();
            this.listeners.forEach(Runnable::run);
        }
    }

    public void setRotateX(double rx) {
        if (!this.lock && rx != this.rotx) {
            this.rotx = rx;
            this.slicingUpdate();
            this.listeners.forEach(Runnable::run);
        }
    }

    public double getRotateX() {
        return this.rotx;
    }

    public double getRotateY() {
        return this.roty;
    }

    public void setRotateY(double ry) {
        if (!this.lock && ry != this.roty) {
            this.roty = ry;
            this.slicingUpdate();
            this.listeners.forEach(Runnable::run);
        }
    }

    public long getStep() {
        return this.zStep;
    }

    void slicingUpdate() {
        long nPixX = this.slicingModel.getSpimSource().getSource(0, 0).max(0);
        long nPixY = this.slicingModel.getSpimSource().getSource(0, 0).max(1);
        long nPixZ = this.slicingModel.getSpimSource().getSource(0, 0).max(2);
        AffineTransform3D slicingTransfom = this.slicingTransfom.copy();
        slicingTransfom.set(0.0, 0, 3);
        slicingTransfom.set(0.0, 1, 3);
        slicingTransfom.set(0.0, 2, 3);
        double m20 = slicingTransfom.get(0, 2);
        double m21 = slicingTransfom.get(1, 2);
        double m22 = slicingTransfom.get(2, 2);
        double m00 = slicingTransfom.get(0, 0);
        double m01 = slicingTransfom.get(1, 0);
        double m02 = slicingTransfom.get(2, 0);
        double m10 = slicingTransfom.get(0, 1);
        double m11 = slicingTransfom.get(1, 1);
        double m12 = slicingTransfom.get(2, 1);
        double[] qx = new double[4];
        double normRx = Math.sqrt(m00 * m00 + m01 * m01 + m02 * m02);
        qx[0] = Math.cos(this.rotx / 2.0);
        qx[1] = Math.sin(this.rotx / 2.0) * (m00 /= normRx);
        qx[2] = Math.sin(this.rotx / 2.0) * (m01 /= normRx);
        qx[3] = Math.sin(this.rotx / 2.0) * (m02 /= normRx);
        double[] qy = new double[4];
        double normRy = Math.sqrt(m10 * m10 + m11 * m11 + m12 * m12);
        qy[0] = Math.cos(this.roty / 2.0);
        qy[1] = Math.sin(this.roty / 2.0) * (m10 /= normRy);
        qy[2] = Math.sin(this.roty / 2.0) * (m11 /= normRy);
        qy[3] = Math.sin(this.roty / 2.0) * (m12 /= normRy);
        double[] qXY = new double[4];
        LinAlgHelpers.quaternionMultiply((double[])qy, (double[])qx, (double[])qXY);
        AffineTransform3D rotMatrix = new AffineTransform3D();
        double[][] m = new double[3][3];
        if (this.rotx != 0.0 || this.roty != 0.0) {
            LinAlgHelpers.quaternionToR((double[])qXY, (double[][])m);
            rotMatrix.set(m[0][0], m[0][1], m[0][2], 0.0, m[1][0], m[1][1], m[1][2], 0.0, m[2][0], m[2][1], m[2][2], 0.0);
            slicingTransfom.preConcatenate(rotMatrix);
        }
        slicingTransfom.set(m20, 0, 2);
        slicingTransfom.set(m21, 1, 2);
        slicingTransfom.set(m22, 2, 2);
        ReslicedAtlas.adjustShiftSlicingTransform(slicingTransfom, this.cX, this.cY, this.cZ, nPixX, nPixY, nPixZ);
        ((TransformedSource)this.slicingModel.getSpimSource()).setFixedTransform(slicingTransfom);
        AffineTransform3D at3d = new AffineTransform3D();
        AffineTransform3D atToInvert = new AffineTransform3D();
        this.slicingModel.getSpimSource().getSourceTransform(0, 0, atToInvert);
        this.slicingModel.getSpimSource().getSourceTransform(0, 0, at3d);
        at3d.set(0.0, 0, 3);
        at3d.set(0.0, 1, 3);
        at3d.set(0.0, 2, 3);
        double xScale = ReslicedAtlas.getNormTransform(0, at3d);
        double yScale = ReslicedAtlas.getNormTransform(1, at3d);
        double zScale = ReslicedAtlas.getNormTransform(2, at3d);
        at3d.identity();
        at3d.scale(xScale, yScale, zScale);
        AffineTransform3D centerTr = this.centerTransform.copy();
        centerTr.translate(new double[]{-this.centerTransform.get(0, 3) / 2.0, 0.0, 0.0});
        at3d.preConcatenate(centerTr);
        this.atlasToSlicingTransform = atToInvert.inverse().preConcatenate(at3d);
        this.nonExtendedAffineTransform.setAffineTransform(this.atlasToSlicingTransform);
    }

    public static double getNormTransform(int axis, AffineTransform3D t) {
        double f0 = t.get(0, axis);
        double f1 = t.get(1, axis);
        double f2 = t.get(2, axis);
        return Math.sqrt(f0 * f0 + f1 * f1 + f2 * f2);
    }

    public double realMin(int i) {
        switch (i) {
            case 0: {
                return this.minXAxis - (this.maxXAxis + this.minXAxis) / 2.0;
            }
            case 1: {
                return this.minYAxis - (this.maxYAxis + this.minYAxis) / 2.0;
            }
            case 2: {
                return this.minZAxis - (this.maxZAxis + this.minZAxis) / 2.0;
            }
        }
        return -1.7976931348623157E308;
    }

    public double realMax(int i) {
        switch (i) {
            case 0: {
                return this.maxXAxis - (this.maxXAxis + this.minXAxis) / 2.0;
            }
            case 1: {
                return this.maxYAxis - (this.maxYAxis + this.minYAxis) / 2.0;
            }
            case 2: {
                return this.maxZAxis - (this.maxZAxis + this.minZAxis) / 2.0;
            }
        }
        return Double.MAX_VALUE;
    }

    public int numDimensions() {
        return 3;
    }

    public AffineTransform3D getSlicingTransformToAtlas() {
        return this.atlasToSlicingTransform.inverse().copy();
    }

    public int getLabelSourceIndex() {
        return this.labelIndex;
    }

    public int getCoordinateSourceIndex(int coordinates) {
        return this.getLabelSourceIndex() - (2 - coordinates) - 2;
    }

    public int getLeftRightSourceIndex() {
        return this.getLabelSourceIndex() - 1;
    }

    public void removeListener(Runnable atlasSlicingListener) {
        this.listeners.remove(atlasSlicingListener);
    }

    public static AffineTransform3D getTransformFromCoronal(String xAxis, String yAxis, String zAxis) throws IllegalArgumentException {
        boolean apUsed = false;
        boolean rlUsed = false;
        boolean isUsed = false;
        xAxis = xAxis.trim().toUpperCase();
        yAxis = yAxis.trim().toUpperCase();
        zAxis = zAxis.trim().toUpperCase();
        switch (xAxis) {
            case "AP": 
            case "PA": {
                apUsed = true;
                break;
            }
            case "RL": 
            case "LR": {
                rlUsed = true;
                break;
            }
            case "IS": 
            case "SI": {
                isUsed = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("xAxis is not recognized, it should be chosen within AP, PA, RL, LR, SI or IS");
            }
        }
        switch (yAxis) {
            case "AP": 
            case "PA": {
                apUsed = true;
                break;
            }
            case "RL": 
            case "LR": {
                rlUsed = true;
                break;
            }
            case "IS": 
            case "SI": {
                isUsed = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("xAxis is not recognized, it should be chosen within AP, PA, RL, LR, SI or IS");
            }
        }
        switch (zAxis) {
            case "AP": 
            case "PA": {
                apUsed = true;
                break;
            }
            case "RL": 
            case "LR": {
                rlUsed = true;
                break;
            }
            case "IS": 
            case "SI": {
                isUsed = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("xAxis is not recognized, it should be chosen within AP, PA, RL, LR, SI or IS");
            }
        }
        if (!(apUsed && rlUsed && isUsed)) {
            throw new IllegalArgumentException("Singular matrix, please use all axes");
        }
        double m00 = 0.0;
        double m01 = 0.0;
        double m02 = 0.0;
        double m10 = 0.0;
        double m11 = 0.0;
        double m12 = 0.0;
        double m20 = 0.0;
        double m21 = 0.0;
        double m22 = 0.0;
        switch (xAxis) {
            case "AP": {
                m20 = 1.0;
                break;
            }
            case "PA": {
                m20 = -1.0;
                break;
            }
            case "RL": {
                m00 = 1.0;
                break;
            }
            case "LR": {
                m00 = -1.0;
                break;
            }
            case "SI": {
                m10 = 1.0;
                break;
            }
            case "IS": {
                m10 = -1.0;
            }
        }
        switch (yAxis) {
            case "AP": {
                m21 = 1.0;
                break;
            }
            case "PA": {
                m21 = -1.0;
                break;
            }
            case "RL": {
                m01 = 1.0;
                break;
            }
            case "LR": {
                m01 = -1.0;
                break;
            }
            case "SI": {
                m11 = 1.0;
                break;
            }
            case "IS": {
                m11 = -1.0;
            }
        }
        switch (zAxis) {
            case "AP": {
                m22 = 1.0;
                break;
            }
            case "PA": {
                m22 = -1.0;
                break;
            }
            case "RL": {
                m02 = 1.0;
                break;
            }
            case "LR": {
                m02 = -1.0;
                break;
            }
            case "SI": {
                m12 = 1.0;
                break;
            }
            case "IS": {
                m12 = -1.0;
            }
        }
        AffineTransform3D transform3D = new AffineTransform3D();
        transform3D.set(m00, m01, m02, 0.0, m10, m11, m12, 0.0, m20, m21, m22, 0.0);
        return transform3D;
    }
}

