/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.registration.Registration;
import ch.epfl.biop.registration.plugin.RegistrationPluginHelper;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterSliceAction
extends CancelableAction {
    protected static final Logger logger = LoggerFactory.getLogger(RegisterSliceAction.class);
    final SliceSources slice;
    Registration<SourceAndConverter<?>[]> registration = null;
    Supplier<Registration<SourceAndConverter<?>[]>> registrationSupplier = null;
    final SourcesProcessor preprocessFixed;
    final SourcesProcessor preprocessMoving;
    boolean isValid = true;

    @Override
    public SliceSources getSliceSources() {
        return this.slice;
    }

    public Registration<SourceAndConverter<?>[]> getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration<SourceAndConverter<?>[]> registration) {
        this.registration = registration;
    }

    public RegisterSliceAction(MultiSlicePositioner mp, SliceSources slice, Registration<SourceAndConverter<?>[]> registration, SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving) {
        super(mp);
        this.slice = slice;
        this.registration = registration;
        this.preprocessFixed = preprocessFixed;
        this.preprocessMoving = preprocessMoving;
    }

    public RegisterSliceAction(MultiSlicePositioner mp, SliceSources slice, Supplier<Registration<SourceAndConverter<?>[]>> registrationSupplier, SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving) {
        super(mp);
        this.slice = slice;
        this.registrationSupplier = registrationSupplier;
        this.preprocessFixed = preprocessFixed;
        this.preprocessMoving = preprocessMoving;
    }

    public SourcesProcessor getFixedSourcesProcessor() {
        return this.preprocessFixed;
    }

    public SourcesProcessor getMovingSourcesProcessor() {
        return this.preprocessMoving;
    }

    @Override
    protected boolean run() {
        if (this.registration == null) {
            this.registration = this.registrationSupplier.get();
        }
        if (this.registration.isRegistrationDone() && this.isValid()) {
            this.slice.appendRegistration(this.registration);
        } else {
            this.isValid = this.slice.runRegistration(this.registration, this.preprocessFixed, this.preprocessMoving);
        }
        this.slice.sourcesChanged();
        this.getMP().stateHasBeenChanged();
        return this.isValid;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        if (this.registration == null) {
            return "Future<Registration>";
        }
        return this.registration.toString() + " " + this.preprocessFixed.toString() + ".Atlas // " + this.preprocessMoving.toString() + ".Section)] " + this.slice.getActionState(this);
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        double size = 7.0 * scale;
        if (this.isValid) {
            if (scale < 0.9) {
                g.setColor(new Color(128, 128, 128, 200));
            } else {
                switch (this.slice.getActionState(this)) {
                    case "(done)": {
                        g.setColor(new Color(0, 255, 0, 200));
                        break;
                    }
                    case "(locked)": {
                        g.setColor(new Color(205, 1, 106, 200));
                        break;
                    }
                    case "(pending)": {
                        g.setColor(new Color(255, 255, 0, 200));
                    }
                }
            }
            if (this.registration != null && RegistrationPluginHelper.isManual(this.registration)) {
                g.fillRect((int)(px - size), (int)(py - size), (int)(2.0 * size), (int)(2.0 * size));
            } else {
                g.fillOval((int)(px - size), (int)(py - size), (int)(2.0 * size), (int)(2.0 * size));
            }
            g.setColor(new Color(255, 255, 255, 200));
            g.drawString("R", (int)px - 4, (int)py + 5);
        } else {
            g.setColor(new Color(205, 1, 106, 199));
            g.drawString("X", (int)px - 4, (int)py + 5);
        }
    }

    @Override
    protected boolean cancel() {
        if (this.registration != null) {
            logger.debug("Registration action " + this + " cancelled");
            this.registration.abort();
        }
        boolean result = this.slice.removeRegistration(this.registration);
        this.getMP().stateHasBeenChanged();
        return result;
    }
}

