/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Color;
import java.awt.Graphics2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterDeformationAction
extends CancelableAction {
    protected static Logger logger = LoggerFactory.getLogger(RasterDeformationAction.class);
    final SliceSources slice;
    final double gridSpacingInMicrometer;

    @Override
    public SliceSources getSliceSources() {
        return this.slice;
    }

    public RasterDeformationAction(MultiSlicePositioner mp, SliceSources slice, double gridSpacingInMicrometer) {
        super(mp);
        this.slice = slice;
        this.gridSpacingInMicrometer = gridSpacingInMicrometer;
    }

    @Override
    protected boolean run() {
        this.slice.pushRasterDeformation(this.gridSpacingInMicrometer);
        this.slice.sourcesChanged();
        this.getMP().stateHasBeenChanged();
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "Raster transformation (" + this.gridSpacingInMicrometer + " um)" + this.slice.getActionState(this);
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        double size = 7.0 * scale;
        if (scale < 0.9) {
            g.setColor(new Color(128, 128, 128, 200));
        } else {
            switch (this.slice.getActionState(this)) {
                case "(done)": {
                    g.setColor(new Color(217, 0, 255, 200));
                    break;
                }
                case "(locked)": {
                    g.setColor(new Color(205, 1, 106, 200));
                    break;
                }
                case "(pending)": {
                    g.setColor(new Color(255, 255, 0, 200));
                }
            }
        }
        g.fillOval((int)(px - size), (int)(py - size), (int)(2.0 * size), (int)(2.0 * size));
        g.setColor(new Color(255, 255, 255, 200));
        g.drawString("R", (int)px - 4, (int)py + 5);
    }

    @Override
    protected boolean cancel() {
        this.slice.popRasterDeformation();
        this.slice.sourcesChanged();
        this.getMP().stateHasBeenChanged();
        return true;
    }

    public double getGridSpacingInMicrometer() {
        return this.gridSpacingInMicrometer;
    }
}

