/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.CreateSliceAction;
import ch.epfl.biop.atlas.aligner.EditLastRegistrationAction;
import ch.epfl.biop.atlas.aligner.MoveSliceAction;
import ch.epfl.biop.atlas.aligner.RasterDeformationAction;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.ReslicedAtlas;
import ch.epfl.biop.atlas.aligner.SliceActionObserver;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.SourcesZOffset;
import ch.epfl.biop.atlas.aligner.UnMirrorSliceAction;
import ch.epfl.biop.atlas.aligner.action.KeySliceOffAction;
import ch.epfl.biop.atlas.aligner.action.KeySliceOnAction;
import ch.epfl.biop.atlas.aligner.action.MarkActionSequenceBatchAction;
import ch.epfl.biop.atlas.aligner.adapter.AlignerState;
import ch.epfl.biop.atlas.aligner.adapter.CreateSliceAdapter;
import ch.epfl.biop.atlas.aligner.adapter.IndexedSourceAndConverterAdapter;
import ch.epfl.biop.atlas.aligner.adapter.IndexedSourceAndConverterArrayAdapter;
import ch.epfl.biop.atlas.aligner.adapter.KeySliceOffAdapter;
import ch.epfl.biop.atlas.aligner.adapter.KeySliceOnAdapter;
import ch.epfl.biop.atlas.aligner.adapter.MoveSliceAdapter;
import ch.epfl.biop.atlas.aligner.adapter.RasterDeformationActionAdapter;
import ch.epfl.biop.atlas.aligner.adapter.RegisterSliceAdapter;
import ch.epfl.biop.atlas.aligner.adapter.RegistrationAdapter;
import ch.epfl.biop.atlas.aligner.adapter.SliceSourcesStateDeserializer;
import ch.epfl.biop.atlas.aligner.adapter.SourcesZOffsetAdapter;
import ch.epfl.biop.atlas.aligner.adapter.UnMirrorAdapter;
import ch.epfl.biop.atlas.struct.Atlas;
import ch.epfl.biop.registration.Registration;
import ch.epfl.biop.registration.plugin.ExternalRegistrationPlugin;
import ch.epfl.biop.registration.plugin.IRegistrationPlugin;
import ch.epfl.biop.sourceandconverter.processor.SourcesAffineTransformer;
import ch.epfl.biop.sourceandconverter.processor.SourcesChannelsSelect;
import ch.epfl.biop.sourceandconverter.processor.SourcesIdentity;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessComposer;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import ch.epfl.biop.sourceandconverter.processor.adapter.SourcesAffineTransformerAdapter;
import ch.epfl.biop.sourceandconverter.processor.adapter.SourcesChannelSelectAdapter;
import ch.epfl.biop.sourceandconverter.processor.adapter.SourcesComposerAdapter;
import ch.epfl.biop.sourceandconverter.processor.adapter.SourcesIdentityAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import net.imglib2.realtransform.AffineTransform3D;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.convert.ConvertService;
import org.scijava.object.ObjectService;
import org.scijava.plugin.PluginService;
import org.scijava.util.VersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServiceLoader;
import sc.fiji.bdvpg.services.SourceAndConverterServiceSaver;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.persist.RuntimeTypeAdapterFactory;
import sc.fiji.persist.ScijavaGsonHelper;

public class MultiSlicePositioner
implements Closeable {
    protected static final Logger logger = LoggerFactory.getLogger(MultiSlicePositioner.class);
    public static final Object manualActionLock = new Object();
    public final int nPixX;
    public final int nPixY;
    public final int nPixZ;
    public final double sX;
    public final double sY;
    public final double sZ;
    public final double sizePixX;
    public final double sizePixY;
    public final double sizePixZ;
    private List<SliceSources> slices = new ArrayList<SliceSources>();
    protected List<CancelableAction> userActions = new ArrayList<CancelableAction>();
    protected List<CancelableAction> redoableUserActions = new ArrayList<CancelableAction>();
    Context scijavaCtx;
    protected SliceActionObserver mso;
    ReslicedAtlas reslicedAtlas;
    private Atlas biopAtlas;
    double roiPX;
    double roiPY;
    double roiSX;
    double roiSY;
    private final List<BiConsumer<String, String>> errorSubscribers = new ArrayList<BiConsumer<String, String>>();
    private final List<BiConsumer<String, String>> warnSubscribers = new ArrayList<BiConsumer<String, String>>();
    private final List<BiConsumer<String, String>> infoSubscribers = new ArrayList<BiConsumer<String, String>>();
    public BiConsumer<String, String> errorMessageForUser = (title, message) -> {
        MultiSlicePositioner multiSlicePositioner = this;
        synchronized (multiSlicePositioner) {
            this.errorSubscribers.forEach(logger -> logger.accept(title, message));
        }
        logger.error(title + ":" + message);
    };
    public BiConsumer<String, String> warningMessageForUser = (title, message) -> {
        MultiSlicePositioner multiSlicePositioner = this;
        synchronized (multiSlicePositioner) {
            this.warnSubscribers.forEach(logger -> logger.accept(title, message));
        }
        logger.warn(title + ":" + message);
    };
    public BiConsumer<String, String> infoMessageForUser = (title, message) -> {
        MultiSlicePositioner multiSlicePositioner = this;
        synchronized (multiSlicePositioner) {
            this.infoSubscribers.forEach(logger -> logger.accept(title, message));
        }
        logger.info(title + ":" + message);
    };
    final Object slicesLock = new Object();
    private boolean stateChangedSinceLastSave = false;
    private static final int BUFFER_SIZE = 4096;
    private volatile SliceSources currentSerializedSlice = null;
    final List<SliceChangeListener> listeners = new ArrayList<SliceChangeListener>();
    protected final AtomicInteger numberOfTasks = new AtomicInteger();
    final List<MultiSlicePositionerListener> mpListeners = new ArrayList<MultiSlicePositionerListener>();
    static final Map<String, Supplier<? extends IRegistrationPlugin>> externalRegistrationPlugins = new HashMap<String, Supplier<? extends IRegistrationPlugin>>();
    static final Map<String, List<String>> externalRegistrationPluginsUI = new HashMap<String, List<String>>();

    public synchronized void subscribeToErrorMessages(BiConsumer<String, String> errorLogger) {
        this.errorSubscribers.add(errorLogger);
    }

    public synchronized void unSubscribeFromErrorMessages(BiConsumer<String, String> errorLogger) {
        this.errorSubscribers.remove(errorLogger);
    }

    public synchronized void subscribeToWarningMessages(BiConsumer<String, String> warnLogger) {
        this.warnSubscribers.add(warnLogger);
    }

    public synchronized void unSubscribeFromWarningMessages(BiConsumer<String, String> warnLogger) {
        this.warnSubscribers.remove(warnLogger);
    }

    public synchronized void subscribeToInfoMessages(BiConsumer<String, String> infoLogger) {
        this.infoSubscribers.add(infoLogger);
    }

    public synchronized void unSubscribeFromInfoMessages(BiConsumer<String, String> infoLogger) {
        this.infoSubscribers.remove(infoLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SliceSources> getSlices() {
        ArrayList<SliceSources> out;
        Object object = this.slicesLock;
        synchronized (object) {
            out = new ArrayList<SliceSources>(this.slices);
        }
        return out;
    }

    public MultiSlicePositioner(Atlas biopAtlas, ReslicedAtlas reslicedAtlas, Context ctx) {
        logger.info("Creating MultiSlicePositioner instance");
        this.reslicedAtlas = reslicedAtlas;
        this.biopAtlas = biopAtlas;
        this.scijavaCtx = ctx;
        reslicedAtlas.setStep(50);
        reslicedAtlas.setRotateX(0.0);
        reslicedAtlas.setRotateY(0.0);
        this.nPixX = (int)reslicedAtlas.slicingModel.getSpimSource().getSource(0, 0).dimension(0);
        this.nPixY = (int)reslicedAtlas.slicingModel.getSpimSource().getSource(0, 0).dimension(1);
        this.nPixZ = (int)reslicedAtlas.slicingModel.getSpimSource().getSource(0, 0).dimension(2);
        AffineTransform3D at3D = new AffineTransform3D();
        reslicedAtlas.slicingModel.getSpimSource().getSourceTransform(0, 0, at3D);
        double[] m = at3D.getRowPackedCopy();
        this.sizePixX = Math.sqrt(m[0] * m[0] + m[4] * m[4] + m[8] * m[8]);
        this.sizePixY = Math.sqrt(m[1] * m[1] + m[5] * m[5] + m[9] * m[9]);
        this.sizePixZ = Math.sqrt(m[2] * m[2] + m[6] * m[6] + m[10] * m[10]);
        this.sX = (double)this.nPixX * this.sizePixX;
        this.sY = (double)this.nPixY * this.sizePixY;
        this.sZ = (double)this.nPixZ * this.sizePixZ;
        this.mso = new SliceActionObserver(this);
        this.addSliceListener(this.mso);
        this.roiPX = -this.sX / 2.0;
        this.roiPY = -this.sY / 2.0;
        this.roiSX = this.sX;
        this.roiSY = this.sY;
        logger.info("MultiSlicePositioner instance created");
    }

    public ReslicedAtlas getReslicedAtlas() {
        return this.reslicedAtlas;
    }

    public List<SliceSources> getSelectedSlices() {
        return this.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.mpListeners.forEach(l -> l.closing(this));
        this.mpListeners.clear();
        ((ObjectService)this.scijavaCtx.getService(ObjectService.class)).removeObject((Object)this);
        logger.info("Closing multipositioner, releasing some resources.");
        if (this.mso != null) {
            this.mso.clear();
        }
        if (this.userActions != null) {
            this.userActions.clear();
        }
        if (this.slices != null) {
            this.slices.clear();
        }
        this.redoableUserActions.clear();
        this.biopAtlas = null;
        this.slices = null;
        this.userActions = null;
        this.mso = null;
        this.reslicedAtlas = null;
        this.currentSerializedSlice = null;
    }

    public void setROI(double px, double py, double sx, double sy) {
        double delta;
        if (px < -this.sX / 2.0) {
            delta = -(px + this.sX / 2.0);
            px = -this.sX / 2.0;
            sx -= delta;
        }
        if (px > this.sX / 2.0) {
            px = this.sX / 2.0;
        }
        if (px + sx > this.sX / 2.0) {
            sx = this.sX / 2.0 - px;
        }
        if (py < -this.sY / 2.0) {
            delta = -(py + this.sY / 2.0);
            py = -this.sY / 2.0;
            sy -= delta;
        }
        if (py > this.sY / 2.0) {
            py = this.sY / 2.0;
        }
        if (py + sy > this.sY / 2.0) {
            sy = this.sY / 2.0 - py;
        }
        this.roiPX = px;
        this.roiPY = py;
        this.roiSX = sx;
        this.roiSY = sy;
        this.listeners.forEach(SliceChangeListener::roiChanged);
    }

    public double[] getROI() {
        return new double[]{this.roiPX, this.roiPY, this.roiSX, this.roiSY};
    }

    public void selectSlice(SliceSources ... slices) {
        for (SliceSources slice : slices) {
            slice.select();
        }
    }

    public void selectSlice(List<SliceSources> slices) {
        this.selectSlice(slices.toArray(new SliceSources[0]));
    }

    public void deselectSlice(SliceSources ... slices) {
        for (SliceSources slice : slices) {
            slice.deSelect();
        }
    }

    public void deselectSlice(List<SliceSources> slices) {
        this.deselectSlice(slices.toArray(new SliceSources[0]));
    }

    public void waitForTasks() {
        this.slices.forEach(SliceSources::waitForEndOfTasks);
    }

    public String getUndoMessage() {
        if (this.userActions.isEmpty()) {
            return "(None)";
        }
        CancelableAction lastAction = this.userActions.get(this.userActions.size() - 1);
        if (lastAction instanceof MarkActionSequenceBatchAction) {
            CancelableAction lastlastAction = this.userActions.get(this.userActions.size() - 2);
            return "(" + lastlastAction.actionClassString() + " [batch])";
        }
        return "(" + lastAction.actionClassString() + ")";
    }

    public String getRedoMessage() {
        if (this.redoableUserActions.size() == 0) {
            return "(None)";
        }
        CancelableAction lastAction = this.redoableUserActions.get(this.redoableUserActions.size() - 1);
        if (lastAction instanceof MarkActionSequenceBatchAction) {
            CancelableAction lastlastAction = this.redoableUserActions.get(this.redoableUserActions.size() - 2);
            return "(" + lastlastAction.actionClassString() + " [batch])";
        }
        return "(" + lastAction.actionClassString() + ")";
    }

    public void rotateSlices(int axis, double angle_rad) {
        List sortedSelected = this.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        for (SliceSources slice : sortedSelected) {
            slice.rotateSourceOrigin(axis, angle_rad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSlice(SliceSources sliceSource) {
        logger.info("Removing slice " + sliceSource + "...");
        Object object = this.slicesLock;
        synchronized (object) {
            this.slices.remove(sliceSource);
            this.sortSlices();
            this.listeners.forEach(listener -> {
                logger.debug("Removing slice " + sliceSource + " - calling " + listener);
                listener.sliceDeleted(sliceSource);
            });
            logger.info("Slice " + sliceSource + " removed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSlice(SliceSources slice) {
        logger.info("Creating slice " + slice + "...");
        Object object = this.slicesLock;
        synchronized (object) {
            this.slices.add(slice);
            this.sortSlices();
            this.listeners.forEach(listener -> {
                logger.debug("Creating slice " + slice + " - calling " + listener);
                listener.sliceCreated(slice);
            });
            logger.info("Slice " + slice + " created!");
            this.sortSlices();
        }
    }

    private void sortSlices() {
        this.slices.forEach(SliceSources::setTempSlicingAxisPosition);
        this.slices.sort(Comparator.comparingDouble(SliceSources::getTempSlicingAxisPosition));
        for (int i = 0; i < this.slices.size(); ++i) {
            this.slices.get(i).setIndex(i);
        }
        logger.debug("Slices sorted recomputed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionZChanged(SliceSources slice) {
        Object object = this.slicesLock;
        synchronized (object) {
            this.sortSlices();
            for (SliceChangeListener listener : this.listeners) {
                listener.sliceZPositionChanged(slice);
            }
        }
        this.stateHasBeenChanged();
    }

    public void sliceSelected(SliceSources slice) {
        this.listeners.forEach(listener -> listener.sliceSelected(slice));
    }

    public void sliceDeselected(SliceSources slice) {
        this.listeners.forEach(listener -> listener.sliceDeselected(slice));
    }

    public Atlas getAtlas() {
        return this.biopAtlas;
    }

    public int getNumberOfAtlasChannels() {
        return this.reslicedAtlas.nonExtendedSlicedSources.length;
    }

    public int getChannelBoundForSelectedSlices() {
        List<SliceSources> slices = this.getSelectedSlices();
        if (slices.size() == 0) {
            return 0;
        }
        return slices.stream().mapToInt(slice -> slice.nChannels).min().getAsInt();
    }

    public AffineTransform3D getAffineTransformFromAlignerToAtlas() {
        return this.reslicedAtlas.getSlicingTransformToAtlas();
    }

    public List<CancelableAction> getActionsFromSlice(SliceSources slice) {
        return this.mso.getActionsFromSlice(slice);
    }

    public Context getContext() {
        return this.scijavaCtx;
    }

    public int userActionsSize() {
        return this.userActions.size();
    }

    public int redoableUserActionsSize() {
        return this.redoableUserActions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRequest(CancelableAction action, boolean launchInExtraThread) {
        if (action.getSliceSources() != null) {
            logger.debug("Action " + action + " on slice " + action.getSliceSources() + " requested (async).");
            this.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionEnqueue(action.getSliceSources(), action));
            action.getSliceSources().enqueueRunAction(action, () -> {}, launchInExtraThread);
        } else {
            logger.debug("Action " + action + " on slice " + action.getSliceSources() + " run (non async).");
            this.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionEnqueue(action.getSliceSources(), action));
            this.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionStarted(action.getSliceSources(), action));
            try {
                this.addTask();
                boolean result = action.run();
                this.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionFinished(action.getSliceSources(), action, result));
                logger.debug("Action " + action + " on slice " + action.getSliceSources() + " done.");
            }
            finally {
                this.removeTask();
            }
        }
        if (action.isValid()) {
            logger.debug("Action " + action + " on slice " + action.getSliceSources() + " is valid.");
            this.userActions.add(action);
            logger.debug("Action " + action + " on slice " + action.getSliceSources() + " added to userActions.");
            if (this.redoableUserActions.size() > 0) {
                if (this.redoableUserActions.get(this.redoableUserActions.size() - 1).equals(action)) {
                    this.redoableUserActions.remove(this.redoableUserActions.size() - 1);
                } else {
                    logger.debug("DELETED REDOABLE ACTIONS");
                    this.redoableUserActions.clear();
                }
            }
        } else {
            logger.error("Invalid action " + action + " on slice " + action.getSliceSources());
        }
    }

    protected void cancelRequest(CancelableAction action) {
        this.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelEnqueue(action.getSliceSources(), action));
        if (action.isValid()) {
            if (action.getSliceSources() == null) {
                logger.debug("Non Async cancel call : " + action + " on slice " + action.getSliceSources());
                this.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelStarted(action.getSliceSources(), action));
                boolean result = action.cancel();
                this.listeners.forEach(sliceChangeListener -> sliceChangeListener.actionCancelFinished(action.getSliceSources(), action, result));
            } else {
                logger.debug("Async cancel call : " + action + " on slice " + action.getSliceSources());
                action.getSliceSources().enqueueCancelAction(action, () -> {});
            }
            if (this.userActions.get(this.userActions.size() - 1).equals(action)) {
                logger.debug(action + " cancelled on slice " + action.getSliceSources() + ", updating useractions and redoable actions");
                this.userActions.remove(this.userActions.size() - 1);
                this.redoableUserActions.add(action);
            } else {
                logger.error("Error : cancel not called on the last action");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runCreateSlice(CreateSliceAction createSliceAction) {
        MultiSlicePositioner multiSlicePositioner = this;
        synchronized (multiSlicePositioner) {
            boolean sacAlreadyPresent = false;
            for (SourceAndConverter<?> sac : createSliceAction.getSacs()) {
                block4: for (SliceSources slice : this.getSlices()) {
                    for (SourceAndConverter<?> test : slice.getOriginalSources()) {
                        if (!test.equals(sac)) continue;
                        sacAlreadyPresent = true;
                        continue block4;
                    }
                }
            }
            if (sacAlreadyPresent) {
                SliceSources zeSlice = null;
                boolean exactMatch = false;
                for (SliceSources ss : this.slices) {
                    if (!ss.exactMatch(createSliceAction.getSacs())) continue;
                    exactMatch = true;
                    zeSlice = ss;
                }
                if (!exactMatch) {
                    logger.error("A source is already used in the positioner : slice not created.");
                    return false;
                }
                new MoveSliceAction(this, zeSlice, createSliceAction.slicingAxisPosition).runRequest();
                return false;
            }
            if (createSliceAction.getSlice() == null) {
                createSliceAction.setSlice(new SliceSources(createSliceAction.getSacs().toArray(new SourceAndConverter[0]), createSliceAction.slicingAxisPosition, this, createSliceAction.zSliceThicknessCorrection, createSliceAction.zSliceShiftCorrection));
            }
            this.createSlice(createSliceAction.getSlice());
            logger.debug("Slice added");
        }
        return true;
    }

    protected boolean cancelCreateSlice(CreateSliceAction action) {
        this.removeSlice(action.getSlice());
        logger.debug("Slice " + action.getSlice() + " removed ");
        return true;
    }

    public SliceSources createSlice(SourceAndConverter<?>[] sacsArray, double slicingAxisPosition) {
        CreateSliceAction cs = new CreateSliceAction(this, Arrays.asList(sacsArray), slicingAxisPosition, 1.0, 0.0);
        cs.runRequest();
        return cs.getSlice();
    }

    public <T extends Entity> List<SliceSources> createSlice(SourceAndConverter<?>[] sacsArray, double slicingAxisPosition, double axisIncrement, Class<T> attributeClass, T defaultEntity) {
        ArrayList<SliceSources> out = new ArrayList<SliceSources>();
        List<SourceAndConverter<?>> sacs = Arrays.asList(sacsArray);
        if (sacs.size() > 1 && attributeClass != null) {
            Map<Entity, List<SourceAndConverter>> sacsGroups = sacs.stream().collect(Collectors.groupingBy(sac -> {
                if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sac, "SPIMDATA") != null) {
                    SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(sac, "SPIMDATA");
                    AbstractSpimData asd = sdi.asd;
                    BasicViewSetup bvs = (BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(sdi.setupId);
                    if (bvs.getAttribute(attributeClass) == null) {
                        return defaultEntity;
                    }
                    return bvs.getAttribute(attributeClass);
                }
                return defaultEntity;
            }));
            ArrayList<Entity> sortedTiles = new ArrayList<Entity>(sacsGroups.keySet());
            sortedTiles.sort(Comparator.comparingInt(Entity::getId));
            new MarkActionSequenceBatchAction(this).runRequest();
            for (int i = 0; i < sortedTiles.size(); ++i) {
                Entity group = (Entity)sortedTiles.get(i);
                CreateSliceAction cs = new CreateSliceAction(this, sacsGroups.get(group), slicingAxisPosition + (double)i * axisIncrement, 1.0, 0.0);
                cs.runRequest();
                if (cs.getSlice() == null) continue;
                out.add(cs.getSlice());
            }
            new MarkActionSequenceBatchAction(this).runRequest();
        } else {
            CreateSliceAction cs = new CreateSliceAction(this, sacs, slicingAxisPosition, 1.0, 0.0);
            cs.runRequest();
            if (cs.getSlice() != null) {
                out.add(cs.getSlice());
            }
        }
        return out;
    }

    public void moveSlice(SliceSources slice, double axisPosition) {
        new MoveSliceAction(this, slice, axisPosition).runRequest();
    }

    public void equalSpacingSelectedSlices() {
        List sortedSelected = this.getSlices().stream().filter(SliceSources::isSelected).collect(Collectors.toList());
        if (sortedSelected.size() > 2) {
            int indexPreviousKey = 0;
            new MarkActionSequenceBatchAction(this).runRequest();
            for (int indexNextKey = 1; indexNextKey < sortedSelected.size(); ++indexNextKey) {
                if (!((SliceSources)sortedSelected.get(indexNextKey)).isKeySlice() && indexNextKey != sortedSelected.size() - 1) continue;
                double totalSpacing = ((SliceSources)sortedSelected.get(indexNextKey)).getSlicingAxisPosition() - ((SliceSources)sortedSelected.get(indexPreviousKey)).getSlicingAxisPosition();
                double delta = totalSpacing / (double)(indexNextKey - indexPreviousKey);
                for (int i = indexPreviousKey + 1; i < indexNextKey; ++i) {
                    this.moveSlice((SliceSources)sortedSelected.get(i), ((SliceSources)sortedSelected.get(indexPreviousKey)).getSlicingAxisPosition() + ((double)i - (double)indexPreviousKey) * delta);
                }
                indexPreviousKey = indexNextKey;
            }
            new MarkActionSequenceBatchAction(this).runRequest();
        } else {
            this.warningMessageForUser.accept("Can't distribute spacing", "You need to have at least three slices selected.");
        }
    }

    public void editLastRegistrationSelectedSlices(boolean reuseOriginalChannels, SourcesProcessor preprocessSlice, SourcesProcessor preprocessAtlas) {
        if (this.getSelectedSlices().isEmpty()) {
            this.warningMessageForUser.accept("No selected slice", "Please select the slice you want to edit");
        } else {
            for (SliceSources slice : this.getSelectedSlices()) {
                new EditLastRegistrationAction(this, slice, reuseOriginalChannels, preprocessSlice, preprocessAtlas).runRequest();
            }
        }
    }

    public static Map<String, String> convertToString(Context ctx, Map<String, Object> params) {
        HashMap<String, String> convertedParams = new HashMap<String, String>();
        ConvertService cs = (ConvertService)ctx.getService(ConvertService.class);
        params.keySet().forEach(k -> {
            String cfr_ignored_0 = (String)convertedParams.put((String)k, (String)cs.convert(params.get(k), String.class));
        });
        return convertedParams;
    }

    public void registerSelectedSlices(Class<? extends IRegistrationPlugin> registrationClass, SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving, Map<String, Object> parameters) {
        PluginService ps = (PluginService)this.scijavaCtx.getService(PluginService.class);
        Supplier<IRegistrationPlugin> pluginSupplier = () -> {
            try {
                return (IRegistrationPlugin)ps.getPlugin(registrationClass).createInstance();
            }
            catch (InstantiableException e) {
                e.printStackTrace();
                return null;
            }
        };
        this.registerSelectedSlices(pluginSupplier, preprocessFixed, preprocessMoving, parameters);
    }

    public void registerSelectedSlices(String registrationPluginName, SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving, Map<String, Object> parameters) {
        if (externalRegistrationPlugins.containsKey(registrationPluginName)) {
            logger.debug("External registration found: " + registrationPluginName);
            this.registerSelectedSlices(externalRegistrationPlugins.get(registrationPluginName), preprocessFixed, preprocessMoving, parameters);
        } else {
            this.errorMessageForUser.accept("Registration plugin not found", "Registration type:" + registrationPluginName + " not found!");
        }
    }

    public void registerSelectedSlices(Supplier<? extends IRegistrationPlugin> registrationPluginSupplier, SourcesProcessor preprocessFixed, SourcesProcessor preprocessMoving, Map<String, Object> parameters) {
        if (this.getSelectedSlices().isEmpty()) {
            this.warningMessageForUser.accept("No selected slice", "Please select the slice(s) you want to register");
        } else {
            logger.debug("Putting user defined ROIs");
            parameters.put("px", this.roiPX);
            parameters.put("py", this.roiPY);
            parameters.put("sx", this.roiSX);
            parameters.put("sy", this.roiSY);
            for (SliceSources slice : this.getSelectedSlices()) {
                logger.debug("Starting slice registration for " + slice.getName());
                IRegistrationPlugin registration = registrationPluginSupplier.get();
                if (registration != null) {
                    logger.debug("\t slice registration for " + slice.getName() + "- set context");
                    registration.setScijavaContext(this.scijavaCtx);
                    logger.debug("\t slice registration for " + slice.getName() + "- setRegistrationParameters");
                    registration.setRegistrationParameters(MultiSlicePositioner.convertToString(this.scijavaCtx, parameters));
                    logger.debug("\t slice registration for " + slice.getName() + "- set slice zero position to zero");
                    parameters.put("pz", 0);
                    logger.debug("\t slice registration for " + slice.getName() + "- RegisterSliceAction request");
                    new RegisterSliceAction(this, slice, (Registration<SourceAndConverter<?>[]>)registration, SourcesProcessorHelper.compose((SourcesProcessor[])new SourcesProcessor[]{new SourcesZOffset(slice), preprocessFixed}), SourcesProcessorHelper.compose((SourcesProcessor[])new SourcesProcessor[]{new SourcesZOffset(slice), preprocessMoving})).runRequest();
                    continue;
                }
                logger.error("NULL registration plugin obtained, ignoring registration.");
            }
        }
    }

    public void cancelLastAction() {
        if (!this.userActions.isEmpty()) {
            CancelableAction action = this.userActions.get(this.userActions.size() - 1);
            if (action instanceof MarkActionSequenceBatchAction) {
                action.cancelRequest();
                action = this.userActions.get(this.userActions.size() - 1);
                while (!(action instanceof MarkActionSequenceBatchAction)) {
                    action.cancelRequest();
                    action = this.userActions.get(this.userActions.size() - 1);
                }
                action.cancelRequest();
            } else {
                this.userActions.get(this.userActions.size() - 1).cancelRequest();
            }
        } else {
            this.infoMessageForUser.accept("Can't cancel!", "No action can be cancelled.");
        }
    }

    public void redoAction() {
        if (this.redoableUserActions.size() > 0) {
            CancelableAction action = this.redoableUserActions.get(this.redoableUserActions.size() - 1);
            if (action instanceof MarkActionSequenceBatchAction) {
                action.runRequest();
                action = this.redoableUserActions.get(this.redoableUserActions.size() - 1);
                while (!(action instanceof MarkActionSequenceBatchAction)) {
                    action.runRequest();
                    action = this.redoableUserActions.get(this.redoableUserActions.size() - 1);
                }
                action.runRequest();
            } else {
                this.redoableUserActions.get(this.redoableUserActions.size() - 1).runRequest();
            }
        } else {
            this.infoMessageForUser.accept("Can't redo!", "No action can be redone.");
        }
    }

    public Gson getGsonStateSerializer(List<SourceAndConverter> serialized_sources) {
        GsonBuilder gsonbuilder = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(SourceAndConverter.class, (Object)new IndexedSourceAndConverterAdapter(serialized_sources)).registerTypeAdapter(SourceAndConverter[].class, (Object)new IndexedSourceAndConverterArrayAdapter(serialized_sources));
        ScijavaGsonHelper.getGsonBuilder((Context)this.scijavaCtx, (GsonBuilder)gsonbuilder, (boolean)true);
        gsonbuilder.registerTypeHierarchyAdapter(AlignerState.SliceSourcesState.class, (Object)new SliceSourcesStateDeserializer(slice -> {
            this.currentSerializedSlice = slice;
        }));
        RuntimeTypeAdapterFactory factoryActions = RuntimeTypeAdapterFactory.of(CancelableAction.class);
        factoryActions.registerSubtype(CreateSliceAction.class);
        factoryActions.registerSubtype(MoveSliceAction.class);
        factoryActions.registerSubtype(RegisterSliceAction.class);
        factoryActions.registerSubtype(KeySliceOnAction.class);
        factoryActions.registerSubtype(KeySliceOffAction.class);
        factoryActions.registerSubtype(RasterDeformationAction.class);
        factoryActions.registerSubtype(UnMirrorSliceAction.class);
        gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)factoryActions);
        gsonbuilder.registerTypeHierarchyAdapter(CreateSliceAction.class, (Object)new CreateSliceAdapter(this));
        gsonbuilder.registerTypeHierarchyAdapter(MoveSliceAction.class, (Object)new MoveSliceAdapter(this, this::currentSliceGetter));
        gsonbuilder.registerTypeHierarchyAdapter(RasterDeformationAction.class, (Object)new RasterDeformationActionAdapter(this, this::currentSliceGetter));
        gsonbuilder.registerTypeHierarchyAdapter(RegisterSliceAction.class, (Object)new RegisterSliceAdapter(this, this::currentSliceGetter));
        gsonbuilder.registerTypeHierarchyAdapter(KeySliceOnAction.class, (Object)new KeySliceOnAdapter(this, this::currentSliceGetter));
        gsonbuilder.registerTypeHierarchyAdapter(KeySliceOffAction.class, (Object)new KeySliceOffAdapter(this, this::currentSliceGetter));
        gsonbuilder.registerTypeHierarchyAdapter(UnMirrorSliceAction.class, (Object)new UnMirrorAdapter(this, this::currentSliceGetter));
        RuntimeTypeAdapterFactory factoryRegistrations = RuntimeTypeAdapterFactory.of(Registration.class);
        gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)factoryRegistrations);
        PluginService pluginService = (PluginService)this.scijavaCtx.getService(PluginService.class);
        RegistrationAdapter registrationAdapter = new RegistrationAdapter(this.scijavaCtx);
        pluginService.getPluginsOfType(IRegistrationPlugin.class).forEach(registrationPluginClass -> {
            IRegistrationPlugin plugin = (IRegistrationPlugin)pluginService.createInstance(registrationPluginClass);
            factoryRegistrations.registerSubtype(plugin.getClass());
            gsonbuilder.registerTypeHierarchyAdapter(plugin.getClass(), (Object)registrationAdapter);
        });
        factoryRegistrations.registerSubtype(ExternalRegistrationPlugin.class);
        gsonbuilder.registerTypeHierarchyAdapter(ExternalRegistrationPlugin.class, (Object)registrationAdapter);
        RuntimeTypeAdapterFactory factorySourcesProcessor = RuntimeTypeAdapterFactory.of(SourcesProcessor.class);
        factorySourcesProcessor.registerSubtype(SourcesAffineTransformer.class);
        factorySourcesProcessor.registerSubtype(SourcesChannelsSelect.class);
        factorySourcesProcessor.registerSubtype(SourcesProcessComposer.class);
        factorySourcesProcessor.registerSubtype(SourcesIdentity.class);
        factorySourcesProcessor.registerSubtype(SourcesZOffset.class);
        gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)factorySourcesProcessor);
        gsonbuilder.registerTypeHierarchyAdapter(SourcesChannelsSelect.class, (Object)new SourcesChannelSelectAdapter());
        gsonbuilder.registerTypeHierarchyAdapter(SourcesAffineTransformer.class, (Object)new SourcesAffineTransformerAdapter());
        gsonbuilder.registerTypeHierarchyAdapter(SourcesProcessComposer.class, (Object)new SourcesComposerAdapter());
        gsonbuilder.registerTypeHierarchyAdapter(SourcesIdentity.class, (Object)new SourcesIdentityAdapter());
        gsonbuilder.registerTypeHierarchyAdapter(SourcesZOffset.class, (Object)new SourcesZOffsetAdapter());
        return gsonbuilder.create();
    }

    public void stateHasBeenChanged() {
        this.stateChangedSinceLastSave = true;
    }

    public boolean isModifiedSinceLastSave() {
        return this.stateChangedSinceLastSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean saveState(File stateFileIn, boolean overwrite) {
        if (this.slices.size() == 0) {
            this.errorMessageForUser.accept("No Slices To Save", "No slices are present. Nothing saved");
            return false;
        }
        File abbaFile = stateFileIn;
        if (!FilenameUtils.getExtension((String)stateFileIn.getAbsolutePath()).equals("abba")) {
            abbaFile = new File(FilenameUtils.removeExtension((String)stateFileIn.getAbsolutePath()) + ".abba");
        }
        if (abbaFile.exists() && !overwrite) {
            this.errorMessageForUser.accept("Saving aborted", "The state file " + abbaFile.getAbsolutePath() + " already exists!");
            return false;
        }
        this.infoMessageForUser.accept("", "Waiting for all tasks to be finished before saving ... ");
        this.getSlices().forEach(SliceSources::waitForEndOfTasks);
        this.infoMessageForUser.accept("", "All tasks have been performed!");
        try {
            File tmpdir;
            this.addTask();
            String tmpDirsLocation = System.getProperty("java.io.tmpdir");
            Path path = Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), UUID.randomUUID().toString());
            try {
                tmpdir = Files.createDirectories(path, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                this.errorMessageForUser.accept("Error", "Java can't create a temporary folder in the folder " + tmpDirsLocation);
                boolean bl = false;
                this.removeTask();
                return bl;
            }
            ArrayList allSacs = new ArrayList();
            this.getSlices().forEach(sliceSource -> allSacs.addAll(Arrays.asList(sliceSource.getOriginalSources())));
            File sourcesFile = new File(tmpdir, "sources.json");
            SourceAndConverterServiceSaver sacss = new SourceAndConverterServiceSaver(sourcesFile, this.scijavaCtx, allSacs, true);
            sacss.run();
            ArrayList<SourceAndConverter> serialized_sources = new ArrayList<SourceAndConverter>();
            sacss.getSacToId().values().stream().sorted().forEach(i -> serialized_sources.add((SourceAndConverter)sacss.getIdToSac().get(i)));
            File stateFile = new File(tmpdir, "state.json");
            FileWriter writer = new FileWriter(stateFile.getAbsolutePath());
            AlignerState alignerState = new AlignerState(this);
            alignerState.version = VersionUtils.getVersion(AlignerState.class);
            this.getGsonStateSerializer(serialized_sources).toJson((Object)alignerState, (Appendable)writer);
            writer.flush();
            writer.close();
            MultiSlicePositioner.pack(tmpdir.getAbsolutePath(), abbaFile.getAbsolutePath());
            this.stateChangedSinceLastSave = false;
            boolean bl = true;
            try {
                FileUtils.deleteDirectory((File)tmpdir);
            }
            catch (IOException e) {
                this.errorMessageForUser.accept("File deletion issue.", "Could not delete the temporary folder " + tmpdir.getAbsolutePath() + ". Error: " + e.getMessage());
            }
            return bl;
            catch (IOException e) {
                boolean bl2;
                try {
                    this.errorMessageForUser.accept("Error during state saving", e.getMessage());
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    try {
                        FileUtils.deleteDirectory((File)tmpdir);
                    }
                    catch (IOException e2) {
                        this.errorMessageForUser.accept("File deletion issue.", "Could not delete the temporary folder " + tmpdir.getAbsolutePath() + ". Error: " + e2.getMessage());
                    }
                    throw throwable;
                }
                try {
                    FileUtils.deleteDirectory((File)tmpdir);
                }
                catch (IOException e3) {
                    this.errorMessageForUser.accept("File deletion issue.", "Could not delete the temporary folder " + tmpdir.getAbsolutePath() + ". Error: " + e3.getMessage());
                }
                this.removeTask();
                return bl2;
            }
        }
        finally {
            this.removeTask();
        }
    }

    private static void pack(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            });
        }
    }

    public void unpack(String zipFilePath, String destDirectory) throws IOException {
        boolean result;
        File destDir = new File(destDirectory);
        if (!destDir.exists() && !(result = destDir.mkdir())) {
            throw new IOException("Could not create folder " + destDir + " for zip unpacking.");
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                boolean result2 = dir.mkdirs();
                if (!result2) {
                    throw new IOException("Could not create folder " + dir + " for zip unpacking.");
                }
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadState(File stateFileAbba) {
        File tmpdir;
        if (!stateFileAbba.getAbsolutePath().endsWith(".abba")) {
            return this.legacyLoadState(stateFileAbba);
        }
        boolean emptyState = this.slices.size() == 0;
        this.getSlices().forEach(SliceSources::waitForEndOfTasks);
        String tmpDirsLocation = System.getProperty("java.io.tmpdir");
        Path path = Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), UUID.randomUUID().toString());
        try {
            tmpdir = Files.createDirectories(path, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            this.errorMessageForUser.accept("Error", "Java can't create a temporary folder in the folder " + tmpDirsLocation);
            return false;
        }
        try {
            this.addTask();
            this.unpack(stateFileAbba.getAbsolutePath(), tmpdir.getAbsolutePath());
            File sacsFile = new File(tmpdir, "sources.json");
            SourceAndConverterServiceLoader sacsl = new SourceAndConverterServiceLoader(sacsFile.getAbsolutePath(), sacsFile.getParent(), this.scijavaCtx, false, true);
            sacsl.run();
            ArrayList<SourceAndConverter> serialized_sources = new ArrayList<SourceAndConverter>();
            sacsl.getSacToId().values().stream().sorted().forEach(i -> serialized_sources.add((SourceAndConverter)sacsl.getIdToSac().get(i)));
            Gson gson = this.getGsonStateSerializer(serialized_sources);
            File stateFile = new File(tmpdir, "state.json");
            if (!stateFile.exists()) {
                this.errorMessageForUser.accept("Error during state file loading", "Error : file " + stateFile.getAbsolutePath() + " not found!");
                boolean bl = false;
                return bl;
            }
            try {
                FileReader fileReader = new FileReader(stateFile);
                JsonObject element = (JsonObject)gson.fromJson((Reader)fileReader, JsonObject.class);
                String version = element.get("version").getAsString();
                AlignerState state = (AlignerState)gson.fromJson((JsonElement)element, AlignerState.class);
                fileReader.close();
                String infoMessageForUser = "";
                DecimalFormat df = new DecimalFormat("###.000");
                Function<Double, String> a = d -> df.format(d * 180.0 / Math.PI);
                if (state.rotationX != this.reslicedAtlas.getRotateX()) {
                    infoMessageForUser = infoMessageForUser + "Current X Angle : " + a.apply(this.reslicedAtlas.getRotateX()) + " has been updated to " + a.apply(state.rotationX) + "\n";
                    this.reslicedAtlas.setRotateX(state.rotationX);
                }
                if (state.rotationY != this.reslicedAtlas.getRotateY()) {
                    infoMessageForUser = infoMessageForUser + "Current Y Angle : " + a.apply(this.reslicedAtlas.getRotateY()) + " has been updated to " + a.apply(state.rotationY) + "\n";
                    this.reslicedAtlas.setRotateY(state.rotationY);
                }
                if (!infoMessageForUser.isEmpty()) {
                    this.infoMessageForUser.accept("Info", infoMessageForUser);
                }
                state.slices_state_list.forEach(sliceState -> {
                    sliceState.slice.waitForEndOfTasks();
                    sliceState.slice.transformSourceOrigin((AffineTransform3D)sliceState.preTransform);
                    sliceState.slice.sourcesChanged();
                });
                if (emptyState) {
                    this.stateChangedSinceLastSave = false;
                }
            }
            catch (Exception e) {
                this.errorMessageForUser.accept("Error during state file loading", "Error: " + e.getMessage() + "\n Please also check the stack trace.");
                e.printStackTrace();
                boolean element = false;
                this.removeTask();
                try {
                    FileUtils.deleteDirectory((File)tmpdir);
                    return element;
                }
                catch (IOException e2) {
                    this.errorMessageForUser.accept("IOException during state file loading", "Could not delete temp folder " + tmpdir.getAbsolutePath() + "\n Error: " + e2.getMessage() + "\n Please also check the stack trace.");
                    e2.printStackTrace();
                }
                return element;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.errorMessageForUser.accept("IOException during state file loading", "Error: " + e.getMessage() + "\n Please also check the stack trace.");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.removeTask();
            try {
                FileUtils.deleteDirectory((File)tmpdir);
            }
            catch (IOException e) {
                this.errorMessageForUser.accept("IOException during state file loading", "Could not delete temp folder " + tmpdir.getAbsolutePath() + "\n Error: " + e.getMessage() + "\n Please also check the stack trace.");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean legacyLoadState(File stateFile) {
        try {
            this.addTask();
            boolean emptyState = this.slices.size() == 0;
            this.getSlices().forEach(SliceSources::waitForEndOfTasks);
            String fileNoExt = FilenameUtils.removeExtension((String)stateFile.getAbsolutePath());
            File sacsFile = new File(fileNoExt + "_sources.json");
            if (!sacsFile.exists()) {
                this.errorMessageForUser.accept("File not found.", "File " + sacsFile.getAbsolutePath() + " not found!");
                boolean bl = false;
                return bl;
            }
            SourceAndConverterServiceLoader sacsl = new SourceAndConverterServiceLoader(sacsFile.getAbsolutePath(), sacsFile.getParent(), this.scijavaCtx, false);
            try {
                sacsl.run();
            }
            catch (Exception e) {
                this.errorMessageForUser.accept("Exception when deserialising image source.", "Error: " + e.getMessage() + "\n Please also check the stack trace.");
                e.printStackTrace();
            }
            ArrayList<SourceAndConverter> serialized_sources = new ArrayList<SourceAndConverter>();
            sacsl.getSacToId().values().stream().sorted().forEach(i -> serialized_sources.add((SourceAndConverter)sacsl.getIdToSac().get(i)));
            Gson gson = this.getGsonStateSerializer(serialized_sources);
            if (!stateFile.exists()) {
                this.errorMessageForUser.accept("File not found", "Error : file " + stateFile.getAbsolutePath() + " not found!");
                boolean bl = false;
                return bl;
            }
            try {
                String version;
                FileReader fileReader = new FileReader(stateFile);
                JsonObject element = (JsonObject)gson.fromJson((Reader)fileReader, JsonObject.class);
                String string = version = element.has("version") ? element.get("version").getAsString() : null;
                if (version == null) {
                    this.infoMessageForUser.accept("Old state file!", "A conversion is required.");
                    element = (JsonObject)AlignerState.convertOldJson((JsonElement)element);
                    this.infoMessageForUser.accept("Old state file!", "Conversion done.");
                }
                AlignerState state = (AlignerState)gson.fromJson((JsonElement)element, AlignerState.class);
                fileReader.close();
                String warningMessageForUser = "";
                DecimalFormat df = new DecimalFormat("###.000");
                Function<Double, String> a = d -> df.format(d * 180.0 / Math.PI);
                if (state.rotationX != this.reslicedAtlas.getRotateX()) {
                    warningMessageForUser = warningMessageForUser + "Current X Angle : " + a.apply(this.reslicedAtlas.getRotateX()) + " has been updated to " + a.apply(state.rotationX) + "\n";
                    this.reslicedAtlas.setRotateX(state.rotationX);
                }
                if (state.rotationY != this.reslicedAtlas.getRotateY()) {
                    warningMessageForUser = warningMessageForUser + "Current Y Angle : " + a.apply(this.reslicedAtlas.getRotateY()) + " has been updated to " + a.apply(state.rotationY) + "\n";
                    this.reslicedAtlas.setRotateY(state.rotationY);
                }
                if (!warningMessageForUser.equals("")) {
                    this.warningMessageForUser.accept("Warning", warningMessageForUser);
                }
                state.slices_state_list.forEach(sliceState -> {
                    sliceState.slice.waitForEndOfTasks();
                    sliceState.slice.transformSourceOrigin((AffineTransform3D)sliceState.preTransform);
                });
                if (emptyState) {
                    this.stateChangedSinceLastSave = false;
                }
            }
            catch (Exception e) {
                this.errorMessageForUser.accept("Error during state loading", "Message: " + e.getMessage() + "\n Please also check the stack trace.");
                e.printStackTrace();
                boolean bl = false;
                this.removeTask();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.removeTask();
        }
    }

    SliceSources currentSliceGetter() {
        return this.currentSerializedSlice;
    }

    public void addSliceListener(SliceChangeListener listener) {
        logger.debug("Adding slice change listener :" + listener + " of class" + listener.getClass().getSimpleName());
        this.listeners.add(listener);
    }

    public void removeSliceListener(SliceChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifySourcesChanged(SliceSources sliceSources) {
        this.listeners.forEach(sliceChangeListener -> sliceChangeListener.sliceSourcesChanged(sliceSources));
    }

    public void slicePreTransformChanged(SliceSources sliceSources) {
        this.stateHasBeenChanged();
        this.listeners.forEach(sliceChangeListener -> sliceChangeListener.slicePretransformChanged(sliceSources));
    }

    public void addTask() {
        this.numberOfTasks.incrementAndGet();
        logger.debug("Task added. Current number of tasks: " + this.numberOfTasks.get());
    }

    public void removeTask() {
        this.numberOfTasks.decrementAndGet();
        logger.debug("Task removed. Current number of tasks: " + this.numberOfTasks.get());
    }

    public int getNumberOfTasks() {
        return this.numberOfTasks.get();
    }

    public void converterChanged(SliceSources sliceSources) {
        this.listeners.forEach(sliceChangeListener -> sliceChangeListener.converterChanged(sliceSources));
    }

    public void addMultiSlicePositionerListener(MultiSlicePositionerListener listener) {
        this.mpListeners.add(listener);
    }

    public void removeMultiSlicePositionerListener(MultiSlicePositionerListener listener) {
        this.mpListeners.remove(listener);
    }

    public static void registerRegistrationPlugin(String name, Supplier<? extends IRegistrationPlugin> pluginSupplier) {
        externalRegistrationPlugins.put(name, pluginSupplier);
    }

    public static boolean isExternalRegistrationPlugin(String name) {
        return externalRegistrationPlugins.containsKey(name);
    }

    public static Supplier<? extends IRegistrationPlugin> getExternalRegistrationPluginSupplier(String name) {
        return externalRegistrationPlugins.get(name);
    }

    public Map<String, List<String>> getExternalRegistrationPluginsUI() {
        return externalRegistrationPluginsUI;
    }

    public static void registerRegistrationPluginUI(String registrationTypeName, String registrationUICommandName) {
        if (!externalRegistrationPluginsUI.containsKey(registrationTypeName)) {
            externalRegistrationPluginsUI.put(registrationTypeName, new ArrayList());
        }
        externalRegistrationPluginsUI.get(registrationTypeName).add(registrationUICommandName);
    }

    public static class SliceInfo {
        String type = "ABBA Registration";
        String abbaInfoVersion;
        String atlas;
        int sliceHashCode;
        int sessionHashcode;
        double[] matrixAtlas;
        double[] matrixAlignerToAtlas;
        double sliceAxisPosition;
        double rotX;
        double rotY;

        public SliceInfo(MultiSlicePositioner mp, SliceSources slice) {
            this.sliceAxisPosition = slice.getSlicingAxisPosition();
            this.matrixAtlas = mp.getReslicedAtlas().getSlicingTransform().getRowPackedCopy();
            this.matrixAlignerToAtlas = mp.getAffineTransformFromAlignerToAtlas().getRowPackedCopy();
            this.rotX = mp.getReslicedAtlas().getRotateX();
            this.rotY = mp.getReslicedAtlas().getRotateY();
            this.sliceHashCode = slice.hashCode();
            this.sessionHashcode = mp.hashCode();
            this.abbaInfoVersion = VersionUtils.getVersion(MultiSlicePositioner.class);
            this.atlas = mp.getAtlas().getName();
        }
    }

    public static interface MultiSlicePositionerListener {
        public void closing(MultiSlicePositioner var1);
    }

    public static interface SliceChangeListener {
        public void sliceDeleted(SliceSources var1);

        public void sliceCreated(SliceSources var1);

        public void sliceZPositionChanged(SliceSources var1);

        public void sliceSelected(SliceSources var1);

        public void sliceDeselected(SliceSources var1);

        public void sliceSourcesChanged(SliceSources var1);

        public void slicePretransformChanged(SliceSources var1);

        public void sliceKeyOn(SliceSources var1);

        public void sliceKeyOff(SliceSources var1);

        public void roiChanged();

        public void actionEnqueue(SliceSources var1, CancelableAction var2);

        public void actionStarted(SliceSources var1, CancelableAction var2);

        public void actionFinished(SliceSources var1, CancelableAction var2, boolean var3);

        public void actionCancelEnqueue(SliceSources var1, CancelableAction var2);

        public void actionCancelStarted(SliceSources var1, CancelableAction var2);

        public void actionCancelFinished(SliceSources var1, CancelableAction var2, boolean var3);

        public void converterChanged(SliceSources var1);
    }
}

