/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.util.function.Supplier;

public class MoveSliceAction
extends CancelableAction {
    private final SliceSources sliceSource;
    private double oldSlicingAxisPosition;
    private double newSlicingAxisPosition;
    Supplier<Double> slicingAxisPositionSupplier = null;

    public MoveSliceAction(MultiSlicePositioner mp, SliceSources sliceSource, double slicingAxisPosition) {
        super(mp);
        this.sliceSource = sliceSource;
        this.oldSlicingAxisPosition = sliceSource.getSlicingAxisPosition();
        this.newSlicingAxisPosition = slicingAxisPosition;
        this.hide();
    }

    public MoveSliceAction(MultiSlicePositioner mp, SliceSources sliceSource, Supplier<Double> slicingAxisPositionSupplier) {
        super(mp);
        this.sliceSource = sliceSource;
        this.slicingAxisPositionSupplier = slicingAxisPositionSupplier;
        this.hide();
    }

    @Override
    public SliceSources getSliceSources() {
        return this.sliceSource;
    }

    public double getSlicingAxisPosition() {
        return this.newSlicingAxisPosition;
    }

    @Override
    protected boolean run() {
        this.oldSlicingAxisPosition = this.sliceSource.getSlicingAxisPosition();
        if (this.slicingAxisPositionSupplier != null) {
            this.newSlicingAxisPosition = this.slicingAxisPositionSupplier.get();
        }
        this.sliceSource.setSlicingAxisPosition(this.newSlicingAxisPosition);
        return true;
    }

    public String toString() {
        return "Axis Position = " + new DecimalFormat("###.##").format(this.newSlicingAxisPosition);
    }

    @Override
    protected boolean cancel() {
        this.sliceSource.setSlicingAxisPosition(this.oldSlicingAxisPosition);
        return true;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        g.drawString("M", (int)px - 5, (int)py + 5);
    }
}

