/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Graphics2D;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class LockAndRunOnceSliceAction
extends CancelableAction {
    private final SliceSources sliceSource;
    private final AtomicInteger counter;
    private final int counterTarget;
    private final Supplier<Boolean> runnable;
    private final AtomicBoolean result;
    private boolean done = false;

    public LockAndRunOnceSliceAction(MultiSlicePositioner mp, SliceSources sliceSource, AtomicInteger counter, int counterTarget, Supplier<Boolean> runnable, AtomicBoolean result) {
        super(mp);
        this.sliceSource = sliceSource;
        this.counter = counter;
        this.counterTarget = counterTarget;
        this.runnable = runnable;
        this.result = result;
        this.hide();
    }

    @Override
    public SliceSources getSliceSources() {
        return this.sliceSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        if (!this.done) {
            int counterValue = this.counter.incrementAndGet();
            if (counterValue == this.counterTarget) {
                this.result.set(this.runnable.get());
                this.counter.incrementAndGet();
                AtomicInteger atomicInteger = this.counter;
                synchronized (atomicInteger) {
                    this.counter.notifyAll();
                }
            }
            while (counterValue != this.counterTarget + 1) {
                AtomicInteger atomicInteger = this.counter;
                synchronized (atomicInteger) {
                    try {
                        this.counter.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    counterValue = this.counter.get();
                }
            }
            this.done = true;
        }
        return this.result.get();
    }

    public String toString() {
        return "Lock Slice ";
    }

    @Override
    protected boolean cancel() {
        return true;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        g.drawString("L", (int)px - 5, (int)py + 5);
    }
}

