/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.DeleteLastRegistrationAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import ch.epfl.biop.atlas.aligner.SourcesZOffset;
import ch.epfl.biop.registration.plugin.RegistrationPluginHelper;
import ch.epfl.biop.sourceandconverter.processor.SourcesIdentity;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessComposer;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessor;
import ch.epfl.biop.sourceandconverter.processor.SourcesProcessorHelper;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class EditLastRegistrationAction
extends CancelableAction {
    private final SliceSources slice;
    final RegisterSliceAction rs;
    private final boolean reuseOriginalChannels;
    private final SourcesProcessor preprocessSlice;
    private final SourcesProcessor preprocessAtlas;

    public EditLastRegistrationAction(MultiSlicePositioner mp, SliceSources slice, boolean reuseOriginalChannels, SourcesProcessor preprocessSlice, SourcesProcessor preprocessAtlas) {
        super(mp);
        this.reuseOriginalChannels = reuseOriginalChannels;
        this.slice = slice;
        this.preprocessAtlas = preprocessAtlas;
        this.preprocessSlice = preprocessSlice;
        ArrayList<CancelableAction> registrationActionsCompiled = new ArrayList<CancelableAction>();
        for (CancelableAction action : mp.getActionsFromSlice(slice)) {
            if (action instanceof RegisterSliceAction) {
                registrationActionsCompiled.add(action);
            }
            if (!(action instanceof DeleteLastRegistrationAction)) continue;
            registrationActionsCompiled.remove(registrationActionsCompiled.size() - 1);
        }
        this.rs = registrationActionsCompiled.size() == 0 ? null : (RegisterSliceAction)registrationActionsCompiled.get(registrationActionsCompiled.size() - 1);
        this.hide();
    }

    @Override
    public boolean isValid() {
        return this.rs != null && RegistrationPluginHelper.isEditable(this.rs.registration);
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
    }

    @Override
    public SliceSources getSliceSources() {
        return this.slice;
    }

    @Override
    protected boolean run() {
        if (!this.reuseOriginalChannels) {
            SourcesProcessor pA = SourcesProcessorHelper.compose((SourcesProcessor[])new SourcesProcessor[]{EditLastRegistrationAction.removeSourcesZOffset(this.rs.preprocessFixed), new SourcesZOffset(this.slice)});
            SourcesProcessor pS = SourcesProcessorHelper.compose((SourcesProcessor[])new SourcesProcessor[]{EditLastRegistrationAction.removeSourcesZOffset(this.rs.preprocessMoving), new SourcesZOffset(this.slice)});
            this.slice.editLastRegistration(SourcesProcessorHelper.compose((SourcesProcessor[])new SourcesProcessor[]{this.preprocessAtlas, SourcesProcessorHelper.removeChannelsSelect((SourcesProcessor)pA)}), SourcesProcessorHelper.compose((SourcesProcessor[])new SourcesProcessor[]{this.preprocessSlice, SourcesProcessorHelper.removeChannelsSelect((SourcesProcessor)pS)}));
        } else {
            this.slice.editLastRegistration(this.rs.preprocessFixed, this.rs.preprocessMoving);
        }
        this.slice.sourcesChanged();
        this.getMP().stateHasBeenChanged();
        return true;
    }

    @Override
    protected boolean cancel() {
        return true;
    }

    private static SourcesProcessor removeSourcesZOffset(SourcesProcessor processor) {
        if (processor instanceof SourcesZOffset) {
            return new SourcesIdentity();
        }
        if (processor instanceof SourcesProcessComposer) {
            SourcesProcessComposer composer_in = (SourcesProcessComposer)processor;
            return new SourcesProcessComposer(EditLastRegistrationAction.removeSourcesZOffset(composer_in.f2), EditLastRegistrationAction.removeSourcesZOffset(composer_in.f1));
        }
        return processor;
    }
}

