/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSliceAction
extends CancelableAction {
    protected static final Logger logger = LoggerFactory.getLogger(DeleteSliceAction.class);
    private final SliceSources sliceSource;
    List<CancelableAction> savedActions;

    public DeleteSliceAction(MultiSlicePositioner mp, SliceSources slice) {
        super(mp);
        this.sliceSource = slice;
    }

    @Override
    public SliceSources getSliceSources() {
        return this.sliceSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run() {
        Class<DeleteSliceAction> clazz = DeleteSliceAction.class;
        synchronized (DeleteSliceAction.class) {
            this.getMP().addTask();
            logger.debug("Deleting slice " + this.getSliceSources() + " ...");
            this.savedActions = this.getMP().getActionsFromSlice(this.sliceSource);
            this.savedActions.remove(this);
            this.savedActions.remove(this);
            this.savedActions.remove(this);
            logger.debug("Saved actions slice in run : " + this.sliceSource);
            Collections.reverse(this.savedActions);
            this.savedActions.forEach(action -> {
                if (action != this) {
                    action.cancel();
                }
            });
            Collections.reverse(this.savedActions);
            logger.debug("Slice " + this.getSliceSources() + " deleted !");
            this.getMP().stateHasBeenChanged();
            this.getMP().removeTask();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        Class<DeleteSliceAction> clazz = DeleteSliceAction.class;
        synchronized (DeleteSliceAction.class) {
            logger.debug("Cancelling delete slice for slice " + this.getSliceSources());
            this.savedActions.forEach(action -> {
                if (action != this) {
                    action.run();
                }
            });
            this.getMP().stateHasBeenChanged();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
        switch (this.sliceSource.getActionState(this)) {
            case "(done)": {
                g.setColor(new Color(0, 255, 0, 200));
                break;
            }
            case "(locked)": {
                g.setColor(new Color(255, 0, 0, 200));
                break;
            }
            case "(pending)": {
                g.setColor(new Color(255, 255, 0, 200));
            }
        }
        g.fillOval((int)(px - 7.0), (int)(py - 7.0), 14, 14);
        g.setColor(new Color(255, 255, 255, 200));
        g.drawString("Delete", (int)px - 4, (int)py + 5);
    }
}

