/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.RegisterSliceAction;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class DeleteLastRegistrationAction
extends CancelableAction {
    private final SliceSources sliceSource;
    final RegisterSliceAction rs;

    public DeleteLastRegistrationAction(MultiSlicePositioner mp, SliceSources slice) {
        super(mp);
        this.sliceSource = slice;
        ArrayList<CancelableAction> registrationActionsCompiled = new ArrayList<CancelableAction>();
        for (CancelableAction action : mp.getActionsFromSlice(slice)) {
            if (action instanceof RegisterSliceAction) {
                registrationActionsCompiled.add(action);
            }
            if (!(action instanceof DeleteLastRegistrationAction) || registrationActionsCompiled.size() - 1 == -1) continue;
            registrationActionsCompiled.remove(registrationActionsCompiled.size() - 1);
        }
        this.rs = registrationActionsCompiled.size() == 0 ? null : (RegisterSliceAction)registrationActionsCompiled.get(registrationActionsCompiled.size() - 1);
        this.hide();
    }

    @Override
    public boolean isValid() {
        return this.rs != null;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
    }

    @Override
    public SliceSources getSliceSources() {
        return this.sliceSource;
    }

    @Override
    protected boolean run() {
        if (this.rs != null) {
            this.rs.hide();
            boolean result = this.rs.cancel();
            this.getMP().stateHasBeenChanged();
            return result;
        }
        return false;
    }

    @Override
    protected boolean cancel() {
        if (this.rs != null) {
            this.rs.show();
            boolean result = this.rs.run();
            this.getMP().stateHasBeenChanged();
            return result;
        }
        return true;
    }
}

