/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.sql.Timestamp;
import java.util.function.BiConsumer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DebugView
implements MultiSlicePositioner.SliceChangeListener {
    final BiConsumer<SliceSources, String> logger = this::append;
    final MultiSlicePositioner msp;
    final JTextArea area = new JTextArea();

    private synchronized void append(SliceSources slice, String s) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (slice == null) {
            this.area.append(timestamp + "\t-\t" + s + "\n");
        } else {
            this.area.append(timestamp + "\t" + slice.getName() + "\t" + s + "\n");
        }
    }

    public DebugView(MultiSlicePositioner msp) {
        JFrame debug = new JFrame("Debug MultiSlicePositioner " + msp);
        this.msp = msp;
        JPanel debugActions = new JPanel(new FlowLayout());
        JButton writeUserActions = new JButton("Write User Actions");
        writeUserActions.addActionListener(e -> msp.userActions.forEach(action -> this.logger.accept(action.getSliceSources(), "\t" + action)));
        JButton writeRedoableUserActions = new JButton("Write Redoable User Actions");
        writeRedoableUserActions.addActionListener(e -> msp.redoableUserActions.forEach(action -> this.logger.accept(action.getSliceSources(), "\t" + action)));
        debugActions.add(writeUserActions);
        debugActions.add(writeRedoableUserActions);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.area), "Center");
        panel.add((Component)debugActions, "South");
        debug.add(panel);
        debug.pack();
        debug.setVisible(true);
        msp.addSliceListener(this);
    }

    @Override
    public void sliceDeleted(SliceSources slice) {
        this.logger.accept(slice, "Deleted slice " + slice.getName());
    }

    @Override
    public void sliceCreated(SliceSources slice) {
        this.logger.accept(slice, "Created slice " + slice.getName());
    }

    @Override
    public void sliceZPositionChanged(SliceSources slice) {
        this.logger.accept(slice, "Z position changed slice " + slice.getName());
    }

    @Override
    public void sliceSelected(SliceSources slice) {
        this.logger.accept(slice, "Slice selected " + slice.getName());
    }

    @Override
    public void sliceDeselected(SliceSources slice) {
        this.logger.accept(slice, "Slice deselected " + slice.getName());
    }

    @Override
    public void sliceSourcesChanged(SliceSources slice) {
        this.logger.accept(slice, "Slice sources changed " + slice.getName());
    }

    @Override
    public void slicePretransformChanged(SliceSources slice) {
        this.logger.accept(slice, "Slice pretransform changed " + slice.getName());
    }

    @Override
    public void sliceKeyOn(SliceSources slice) {
        this.logger.accept(slice, "Slice is a key Slice " + slice.getName());
    }

    @Override
    public void sliceKeyOff(SliceSources slice) {
        this.logger.accept(slice, "Slice is not a key slice " + slice.getName());
    }

    @Override
    public void roiChanged() {
        this.logger.accept(null, "ROI changed");
    }

    @Override
    public void actionEnqueue(SliceSources slice, CancelableAction action) {
        this.logger.accept(slice, "Action [" + action.actionClassString() + "] Enqueued");
    }

    @Override
    public void actionStarted(SliceSources slice, CancelableAction action) {
        this.logger.accept(slice, "Action [" + action.actionClassString() + "] Started");
    }

    @Override
    public void actionFinished(SliceSources slice, CancelableAction action, boolean result) {
        String success = result ? "Yes" : "No";
        this.logger.accept(slice, "Action [" + action.actionClassString() + "] Finished. Success ? " + success);
    }

    @Override
    public void actionCancelEnqueue(SliceSources slice, CancelableAction action) {
        this.logger.accept(slice, "Action [" + action.actionClassString() + "] Cancelation enqueued.");
    }

    @Override
    public void actionCancelStarted(SliceSources slice, CancelableAction action) {
        this.logger.accept(slice, "Action [" + action.actionClassString() + "] Cancelation Started.");
    }

    @Override
    public void actionCancelFinished(SliceSources slice, CancelableAction action, boolean result) {
        String success = result ? "Yes" : "No";
        this.logger.accept(slice, "Action [" + action.actionClassString() + "] Cancelation Ended. Success ? " + success);
    }

    @Override
    public void converterChanged(SliceSources slice) {
        this.logger.accept(slice, "Slice is converter has changed " + slice.getName());
    }
}

