/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.atlas.aligner.CancelableAction;
import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSliceAction
extends CancelableAction {
    protected static Logger logger = LoggerFactory.getLogger(CreateSliceAction.class);
    private final List<SourceAndConverter<?>> sacs;
    private SliceSources sliceSource;
    public final double slicingAxisPosition;
    public final double zSliceThicknessCorrection;
    public final double zSliceShiftCorrection;

    public CreateSliceAction(MultiSlicePositioner mp, List<SourceAndConverter<?>> sacs, double slicingAxisPosition, double zSliceThicknessCorrection, double zSliceShiftCorrection) {
        super(mp);
        this.sacs = sacs;
        this.slicingAxisPosition = slicingAxisPosition;
        this.zSliceShiftCorrection = zSliceShiftCorrection;
        this.zSliceThicknessCorrection = zSliceThicknessCorrection;
        this.hide();
    }

    @Override
    public SliceSources getSliceSources() {
        return this.sliceSource;
    }

    public List<SourceAndConverter<?>> getSacs() {
        return this.sacs;
    }

    @Override
    protected boolean run() {
        this.getMP().addTask();
        boolean result = this.getMP().runCreateSlice(this);
        this.getMP().stateHasBeenChanged();
        this.getMP().removeTask();
        return result;
    }

    public SliceSources getSlice() {
        return this.sliceSource;
    }

    public String toString() {
        return "Slice Created " + new DecimalFormat("###.##").format(this.slicingAxisPosition);
    }

    @Override
    protected boolean cancel() {
        this.getMP().addTask();
        boolean result = this.getMP().cancelCreateSlice(this);
        this.getMP().stateHasBeenChanged();
        this.getMP().removeTask();
        return result;
    }

    @Override
    public void drawAction(Graphics2D g, double px, double py, double scale) {
    }

    public void setSlice(SliceSources sliceSources) {
        this.sliceSource = sliceSources;
    }
}

