/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.atlas.aligner;

import ch.epfl.biop.atlas.aligner.MultiSlicePositioner;
import ch.epfl.biop.atlas.aligner.SliceSources;
import java.awt.Graphics2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CancelableAction {
    final MultiSlicePositioner mp;
    protected static Logger logger = LoggerFactory.getLogger(CancelableAction.class);
    private boolean isHidden = false;

    public CancelableAction(MultiSlicePositioner mp) {
        this.mp = mp;
    }

    public MultiSlicePositioner getMP() {
        return this.mp;
    }

    public abstract SliceSources getSliceSources();

    public final void runRequest() {
        this.runRequest(false);
    }

    public final void runRequest(boolean launchInExtraThread) {
        this.mp.runRequest(this, launchInExtraThread);
    }

    public final void cancelRequest() {
        this.mp.cancelRequest(this);
    }

    protected abstract boolean run();

    protected abstract boolean cancel();

    public void hide() {
        this.isHidden = true;
    }

    public void show() {
        this.isHidden = false;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isValid() {
        return true;
    }

    public String actionClassString() {
        return this.getClass().getSimpleName();
    }

    public abstract void drawAction(Graphics2D var1, double var2, double var4, double var6);
}

