/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class ResourcesMonitor
extends JPanel {
    final JLabel cpuLabelSystem;
    final JProgressBar cpuBarSystem;
    final JLabel memLabel;
    final JProgressBar memBar;
    final JButton gcButton;
    final Thread monitor;
    final SystemInfo si = new SystemInfo();
    final HardwareAbstractionLayer hal = this.si.getHardware();
    final CentralProcessor cpu = this.hal.getProcessor();
    long[] prevTicks = new long[CentralProcessor.TickType.values().length];

    public ResourcesMonitor() {
        this.setLayout(new GridLayout(8, 1));
        this.cpuLabelSystem = new JLabel("CPU Usage - System (%)");
        this.cpuBarSystem = new JProgressBar();
        this.memLabel = new JLabel("Mem (/)");
        this.memBar = new JProgressBar();
        this.gcButton = new JButton("Trigger GC");
        this.add(this.cpuLabelSystem);
        this.add(this.cpuBarSystem);
        this.add(this.memLabel);
        this.add(this.memBar);
        this.add(this.gcButton);
        this.gcButton.addActionListener(e -> System.gc());
        this.monitor = new Thread(() -> {
            boolean monitoring = true;
            while (monitoring) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    monitoring = false;
                }
                int loadSystem = (int)this.getCPU();
                this.cpuBarSystem.setValue(loadSystem);
                this.cpuLabelSystem.setText("CPU Usage - System (" + loadSystem + "%)");
                double usedMemMb = ((double)Runtime.getRuntime().totalMemory() - (double)Runtime.getRuntime().freeMemory()) / 1048576.0;
                double memTotalMb = (double)Runtime.getRuntime().totalMemory() / 1048576.0;
                this.memLabel.setText("Mem (" + (int)usedMemMb + " Mb / " + (int)memTotalMb + " Mb)");
                this.memBar.setValue((int)(usedMemMb / memTotalMb * 100.0));
            }
        });
        this.monitor.start();
    }

    double getCPU() {
        double cpuLoad = this.cpu.getSystemCpuLoadBetweenTicks(this.prevTicks) * 100.0;
        this.prevTicks = this.cpu.getSystemCpuLoadTicks();
        return cpuLoad;
    }

    public void stop() {
        this.monitor.interrupt();
    }
}

