/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.transformix;

import ij.IJ;
import ij.Prefs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Transformix {
    public static final String keyPrefix = Transformix.class.getName() + ".";
    static final String defaultExePath = "transformix";
    public static String exePath = Prefs.get((String)(keyPrefix + "exePath"), (String)"transformix");
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    public static void setExePath(File f) {
        exePath = f.getAbsolutePath();
        Prefs.set((String)(keyPrefix + "exePath"), (String)exePath);
    }

    public static void notifyIsInClassPath() {
        exePath = defaultExePath;
        Prefs.set((String)(keyPrefix + "exePath"), (String)exePath);
    }

    static void execute(List<String> options, boolean verbose) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        if (IJ.isMacOSX() || IJ.isLinux()) {
            String transformix_folder_path = new File(new File(exePath).getParent()).getParent();
            String transformationCommand = "";
            for (String command : options) {
                transformationCommand = transformationCommand + " " + command;
            }
            cmd.add("bash");
            cmd.add("-c");
            String exportPATH = "export PATH=" + transformix_folder_path + "/bin/:$PATH";
            String exportLIB = "";
            if (IJ.isMacOSX()) {
                exportLIB = "export DYLD_LIBRARY_PATH=" + transformix_folder_path + "/lib/:$DYLD_LIBRARY_PATH";
            } else if (IJ.isLinux()) {
                exportLIB = "export LD_LIBRARY_PATH=" + transformix_folder_path + "/lib/:$LD_LIBRARY_PATH";
            }
            cmd.add(exportLIB + " ; " + exportPATH + " ; transformix" + transformationCommand);
        } else if (IJ.isWindows()) {
            cmd.add(exePath);
            cmd.addAll(options);
        } else {
            System.err.println("Transformix error: type of OS not found.");
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (verbose) {
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        } else {
            pb.redirectOutput(NULL_FILE);
        }
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        p.waitFor();
    }

    public static void execute(String singleCommand) throws IOException, InterruptedException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(singleCommand);
        Transformix.execute(cmdList, false);
    }
}

