/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.transformix;

import ch.epfl.biop.java.utilities.TempDirectory;
import ch.epfl.biop.java.utilities.image.ConvertibleImage;
import ch.epfl.biop.java.utilities.roi.ConvertibleRois;
import ch.epfl.biop.java.utilities.roi.types.TransformixInputRoisFile;
import ch.epfl.biop.java.utilities.roi.types.TransformixOutputRoisFile;
import ch.epfl.biop.wrappers.elastix.RegisterHelper;
import ch.epfl.biop.wrappers.transformix.TransformixTask;
import ch.epfl.biop.wrappers.transformix.TransformixTaskSettings;
import ij.ImagePlus;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Supplier;

public class TransformHelper {
    Supplier<String> transformFile;
    ConvertibleImage imageToTransform = new ConvertibleImage();
    ConvertibleImage imageTransformed = new ConvertibleImage();
    ConvertibleRois roisToTransform = new ConvertibleRois();
    ConvertibleRois roisTransformed = new ConvertibleRois();
    int transformType = -1;
    static final int UNDEFINED = -1;
    static final int IMAGE_TRANSFORM = 0;
    static final int ROIS_TRANSFORM = 1;
    Supplier<String> ptsPath;
    boolean transformTaskSet = false;
    boolean verbose = false;
    Supplier<String> outputDir;
    String transformInfo = null;

    public void setTransformFile(RegisterHelper rh) {
        this.transformFile = rh::getFinalTransformFile;
        this.transformTaskSet = false;
    }

    public void verbose() {
        this.verbose = true;
    }

    public void setTransformFile(Supplier<String> pathToTransformFile) {
        this.transformFile = pathToTransformFile;
        this.transformTaskSet = false;
    }

    public void setTransformFile(String pathToTransformFile) {
        this.transformFile = () -> pathToTransformFile;
        this.transformTaskSet = false;
    }

    public void setImage(ImagePlus imp) {
        this.imageToTransform.set(imp);
        this.transformTaskSet = false;
        this.transformType = 0;
    }

    public void setImage(URL url) {
        this.imageToTransform.set(url);
        this.transformTaskSet = false;
        this.transformType = 0;
    }

    public void setImage(ConvertibleImage img) {
        this.imageToTransform = img;
        this.transformType = 0;
    }

    public void setRois(ConvertibleRois rois) {
        this.roisToTransform = rois;
        this.transformType = 1;
    }

    public void setImage(String pathToImage) {
        this.imageToTransform.set(new File(pathToImage));
        this.transformTaskSet = false;
        this.transformType = 0;
    }

    public String getOutput() {
        if (this.transformType == 0) {
            return this.outputDir.get() + File.separator + "result.mhd";
        }
        if (this.transformType == 1) {
            return null;
        }
        return null;
    }

    public boolean checkParametersForTransformation() {
        if (this.transformType == -1) {
            System.err.println("Transformation input parameters not set (image or text points).");
            return false;
        }
        if (this.outputDir == null) {
            this.setDefaultOutputDir();
            if (this.outputDir == null) {
                System.err.println("Could not create output directory");
                return false;
            }
        }
        return true;
    }

    public void setDefaultOutputDir() {
        TempDirectory tempDir = new TempDirectory("tr-out");
        tempDir.deleteOnExit();
        Path path = tempDir.getPath();
        this.outputDir = path::toString;
    }

    public String imageToTransformPathSupplier() {
        return ((File)this.imageToTransform.to(File.class)).getAbsolutePath();
    }

    public String roisToTransformPathSupplier() {
        TransformixInputRoisFile erf = (TransformixInputRoisFile)this.roisToTransform.to(TransformixInputRoisFile.class);
        return erf.f.getAbsolutePath();
    }

    public void setExtraRegisterInfo(String transformInfo) {
        this.transformInfo = transformInfo;
    }

    public void transform(TransformixTask task) {
        TransformixTaskSettings transformSettings = new TransformixTaskSettings().transform(this.transformFile).outFolder(this.outputDir);
        if (!this.transformTaskSet) {
            if (this.checkParametersForTransformation()) {
                transformSettings = new TransformixTaskSettings().transform(this.transformFile).outFolder(this.outputDir);
                if (this.verbose) {
                    transformSettings.verbose();
                }
                if (this.transformInfo != null) {
                    transformSettings.taskInfo = this.transformInfo;
                }
                if (this.transformType == 0) {
                    transformSettings.image(this::imageToTransformPathSupplier);
                }
                if (this.transformType == 1) {
                    transformSettings.pts(this::roisToTransformPathSupplier);
                }
                this.transformTaskSet = true;
            } else {
                task = null;
                this.transformTaskSet = false;
            }
        }
        if (this.transformTaskSet) {
            try {
                task.run(transformSettings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.transformType == 0) {
                this.imageTransformed.clear();
                this.imageTransformed.set(new File(this.outputDir.get() + File.separator + "result.tif"));
            }
            if (this.transformType == 1) {
                TransformixOutputRoisFile erf = new TransformixOutputRoisFile(new File(this.outputDir.get() + File.separator + "outputpoints.txt"), (TransformixInputRoisFile)this.roisToTransform.to(TransformixInputRoisFile.class));
                this.roisTransformed.clear();
                this.roisTransformed.set(erf);
            }
        }
    }

    public ConvertibleImage getTransformedImage() {
        return this.imageTransformed;
    }

    public ConvertibleRois getTransformedRois() {
        return this.roisTransformed;
    }
}

