/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.stardist.ij2commands;

import ch.epfl.biop.wrappers.stardist.DefaultStardistTask;
import ch.epfl.biop.wrappers.stardist.StardistTaskSettings;
import java.io.File;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>StarDist> StarDist3D... (from file - Advanced)")
public class StarDist3D_SegmentImgPath_Advanced
implements Command {
    @Parameter
    File image_path;
    @Parameter(style="directory")
    File model_path;
    @Parameter(style="directory")
    File output_path;
    @Parameter
    int x_tiles = -1;
    @Parameter
    int y_tiles = -1;
    @Parameter
    int z_tiles = -1;
    @Parameter(style="format:#.00")
    float min_norm = 3.0f;
    @Parameter(style="format:#.00")
    float max_norm = 99.8f;
    @Parameter(style="format:#.00")
    float prob_thresh = -1.0f;
    @Parameter(style="format:#.00")
    float nms_thresh = -1.0f;

    public void run() {
        StardistTaskSettings settings = new StardistTaskSettings();
        DefaultStardistTask stardistTask = new DefaultStardistTask();
        settings.setImagePath(this.image_path.toString());
        settings.setModelPath(this.model_path.toString());
        settings.setOutputPath(this.output_path.toString());
        if (this.x_tiles > -1) {
            settings.setXTiles(this.x_tiles);
        }
        if (this.y_tiles > -1) {
            settings.setYTiles(this.y_tiles);
        }
        if (this.z_tiles > -1) {
            settings.setZTiles(this.z_tiles);
        }
        settings.setPmin(this.min_norm);
        settings.setPmax(this.max_norm);
        if (this.prob_thresh > -1.0f) {
            settings.setProbThresh(this.prob_thresh);
        }
        if (this.nms_thresh > -1.0f) {
            settings.setNmsThresh(this.nms_thresh);
        }
        stardistTask.setSettings(settings);
        try {
            stardistTask.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

