/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.stardist.ij2commands;

import ch.epfl.biop.wrappers.stardist.DefaultStardistTask;
import ch.epfl.biop.wrappers.stardist.StardistTaskSettings;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.plugin.Concatenator;
import ij.plugin.Duplicator;
import java.io.File;
import java.util.ArrayList;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>StarDist>StarDist2D... (Advanced) ")
public class StarDist2D_SegmentImgPlus_Advanced
implements Command {
    @Parameter
    ImagePlus imp;
    @Parameter(style="directory")
    File model_path;
    @Parameter
    int x_tiles = -1;
    @Parameter
    int y_tiles = -1;
    @Parameter(style="format:#.00")
    float min_norm = 3.0f;
    @Parameter(style="format:#.00")
    float max_norm = 99.8f;
    @Parameter(style="format:#.00")
    float prob_thresh = -1.0f;
    @Parameter(style="format:#.00")
    float nms_thresh = -1.0f;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus stardist_imp;
    Boolean verbose = true;

    public void run() {
        Calibration cal = this.imp.getCalibration();
        StardistTaskSettings settings = new StardistTaskSettings();
        DefaultStardistTask stardistTask = new DefaultStardistTask();
        String tempDir = IJ.getDirectory((String)"Temp");
        File stardistTempDir = new File(tempDir, "StarDistTemp");
        stardistTempDir.mkdir();
        settings.setMode2D();
        settings.setModelPath(this.model_path.toString());
        settings.setOutputPath(stardistTempDir.toString());
        if (this.x_tiles > -1) {
            settings.setXTiles(this.x_tiles);
        }
        if (this.y_tiles > -1) {
            settings.setYTiles(this.y_tiles);
        }
        settings.setPmin(this.min_norm);
        settings.setPmax(this.max_norm);
        if (this.prob_thresh > -1.0f) {
            settings.setProbThresh(this.prob_thresh);
        }
        if (this.nms_thresh > -1.0f) {
            settings.setNmsThresh(this.nms_thresh);
        }
        int impFrames = this.imp.getNFrames();
        ArrayList<File> t_imp_paths = new ArrayList<File>();
        ArrayList<File> stardist_masks_paths = new ArrayList<File>();
        for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
            ImagePlus t_imp = new Duplicator().run(this.imp, 1, this.imp.getNChannels(), 1, this.imp.getNSlices(), t_idx, t_idx);
            File t_imp_path = new File(stardistTempDir, this.imp.getShortTitle() + "-t" + t_idx + ".tif");
            FileSaver fs = new FileSaver(t_imp);
            fs.saveAsTiff(t_imp_path.toString());
            if (this.verbose.booleanValue()) {
                System.out.println(t_imp_path);
            }
            t_imp_paths.add(t_imp_path);
            File stardist_imp_path = new File(stardistTempDir, this.imp.getShortTitle() + "-t" + t_idx + ".stardist.tif");
            stardist_masks_paths.add(stardist_imp_path);
            settings.setImagePath(t_imp_path.toString());
            stardistTask.setSettings(settings);
            try {
                stardistTask.run();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<ImagePlus> imps = new ArrayList<ImagePlus>(impFrames);
        for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
            ImagePlus stardist_t_imp = IJ.openImage((String)((File)stardist_masks_paths.get(t_idx - 1)).toString());
            imps.add(stardist_t_imp.duplicate());
        }
        ImagePlus[] impsArray = imps.toArray(new ImagePlus[0]);
        this.stardist_imp = Concatenator.run((ImagePlus[])impsArray);
        this.stardist_imp.setCalibration(cal);
        this.stardist_imp.setTitle(this.imp.getShortTitle() + "-stardist2D");
        for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
            ((File)t_imp_paths.get(t_idx - 1)).delete();
            ((File)stardist_masks_paths.get(t_idx - 1)).delete();
        }
        stardistTempDir.delete();
    }
}

