/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.stardist;

import ch.epfl.biop.wrappers.Conda;
import ij.IJ;
import ij.Prefs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Stardist {
    public static final String keyPrefix = Stardist.class.getName() + ".";
    static final String defaultStardistEnvDirPath = "C:/Users/username/.conda/envs/stardist";
    static final String defaultStardistEnvType = "conda";
    public static String stardistEnvDirectory = Prefs.get((String)(keyPrefix + "Stardist_envDirPath"), (String)"C:/Users/username/.conda/envs/stardist");
    public static String stardistEnvType = Prefs.get((String)(keyPrefix + "Stardist_envType"), (String)"conda");
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    public static void setStardistEnvDirPath(File f) {
        stardistEnvDirectory = f.getAbsolutePath();
        Prefs.set((String)(keyPrefix + "Stardist_envDirPath"), (String)stardistEnvDirectory);
    }

    public static void setStardistEnvType(String stardistEnvType) {
        Prefs.set((String)(keyPrefix + "Stardist_envType"), (String)stardistEnvType);
    }

    static void execute(List<String> options, Consumer<InputStream> outputHandler) throws IOException, InterruptedException {
        List<String> start_cmd = null;
        String stardistEnvDirectory = Prefs.get((String)(keyPrefix + "Stardist_envDirPath"), (String)Stardist.stardistEnvDirectory);
        String stardistEnvType = Prefs.get((String)(keyPrefix + "Stardist_envType"), (String)Stardist.stardistEnvType);
        if (IJ.isWindows()) {
            start_cmd = Arrays.asList("cmd.exe", "/C");
        } else if (IJ.isMacOSX() || IJ.isLinux()) {
            start_cmd = Arrays.asList("bash", "-c");
        } else {
            throw new RuntimeException("Unknown Operating System");
        }
        ArrayList<String> cmd = new ArrayList<String>(start_cmd);
        if (stardistEnvType.equals(defaultStardistEnvType)) {
            String stardist_cmd = options.get(0);
            options.remove(0);
            if (IJ.isWindows()) {
                List<String> conda_activate_cmd = Arrays.asList("CALL", Conda.getWindowsCondaCommand(), "activate", stardistEnvDirectory);
                cmd.addAll(conda_activate_cmd);
                cmd.add("&");
                List<String> args_cmd = Collections.singletonList(stardist_cmd);
                cmd.addAll(args_cmd);
                cmd.addAll(options);
            } else if (IJ.isMacOSX() || IJ.isLinux()) {
                String python_path = stardistEnvDirectory + File.separatorChar + "bin" + File.separatorChar + stardist_cmd;
                List<String> cellpose_args_cmd = new ArrayList<String>(Collections.singletonList(python_path));
                cellpose_args_cmd.addAll(options);
                cellpose_args_cmd = cellpose_args_cmd.stream().map(s -> {
                    if (s.trim().contains(" ")) {
                        return "\"" + s.trim() + "\"";
                    }
                    return s;
                }).collect(Collectors.toList());
                String cmdString = cellpose_args_cmd.toString().replace(",", "");
                cmd.add(cmdString.substring(1, cmdString.length() - 1));
            }
        } else if (stardistEnvType.equals("venv")) {
            if (IJ.isWindows()) {
                List<String> venv_activate_cmd = Arrays.asList("cmd.exe", "/C", new File(stardistEnvDirectory, "Scripts/activate").toString());
                cmd.addAll(venv_activate_cmd);
            } else if (IJ.isMacOSX() || IJ.isLinux()) {
                throw new UnsupportedOperationException("Mac/Unix not supported yet with virtual environment. Please try conda instead.");
            }
        } else {
            throw new UnsupportedOperationException("Virtual env type unrecognized!");
        }
        System.out.println(((Object)cmd).toString().replace(",", ""));
        ProcessBuilder pb = new ProcessBuilder(cmd).redirectErrorStream(true);
        final Process p = pb.start();
        Thread t = new Thread(Thread.currentThread().getName() + "-" + p.hashCode()){

            @Override
            public void run() {
                BufferedReader stdIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line = stdIn.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = stdIn.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        t.setDaemon(true);
        t.start();
        p.waitFor();
        int exitValue = p.exitValue();
        if (exitValue != 0) {
            System.out.println("Runner " + stardistEnvDirectory + " exited with value " + exitValue + ". Please check output above for indications of the problem.");
        } else {
            System.out.println(stardistEnvType + " , " + stardistEnvDirectory + " run finished");
        }
    }

    public static void execute(String singleCommand) throws IOException, InterruptedException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(singleCommand);
        Stardist.execute(cmdList, null);
    }
}

