/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.stardist;

import ch.epfl.biop.wrappers.stardist.Stardist;
import ch.epfl.biop.wrappers.stardist.StardistTask;
import java.util.ArrayList;

public class DefaultStardistTask
extends StardistTask {
    @Override
    public void run() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        if (this.settings.dimension.equals("2D")) {
            options.add("stardist-predict2d");
        } else {
            options.add("stardist-predict3d");
        }
        options.add("-i");
        options.add(this.settings.image_path);
        options.add("-m");
        options.add(this.settings.model_path);
        options.add("-o");
        options.add(this.settings.output_path);
        if (this.settings.dimension.equals("3D")) {
            if (this.settings.x_tiles > -1 && this.settings.y_tiles > -1 && this.settings.z_tiles > -1) {
                options.add("--n_tiles");
                options.add("" + this.settings.z_tiles);
                options.add("" + this.settings.y_tiles);
                options.add("" + this.settings.x_tiles);
            } else {
                System.out.println("Please specify all dimensions");
            }
        } else if (this.settings.dimension.equals("2D") && this.settings.x_tiles > -1 && this.settings.y_tiles > -1) {
            options.add("--n_tiles");
            options.add("" + this.settings.y_tiles);
            options.add("" + this.settings.x_tiles);
        }
        if (this.settings.pmin != 3.0f || this.settings.pmax != 99.8f) {
            options.add("--pnorm");
            options.add("" + this.settings.pmin);
            options.add("" + this.settings.pmax);
        }
        if (this.settings.prob_thresh > -1.0f) {
            options.add("--prob_thresh");
            options.add("" + this.settings.prob_thresh);
        }
        if (this.settings.nms_thresh > -1.0f) {
            options.add("--nms_thresh");
            options.add("" + this.settings.nms_thresh);
        }
        Stardist.execute(options, null);
    }
}

