/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.omnipose.ij2commands;

import ch.epfl.biop.wrappers.omnipose.DefaultOmniposeTask;
import ch.epfl.biop.wrappers.omnipose.OmniposeTaskSettings;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.plugin.Concatenator;
import ij.plugin.Duplicator;
import ij.plugin.frame.Recorder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import net.imagej.ImageJ;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Cellpose/Omnipose>Omnipose ...")
public class Omnipose
implements Command {
    static String default_conda_env_path;
    @Parameter
    LogService ls;
    @Parameter
    ImagePlus imp;
    @Parameter(label="conda environment path", style="directory")
    File env_path = new File(default_conda_env_path);
    @Parameter(label="virtual environment type", choices={"conda", "venv"})
    String env_type = "conda";
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message = "You can use the pretrained model, specify the model name below";
    @Parameter(required=false, label="--pretrained_model")
    String model = "cyto2_omni";
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message0 = "You can access the list of models by clicking on the button below.";
    @Parameter(label="List of omnipose models", callback="openModelsPage")
    private Button open_models_page_button;
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message1 = "OR To use your own model, specify the path below AND leave --pretrained_model empty";
    @Parameter(required=false, label="model_path")
    File model_path = new File("path/to/own_omnipose_model");
    @Parameter(label="--diameter")
    int diameter = 30;
    @Parameter(label="--chan")
    int ch1 = 0;
    @Parameter(label="--chan2")
    int ch2 = -1;
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message2 = "You can add more flags to the command line by adding them here. For example: --omni, --cluster";
    @Parameter(required=false, label="To add more parameters (use comma separated list of flags)")
    String additional_flags = "--omni, --cluster";
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message3 = "You can access the full list of parameters by clicking on the button below.";
    @Parameter(label="List of all parameters", callback="openCliPage")
    private Button cli_page_button;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus omnipose_imp;
    @Parameter
    PlatformService ps;
    Boolean verbose = true;

    private void openModelsPage() {
        try {
            this.ps.open(new URL("https://omnipose.readthedocs.io/models.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void openCliPage() {
        try {
            this.ps.open(new URL("https://omnipose.readthedocs.io/cli.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        if (this.env_path == null || !this.env_path.exists()) {
            this.ls.error((Object)("Error: the omnipose environment path does not exist: " + this.env_path));
            return;
        }
        OmniposeTaskSettings settings = new OmniposeTaskSettings();
        DefaultOmniposeTask omniposeTask = new DefaultOmniposeTask();
        Calibration cal = this.imp.getCalibration();
        String tempDir = IJ.getDirectory((String)"Temp");
        File omniposeTempDir = new File(tempDir, "omniposeTemp");
        omniposeTempDir.mkdir();
        File[] contents = omniposeTempDir.listFiles();
        if (contents != null) {
            for (File f : contents) {
                f.delete();
            }
        }
        settings.setEnvPath(this.env_path.toString());
        settings.setEnvType(this.env_type);
        settings.setDatasetDir(omniposeTempDir.toString());
        String model_used = this.model;
        if (this.model == null || this.model.trim().isEmpty()) {
            this.ls.info((Object)("Using omnipose custom model: " + this.model_path));
            model_used = this.model_path.toString();
        }
        settings.setModel(model_used);
        settings.setDiameter(this.diameter);
        settings.setChannel1(this.ch1);
        if (this.ch2 > -1) {
            settings.setChannel2(this.ch2);
        }
        settings.setAdditionalFlags(this.additional_flags);
        omniposeTask.setSettings(settings);
        try {
            int impFrames = this.imp.getNFrames();
            ArrayList<File> t_imp_paths = new ArrayList<File>();
            ArrayList<File> omnipose_masks_paths = new ArrayList<File>();
            ArrayList<File> omnipose_outlines_paths = new ArrayList<File>();
            for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
                boolean tmpRecord = Recorder.record;
                Recorder.record = false;
                ImagePlus t_imp = new Duplicator().run(this.imp, 1, this.imp.getNChannels(), 1, this.imp.getNSlices(), t_idx, t_idx);
                Recorder.record = tmpRecord;
                File t_imp_path = new File(omniposeTempDir, this.imp.getShortTitle() + "-t" + t_idx + ".tif");
                FileSaver fs = new FileSaver(t_imp);
                fs.saveAsTiff(t_imp_path.toString());
                if (this.verbose.booleanValue()) {
                    System.out.println(t_imp_path);
                }
                t_imp_paths.add(t_imp_path);
                File omnipose_imp_path = new File(omniposeTempDir, this.imp.getShortTitle() + "-t" + t_idx + "_cp_masks.tif");
                omnipose_masks_paths.add(omnipose_imp_path);
                File omnipose_outlines_path = new File(omniposeTempDir, this.imp.getShortTitle() + "-t" + t_idx + "_cp_outlines.txt");
                omnipose_outlines_paths.add(omnipose_outlines_path);
            }
            omniposeTask.run();
            ArrayList<ImagePlus> imps = new ArrayList<ImagePlus>(impFrames);
            for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
                ImagePlus omnipose_t_imp = IJ.openImage((String)((File)omnipose_masks_paths.get(t_idx - 1)).toString());
                if (omnipose_t_imp.getBitDepth() != 32) {
                    if (omnipose_t_imp.getNSlices() > 1) {
                        omnipose_t_imp.getStack().setBitDepth(32);
                    } else {
                        omnipose_t_imp.setProcessor(omnipose_t_imp.getProcessor().convertToFloat());
                    }
                }
                imps.add(omnipose_t_imp.duplicate());
            }
            ImagePlus[] impsArray = imps.toArray(new ImagePlus[0]);
            boolean tmpScriptMode = Recorder.scriptMode();
            Field scriptModeField = Recorder.class.getDeclaredField("scriptMode");
            scriptModeField.setAccessible(true);
            scriptModeField.set(null, false);
            this.omnipose_imp = Concatenator.run((ImagePlus[])impsArray);
            scriptModeField.set(null, tmpScriptMode);
            this.omnipose_imp.setCalibration(cal);
            this.omnipose_imp.setTitle(this.imp.getShortTitle() + "-omnipose");
            boolean tmpRecord = Recorder.record;
            Recorder.record = false;
            IJ.run((ImagePlus)this.omnipose_imp, (String)"3-3-2 RGB", (String)"");
            Recorder.record = tmpRecord;
            for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
                ((File)t_imp_paths.get(t_idx - 1)).delete();
                ((File)omnipose_masks_paths.get(t_idx - 1)).delete();
                ((File)omnipose_outlines_paths.get(t_idx - 1)).delete();
            }
            omniposeTempDir.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String ... args) {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        ij.command().run(Omnipose.class, true, new Object[0]);
    }

    static {
        if (IJ.isLinux()) {
            default_conda_env_path = "/opt/conda/envs/omnipose";
        } else if (IJ.isWindows()) {
            default_conda_env_path = "C:/Users/username/.conda/envs/omnipose";
        } else if (IJ.isMacOSX()) {
            default_conda_env_path = "/Users/username/.conda/envs/omnipose";
        }
    }
}

