/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.elastix.ij2commands;

import ch.epfl.biop.wrappers.elastix.DefaultElastixTask;
import ch.epfl.biop.wrappers.elastix.RHZipFile;
import ch.epfl.biop.wrappers.elastix.RegParamAffine_Default;
import ch.epfl.biop.wrappers.elastix.RegParamAffine_Fast;
import ch.epfl.biop.wrappers.elastix.RegParamBSpline_Default;
import ch.epfl.biop.wrappers.elastix.RegParamRigid_Default;
import ch.epfl.biop.wrappers.elastix.RegisterHelper;
import ch.epfl.biop.wrappers.elastix.RegistrationParameters;
import ij.ImagePlus;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Elastix>Register")
public class Elastix_Register
implements Command {
    @Parameter
    public ImagePlus moving_image;
    @Parameter
    public ImagePlus fixed_image;
    @Parameter
    public boolean rigid;
    @Parameter
    public boolean fast_affine;
    @Parameter
    public boolean affine;
    @Parameter
    public boolean spline;
    @Parameter
    public int spline_grid_spacing;
    @Parameter(type=ItemIO.OUTPUT)
    public RegisterHelper rh;

    public void run() {
        int iCh;
        RegistrationParameters[] rps;
        int nChannels = 1;
        if (this.moving_image.getNChannels() > 1 || this.fixed_image.getNChannels() > 1) {
            if (this.fixed_image.getNChannels() == this.moving_image.getNChannels()) {
                nChannels = this.fixed_image.getNChannels();
            } else {
                System.out.println("Can't perform multichannel registration because the number of channel is not identical between moving and fixed image");
            }
        }
        this.rh = new RegisterHelper();
        this.rh.setMovingImage(this.moving_image);
        this.rh.setFixedImage(this.fixed_image);
        if (this.rigid) {
            rps = new RegistrationParameters[nChannels];
            for (iCh = 0; iCh < nChannels; ++iCh) {
                rps[iCh] = new RegParamRigid_Default();
            }
            this.rh.addTransform(RegistrationParameters.combineRegistrationParameters(rps));
        }
        if (this.fast_affine) {
            rps = new RegistrationParameters[nChannels];
            for (iCh = 0; iCh < nChannels; ++iCh) {
                rps[iCh] = new RegParamAffine_Fast();
            }
            this.rh.addTransform(RegistrationParameters.combineRegistrationParameters(rps));
        }
        if (this.affine) {
            rps = new RegistrationParameters[nChannels];
            for (iCh = 0; iCh < nChannels; ++iCh) {
                rps[iCh] = new RegParamAffine_Default();
            }
            this.rh.addTransform(RegistrationParameters.combineRegistrationParameters(rps));
        }
        if (this.spline) {
            rps = new RegistrationParameters[nChannels];
            for (iCh = 0; iCh < nChannels; ++iCh) {
                rps[iCh] = new RegParamBSpline_Default();
            }
            RegistrationParameters rp = RegistrationParameters.combineRegistrationParameters(rps);
            rp.FinalGridSpacingInVoxels = this.spline_grid_spacing;
            this.rh.addTransform(rp);
        }
        try {
            this.rh.align(new DefaultElastixTask());
            this.rh.to(RHZipFile.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

