/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.elastix.ij2commands;

import ch.epfl.biop.wrappers.elastix.DefaultElastixTask;
import ch.epfl.biop.wrappers.elastix.RHZipFile;
import ch.epfl.biop.wrappers.elastix.RegParamAffine_Default;
import ch.epfl.biop.wrappers.elastix.RegParamAffine_Fast;
import ch.epfl.biop.wrappers.elastix.RegParamBSpline_Default;
import ch.epfl.biop.wrappers.elastix.RegParamRigid_Default;
import ch.epfl.biop.wrappers.elastix.RegisterHelper;
import ch.epfl.biop.wrappers.elastix.RegistrationParameters;
import ij.ImagePlus;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Elastix>Inverse registration")
public class Elastix_InverseTransform
implements Command {
    @Parameter
    public ImagePlus image;
    @Parameter(type=ItemIO.INPUT)
    public RegisterHelper rh_toinvert;
    @Parameter(type=ItemIO.OUTPUT)
    public RegisterHelper rh_inverted;
    @Parameter
    public boolean rigid;
    @Parameter
    public boolean fast_affine;
    @Parameter
    public boolean affine;
    @Parameter
    public boolean spline;

    public void run() {
        RegistrationParameters rp;
        RegisterHelper rh = new RegisterHelper();
        rh.setMovingImage(this.image);
        rh.setFixedImage(this.image);
        if (this.rigid) {
            rp = new RegParamRigid_Default();
        } else if (this.fast_affine) {
            rp = new RegParamAffine_Fast();
        } else if (this.affine) {
            rp = new RegParamAffine_Default();
        } else if (this.spline) {
            rp = new RegParamBSpline_Default();
        } else {
            System.err.println("You need to select q transformation model.");
            return;
        }
        rp.Metric = "DisplacementMagnitudePenalty";
        rh.addInitialTransformFromFilePath(this.rh_toinvert.getTransformFile(this.rh_toinvert.getNumberOfTransform() - 1));
        rh.addTransform(rp);
        try {
            rh.align(new DefaultElastixTask());
            rh.to(RHZipFile.class);
            this.rh_inverted = rh;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

