/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.elastix;

import ch.epfl.biop.java.utilities.Converter;
import ch.epfl.biop.java.utilities.ConvertibleObject;
import ch.epfl.biop.wrappers.elastix.RegParamAffine_Default;
import ch.epfl.biop.wrappers.elastix.RegParamAffine_Fast;
import ch.epfl.biop.wrappers.elastix.RegParamBSpline_Default;
import ch.epfl.biop.wrappers.elastix.RegParamRigid_Default;
import ch.epfl.biop.wrappers.elastix.RegParamTranslation_Default;
import ch.epfl.biop.wrappers.elastix.RegisterParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;

public class RegistrationParameters
extends ConvertibleObject {
    @RegisterParam
    public String FixedInternalImagePixelType;
    @RegisterParam
    public String MovingInternalImagePixelType;
    @RegisterParam
    public Integer FixedImageDimension;
    @RegisterParam
    public Integer MovingImageDimension;
    @RegisterParam
    public Boolean UseDirectionCosines;
    @RegisterParam
    public String Registration;
    @RegisterParam
    public String Interpolator;
    @RegisterParam
    public String ResampleInterpolator;
    @RegisterParam
    public String Resampler;
    @RegisterParam
    public String FixedImagePyramid;
    @RegisterParam
    public String MovingImagePyramid;
    @RegisterParam
    public String Optimizer;
    @RegisterParam
    public String Transform;
    @RegisterParam
    public String Metric;
    @RegisterParam
    public Boolean AutomaticScalesEstimation;
    @RegisterParam
    public Boolean AutomaticTransformInitialization = true;
    @RegisterParam
    public String AutomaticTransformInitializationMethod = "CenterOfGravity";
    @RegisterParam
    public String HowToCombineTransforms;
    @RegisterParam
    public Integer[] NumberOfHistogramBins;
    @RegisterParam
    public Boolean ErodeMask;
    @RegisterParam
    public Integer NumberOfResolutions;
    @RegisterParam
    public Integer[] ImagePyramidSchedule;
    @RegisterParam
    public Integer MaximumNumberOfIterations;
    @RegisterParam
    public Float MaximumStepLength;
    @RegisterParam
    public Integer NumberOfSpatialSamples;
    @RegisterParam
    public Boolean NewSamplesEveryIteration;
    @RegisterParam
    public String ImageSampler;
    @RegisterParam
    public Integer BSplineInterpolationOrder;
    @RegisterParam
    public Integer FinalBSplineInterpolationOrder;
    @RegisterParam
    public Float DefaultPixelValue;
    @RegisterParam
    public Boolean WriteResultImage;
    @RegisterParam
    public String ResultImagePixelType = "float";
    @RegisterParam
    public String ResultImageFormat = "tif";
    @RegisterParam
    public boolean CompressResultImage = false;
    @RegisterParam
    public Integer FinalGridSpacingInPhysicalUnits;
    @RegisterParam
    public Integer FinalGridSpacingInVoxels;
    @RegisterParam
    public Integer[] GridSpacingSchedule;
    @RegisterParam
    public Float Alpha;
    @RegisterParam
    public Float AvoidDivisionBy;
    @RegisterParam
    public String TreeType;
    @RegisterParam
    public Integer BucketSize;
    @RegisterParam
    public String SplittingRule;
    @RegisterParam
    public String ShrinkingRule;
    @RegisterParam
    public String TreeSearchType;
    @RegisterParam
    public Integer KNearestNeighbours;
    @RegisterParam
    public Float ErrorBound;
    @RegisterParam
    Float Metric0Weight;
    @RegisterParam
    Float Metric1Weight;
    @RegisterParam
    Float Metric2Weight;
    @RegisterParam
    Float Metric3Weight;
    @RegisterParam
    Float Metric4Weight;
    @RegisterParam
    Float Metric5Weight;
    @RegisterParam
    Float Metric6Weight;

    public static boolean easyToWrite(Class<?> c) {
        boolean easy = false;
        easy |= c.equals(Integer.TYPE);
        easy |= c.equals(Integer.class);
        easy |= c.equals(Float.TYPE);
        easy |= c.equals(Float.class);
        easy |= c.equals(Double.TYPE);
        easy |= c.equals(Double.class);
        easy |= c.equals(Boolean.TYPE);
        easy |= c.equals(Boolean.class);
        return easy |= c.equals(String.class);
    }

    @Converter
    public static String toString(RegistrationParameters rp) {
        String output = "";
        try {
            for (Field f : RegistrationParameters.class.getFields()) {
                Object[] arrayParam;
                if (!f.isAnnotationPresent(RegisterParam.class) || f.get(rp) == null) continue;
                output = output + "(" + f.getName() + " ";
                if (RegistrationParameters.easyToWrite(f.getType())) {
                    output = output + f.get(rp);
                }
                if (f.getType() == float[].class) {
                    for (float v : arrayParam = (float[])f.get(rp)) {
                        output = output + v + " ";
                    }
                }
                if (f.getType() == int[].class) {
                    for (float j : arrayParam = (Object[])((int[])f.get(rp))) {
                        output = output + (int)j + " ";
                    }
                }
                if (f.getType() == Float[].class) {
                    for (float aFloat : arrayParam = (Object[])((Float[])f.get(rp))) {
                        output = output + aFloat + " ";
                    }
                }
                if (f.getType() == Integer[].class) {
                    for (float integer : arrayParam = (Object[])((Integer[])f.get(rp))) {
                        output = output + integer + " ";
                    }
                }
                output = output + ")\n";
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public File toFile(RegistrationParameters rp) {
        BufferedWriter writer = null;
        try {
            File temp = File.createTempFile("rpa", ".txt");
            temp.deleteOnExit();
            writer = new BufferedWriter(new FileWriter(temp));
            writer.write(RegistrationParameters.toString(rp));
            writer.close();
            File file = temp;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Converter
    public static RegistrationParameters downCast(RegParamRigid_Default rp) {
        return rp;
    }

    @Converter
    public static RegistrationParameters downCast(RegParamAffine_Default rp) {
        return rp;
    }

    @Converter
    public static RegistrationParameters downCast(RegParamTranslation_Default rp) {
        return rp;
    }

    @Converter
    public static RegistrationParameters downCast(RegParamBSpline_Default rp) {
        return rp;
    }

    @Converter
    public static RegistrationParameters downCast(RegParamAffine_Fast rp) {
        return rp;
    }

    public static RegistrationParameters useAlphaMutualInformation(RegistrationParameters rp, int nChannels) {
        rp.Registration = "MultiResolutionRegistrationWithFeatures";
        String fip = rp.FixedImagePyramid;
        for (int iCh = 0; iCh < nChannels - 1; ++iCh) {
            rp.FixedImagePyramid = rp.FixedImagePyramid + " " + fip;
        }
        String mip = rp.MovingImagePyramid;
        for (int iCh = 0; iCh < nChannels - 1; ++iCh) {
            rp.MovingImagePyramid = rp.MovingImagePyramid + " " + mip;
        }
        String interp = rp.Interpolator;
        for (int iCh = 0; iCh < nChannels - 1; ++iCh) {
            rp.Interpolator = rp.Interpolator + " " + interp;
        }
        rp.Metric = "KNNGraphAlphaMutualInformation";
        rp.ImageSampler = "MultiInputRandomCoordinate";
        rp.Alpha = Float.valueOf(0.99f);
        rp.AvoidDivisionBy = Float.valueOf(1.0E-10f);
        rp.TreeType = "KDTree";
        rp.BucketSize = 50;
        rp.SplittingRule = "ANN_KD_STD";
        rp.ShrinkingRule = "ANN_BD_SIMPLE";
        rp.TreeSearchType = "Standard";
        rp.KNearestNeighbours = 20;
        rp.ErrorBound = Float.valueOf(10.0f);
        return rp;
    }

    public static RegistrationParameters combineRegistrationParameters(RegistrationParameters ... rps) {
        int nChannels = rps.length;
        RegistrationParameters model = rps[0];
        model.Registration = "MultiMetricMultiResolutionRegistration";
        block9: for (int iCh = 1; iCh < nChannels; ++iCh) {
            model.FixedImagePyramid = model.FixedImagePyramid + " " + rps[iCh].FixedImagePyramid;
            model.MovingImagePyramid = model.MovingImagePyramid + " " + rps[iCh].MovingImagePyramid;
            model.Interpolator = model.Interpolator + " " + rps[iCh].Interpolator;
            model.Metric = model.Metric + " " + rps[iCh].Metric;
            model.ImageSampler = model.ImageSampler + " " + rps[iCh].ImageSampler;
            switch (iCh) {
                case 0: {
                    model.Metric0Weight = Float.valueOf(1.0f);
                    continue block9;
                }
                case 1: {
                    model.Metric1Weight = Float.valueOf(1.0f);
                    continue block9;
                }
                case 2: {
                    model.Metric2Weight = Float.valueOf(1.0f);
                    continue block9;
                }
                case 3: {
                    model.Metric3Weight = Float.valueOf(1.0f);
                    continue block9;
                }
                case 4: {
                    model.Metric4Weight = Float.valueOf(1.0f);
                    continue block9;
                }
                case 5: {
                    model.Metric5Weight = Float.valueOf(1.0f);
                    continue block9;
                }
                case 6: {
                    model.Metric6Weight = Float.valueOf(1.0f);
                }
            }
        }
        return model;
    }
}

