/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.elastix;

import ch.epfl.biop.java.utilities.Converter;
import ch.epfl.biop.java.utilities.ConvertibleObject;
import ch.epfl.biop.java.utilities.TempDirectory;
import ch.epfl.biop.java.utilities.image.ConvertibleImage;
import ch.epfl.biop.java.utilities.image.ElastixMultiFile;
import ch.epfl.biop.wrappers.elastix.ElastixTask;
import ch.epfl.biop.wrappers.elastix.ElastixTaskSettings;
import ch.epfl.biop.wrappers.elastix.RHZipFile;
import ch.epfl.biop.wrappers.elastix.RegistrationParameters;
import ij.ImagePlus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RegisterHelper
extends ConvertibleObject {
    ConvertibleImage fixedImage;
    ConvertibleImage movingImage;
    final ArrayList<Supplier<String>> transformFilesSupplier = new ArrayList();
    public Supplier<String> outputDir;
    public String initialTransformFilePath = null;
    boolean alignTaskSet = false;
    boolean verbose = false;
    String registerInfo = null;

    public RegisterHelper() {
        this.fixedImage = new ConvertibleImage();
        this.movingImage = new ConvertibleImage();
    }

    public void setMovingImage(String pathToMovingImage) {
        this.movingImage.set(new File(pathToMovingImage));
        this.alignTaskSet = false;
    }

    public void addInitialTransformFromFilePath(String filePath) {
        this.initialTransformFilePath = filePath;
    }

    public void setMovingImage(ConvertibleImage img) {
        this.movingImage = img;
    }

    public void setFixedImage(ConvertibleImage img) {
        this.fixedImage = img;
    }

    public void setMovingImage(URL url) {
        this.movingImage.set(url);
        this.alignTaskSet = false;
    }

    public void verbose() {
        this.verbose = true;
    }

    public void setMovingImage(ImagePlus imp) {
        this.movingImage.set(imp);
        this.alignTaskSet = false;
    }

    public void setFixedImage(String pathToFixedImage) {
        this.fixedImage.set(new File(pathToFixedImage));
        this.alignTaskSet = false;
    }

    public void setOutputDirectory(Supplier<String> outputDir) {
        this.outputDir = outputDir;
    }

    public static String getFileFromRegistrationParameters(RegistrationParameters rp) {
        return ((File)rp.to(File.class)).getAbsolutePath();
    }

    public void addTransform(RegistrationParameters rp) {
        this.transformFilesSupplier.add(() -> RegisterHelper.getFileFromRegistrationParameters(rp));
    }

    public void addTransformFromFilePath(String pathToFile) {
        this.transformFilesSupplier.add(() -> pathToFile);
        this.alignTaskSet = false;
    }

    public void setFixedImage(ImagePlus imp) {
        this.fixedImage.set(imp);
        this.alignTaskSet = false;
    }

    public void setDefaultOutputDir() {
        TempDirectory tempDir = new TempDirectory("reg-out");
        tempDir.deleteOnExit();
        Path path = tempDir.getPath();
        this.outputDir = path::toString;
    }

    public boolean checkParametersForAlignement() {
        if (this.fixedImage.to(ElastixMultiFile.class) == null) {
            System.err.println("Fixed image not set");
            return false;
        }
        if (this.movingImage.to(ElastixMultiFile.class) == null) {
            System.err.println("Moving image not set");
            System.out.println("null ?" + (this.movingImage == null));
            System.out.println("null img ?" + (this.movingImage.to(ImagePlus.class) == null));
            System.out.println("null file ?" + (this.movingImage.to(ElastixMultiFile.class) == null));
            return false;
        }
        if (this.transformFilesSupplier.isEmpty()) {
            System.err.println("No transformation specified");
            return false;
        }
        if (this.outputDir == null) {
            this.setDefaultOutputDir();
            if (this.outputDir == null) {
                System.err.println("Could not create output directory");
                return false;
            }
        }
        return true;
    }

    public void setExtraRegisterInfo(String registerInfo) {
        this.registerInfo = registerInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void align(ElastixTask align) throws Exception {
        ElastixTaskSettings settings = new ElastixTaskSettings();
        if (!this.alignTaskSet) {
            if (this.checkParametersForAlignement()) {
                void var6_8;
                ElastixMultiFile emfMoving = (ElastixMultiFile)this.movingImage.to(ElastixMultiFile.class);
                File[] fileArray = emfMoving.files;
                int n = fileArray.length;
                boolean bl = false;
                while (var6_8 < n) {
                    File f = fileArray[var6_8];
                    settings.movingImage(f::getAbsolutePath);
                    ++var6_8;
                }
                ElastixMultiFile emfFixed = (ElastixMultiFile)this.fixedImage.to(ElastixMultiFile.class);
                for (File f : emfFixed.files) {
                    settings.fixedImage(f::getAbsolutePath);
                }
                settings.outFolder(this.outputDir);
                if (this.verbose) {
                    settings.verbose();
                }
                if (this.registerInfo != null) {
                    settings.taskInfo = this.registerInfo;
                }
                for (Supplier supplier : this.transformFilesSupplier) {
                    settings.addTransform(supplier);
                }
                if (this.initialTransformFilePath != null) {
                    settings.addInitialTransform(this.initialTransformFilePath);
                }
                this.alignTaskSet = true;
            } else {
                align = null;
                this.alignTaskSet = false;
            }
        }
        if (this.alignTaskSet) {
            assert (align != null);
            align.run(settings);
        }
    }

    public String getFinalTransformFile() {
        return this.getTransformFile(this.transformFilesSupplier.size() - 1);
    }

    public String getTransformFile(int index) {
        return this.outputDir.get() + File.separator + "TransformParameters." + index + ".txt";
    }

    public int getNumberOfTransform() {
        return this.transformFilesSupplier.size();
    }

    @Converter
    public RHZipFile saveToZip(RegisterHelper rh) {
        try {
            String sourceFile = rh.outputDir.get();
            File temp = File.createTempFile("regtra", ".zip");
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            File fileToZip = new File(sourceFile);
            RegisterHelper.zipFolderNR(fileToZip, zipOut);
            for (int i = 0; i < rh.transformFilesSupplier.size(); ++i) {
                RegisterHelper.zipFile(new File(rh.transformFilesSupplier.get(i).get()), "RegisterParameters." + i + ".txt", zipOut);
            }
            zipOut.close();
            fos.close();
            return new RHZipFile(temp);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void zipFolder(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            if (fileName.endsWith(File.separator)) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + File.separator));
                zipOut.closeEntry();
            }
            File[] children = fileToZip.listFiles();
            assert (children != null);
            for (File childFile : children) {
                RegisterHelper.zipFolder(childFile, fileName + File.separator + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    private static void zipFolderNR(File fileToZip, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isDirectory()) {
            File[] children = fileToZip.listFiles();
            assert (children != null);
            for (File childFile : children) {
                int length;
                if (!childFile.getName().startsWith("TransformParameters")) continue;
                FileInputStream fis = new FileInputStream(childFile);
                ZipEntry zipEntry = new ZipEntry(childFile.getName());
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
                fis.close();
            }
        }
    }

    private static void zipFile(File fileToZip, String name, ZipOutputStream zipOut) throws IOException {
        int length;
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(name);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    @Converter
    public RegisterHelper loadFromZip(RHZipFile rzf) {
        RegisterHelper rh = new RegisterHelper();
        rh.setDefaultOutputDir();
        String pathOutputDir = rh.outputDir.get();
        HashMap<Integer, File> registerFiles = new HashMap<Integer, File>();
        HashMap<Integer, File> transformFiles = new HashMap<Integer, File>();
        try {
            String fileZip = rzf.f.getAbsolutePath();
            byte[] buffer = new byte[1024];
            FileInputStream fis = new FileInputStream(fileZip);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                int len;
                File newFile;
                String number;
                String fileName = zipEntry.getName();
                String regexTrParam = "(TransformParameters\\.)(\\d+)(\\.txt)";
                String regexReParam = "(RegisterParameters\\.)(\\d+)(\\.txt)";
                if (fileName.startsWith("TransformParameters")) {
                    number = fileName.replaceAll(regexTrParam, "$2");
                    newFile = new File(pathOutputDir + File.separator + fileName);
                    newFile.deleteOnExit();
                    transformFiles.put(Integer.valueOf(number), newFile);
                } else {
                    assert (fileName.startsWith("RegisterParameters"));
                    number = fileName.replaceAll(regexReParam, "$2");
                    newFile = File.createTempFile("rpa", ".txt");
                    newFile.deleteOnExit();
                    registerFiles.put(Integer.valueOf(number), newFile);
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (registerFiles.containsKey(i)) {
            rh.addTransformFromFilePath(((File)registerFiles.get(i)).getAbsolutePath());
            ++i;
        }
        i = 1;
        try {
            String regexTr = "(\\(InitialTransformParametersFileName\\s\")(.+)(\"\\))";
            while (transformFiles.containsKey(i)) {
                String line;
                File f = (File)transformFiles.get(i);
                BufferedReader file = new BufferedReader(new FileReader(f));
                StringBuilder inputBuffer = new StringBuilder();
                while ((line = file.readLine()) != null) {
                    String putData = line.replaceAll(regexTr, "$1" + ((File)transformFiles.get(i - 1)).getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "$3");
                    inputBuffer.append(putData);
                    inputBuffer.append('\n');
                }
                String inputStr = inputBuffer.toString();
                file.close();
                FileOutputStream fileOut = new FileOutputStream(f);
                fileOut.write(inputStr.getBytes());
                fileOut.close();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rh;
    }
}

