/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.elastix;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ElastixTaskSettings {
    public final List<Supplier<String>> fixedImagePathSuppliers = new ArrayList<Supplier<String>>();
    public final List<Supplier<String>> movingImagePathSuppliers = new ArrayList<Supplier<String>>();
    public Supplier<String> outputFolderSupplier;
    public String initialTransformFilePath;
    public int nThreads;
    public final ArrayList<Supplier<String>> transformationParameterPathSupplier = new ArrayList();
    public String taskInfo;
    public boolean verbose = false;

    public ElastixTaskSettings singleThread() {
        this.nThreads = 1;
        return this;
    }

    public ElastixTaskSettings nThreads(int nThreads) {
        this.nThreads = nThreads;
        return this;
    }

    public ElastixTaskSettings fixedImage(Supplier<String> fImgSupplier) {
        this.fixedImagePathSuppliers.add(fImgSupplier);
        return this;
    }

    public ElastixTaskSettings movingImage(Supplier<String> mImgSupplier) {
        this.movingImagePathSuppliers.add(mImgSupplier);
        return this;
    }

    public ElastixTaskSettings addTransform(Supplier<String> transformSupplier) {
        this.transformationParameterPathSupplier.add(transformSupplier);
        return this;
    }

    public ElastixTaskSettings outFolder(Supplier<String> outputFolderSupplier) {
        this.outputFolderSupplier = outputFolderSupplier;
        return this;
    }

    public ElastixTaskSettings addInitialTransform(String initialTransformFilePath) {
        this.initialTransformFilePath = initialTransformFilePath;
        return this;
    }

    public ElastixTaskSettings verbose() {
        this.verbose = true;
        return this;
    }
}

