/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.elastix;

import ij.IJ;
import ij.Prefs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Elastix {
    public static final String keyPrefix = Elastix.class.getName() + ".";
    static final String defaultExePath = "elastix";
    public static String exePath = Prefs.get((String)(keyPrefix + "exePath"), (String)"elastix");
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    public static void setExePath(File f) {
        exePath = f.getAbsolutePath();
        Prefs.set((String)(keyPrefix + "exePath"), (String)exePath);
    }

    public static void execute(List<String> options, boolean verbose) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        if (IJ.isMacOSX() || IJ.isLinux()) {
            String elastix_folder_path = new File(new File(exePath).getParent()).getParent();
            String registrationCommand = "";
            for (String command : options) {
                registrationCommand = registrationCommand + " " + command;
            }
            cmd.add("bash");
            cmd.add("-c");
            String exportPATH = "export PATH=" + elastix_folder_path + "/bin/:$PATH";
            String exportLIB = "";
            if (IJ.isMacOSX()) {
                exportLIB = "export DYLD_LIBRARY_PATH=" + elastix_folder_path + "/lib/:$DYLD_LIBRARY_PATH";
            } else if (IJ.isLinux()) {
                exportLIB = "export LD_LIBRARY_PATH=" + elastix_folder_path + "/lib/:$LD_LIBRARY_PATH";
            }
            cmd.add(exportLIB + " ; " + exportPATH + " ; elastix" + registrationCommand);
        } else if (IJ.isWindows()) {
            cmd.add(exePath);
            cmd.addAll(options);
        } else {
            System.err.println("Elastix error: type of OS not found.");
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
        if (verbose) {
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        } else {
            pb.redirectOutput(NULL_FILE);
        }
        Process p = pb.start();
        p.waitFor();
    }

    public static void execute(String singleCommand) throws IOException, InterruptedException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(singleCommand);
        Elastix.execute(cmdList, false);
    }
}

