/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.elastix;

import ch.epfl.biop.wrappers.elastix.Elastix;
import ch.epfl.biop.wrappers.elastix.ElastixTask;
import ch.epfl.biop.wrappers.elastix.ElastixTaskSettings;
import java.util.ArrayList;
import java.util.function.Supplier;

public class DefaultElastixTask
implements ElastixTask {
    @Override
    public void run(ElastixTaskSettings settings) throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-threads");
        options.add("" + settings.nThreads);
        if (settings.fixedImagePathSuppliers.size() == 1) {
            options.add("-f");
            options.add(settings.fixedImagePathSuppliers.get(0).get());
            options.add("-m");
            options.add(settings.movingImagePathSuppliers.get(0).get());
        } else {
            int iCh;
            for (iCh = 0; iCh < settings.fixedImagePathSuppliers.size(); ++iCh) {
                options.add("-f" + iCh);
                options.add(settings.fixedImagePathSuppliers.get(iCh).get());
            }
            for (iCh = 0; iCh < settings.movingImagePathSuppliers.size(); ++iCh) {
                options.add("-m" + iCh);
                options.add(settings.movingImagePathSuppliers.get(iCh).get());
            }
        }
        if (settings.initialTransformFilePath != null) {
            options.add("-t0");
            options.add(settings.initialTransformFilePath);
        }
        for (Supplier<String> s : settings.transformationParameterPathSupplier) {
            options.add("-p");
            options.add(s.get());
        }
        options.add("-out");
        options.add(settings.outputFolderSupplier.get());
        Elastix.execute(options, settings.verbose);
    }
}

