/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.deepslice;

import ch.epfl.biop.wrappers.Conda;
import ij.IJ;
import ij.Prefs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DeepSlice {
    public static final String keyPrefix = DeepSlice.class.getName() + ".";
    static final String defaultEnvDirPath = "C:/Users/username/.conda/envs/deepslice";
    static final String defaultVersion = "1.1.5.1";
    public static String envDirPath = Prefs.get((String)(keyPrefix + "envDirPath"), (String)"C:/Users/username/.conda/envs/deepslice");
    public static String version = Prefs.get((String)(keyPrefix + "version"), (String)"1.1.5.1");

    public static void setEnvDirPath(File f) {
        envDirPath = f.getAbsolutePath();
        Prefs.set((String)(keyPrefix + "envDirPath"), (String)envDirPath);
    }

    public static void setVersion(String version) {
        DeepSlice.version = version;
        Prefs.set((String)(keyPrefix + "version"), (String)version);
    }

    static String getDeepSliceCLIScriptPath() {
        return envDirPath + File.separator + DeepSlice.getDeepSliceCLIScriptName();
    }

    static String getDeepSliceCLIScriptName() {
        return "deepslice_cli_v" + version + ".py";
    }

    static boolean ensureScriptIsCopied() {
        File f = new File(DeepSlice.getDeepSliceCLIScriptPath());
        boolean fileExist = f.exists();
        if (fileExist) {
            return true;
        }
        String resourceFileName = DeepSlice.getDeepSliceCLIScriptName();
        String destinationFolderPath = envDirPath;
        try {
            InputStream inputStream = DeepSlice.class.getResourceAsStream("/" + resourceFileName);
            if (inputStream == null) {
                throw new Exception("Cannot get resource \"" + resourceFileName + "\" from Jar file.");
            }
            Path destinationPath = Paths.get(destinationFolderPath, resourceFileName);
            Files.copy(inputStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Resource file copied to: " + destinationPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Could not copy CLI script: " + e.getMessage());
            System.err.println("Please try to add the script file manually");
            return false;
        }
        return f.exists();
    }

    static void execute(List<String> options, Consumer<InputStream> outputHandler) throws IOException, InterruptedException {
        List<String> start_cmd;
        if (!DeepSlice.ensureScriptIsCopied()) {
            System.err.println("The CLI script to DeepSlice could not be copied to the env folder (" + envDirPath + ")");
            System.err.println("You can try to copy manually " + DeepSlice.getDeepSliceCLIScriptName() + " to this folder");
            return;
        }
        if (IJ.isWindows()) {
            start_cmd = Arrays.asList("cmd.exe", "/C");
        } else if (IJ.isMacOSX() || IJ.isLinux()) {
            start_cmd = Arrays.asList("bash", "-c");
        } else {
            IJ.error((String)"OS unrecognized!!");
            start_cmd = Collections.singletonList("");
        }
        ArrayList<String> cmd = new ArrayList<String>(start_cmd);
        if (IJ.isWindows()) {
            List<String> conda_activate_cmd = Arrays.asList("CALL", Conda.getWindowsCondaCommand(), "activate", envDirPath);
            cmd.addAll(conda_activate_cmd);
            cmd.add("&");
            List<String> cellpose_args_cmd = Arrays.asList("python", "-Xutf8", DeepSlice.getDeepSliceCLIScriptPath());
            cmd.addAll(cellpose_args_cmd);
            cmd.addAll(options);
        } else if (IJ.isMacOSX() || IJ.isLinux()) {
            String python_path = envDirPath + File.separatorChar + "bin" + File.separatorChar + "python";
            List<String> cellpose_args_cmd = new ArrayList<String>(Arrays.asList(python_path, DeepSlice.getDeepSliceCLIScriptPath()));
            cellpose_args_cmd.addAll(options);
            cellpose_args_cmd = cellpose_args_cmd.stream().map(s -> {
                if (s.trim().contains(" ")) {
                    return "\"" + s.trim() + "\"";
                }
                return s;
            }).collect(Collectors.toList());
            String cmdString = cellpose_args_cmd.toString().replace(",", "");
            cmd.add(cmdString.substring(1, cmdString.length() - 1));
        }
        System.out.println(((Object)cmd).toString().replace(",", ""));
        ProcessBuilder pb = new ProcessBuilder(cmd).redirectErrorStream(true);
        final Process p = pb.start();
        Thread t = new Thread(Thread.currentThread().getName() + "-" + p.hashCode()){

            @Override
            public void run() {
                BufferedReader stdIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line = stdIn.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = stdIn.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        t.setDaemon(true);
        t.start();
        p.waitFor();
        int exitValue = p.exitValue();
        if (exitValue != 0) {
            System.out.println("Runner " + envDirPath + " exited with value " + exitValue + ". Please check output above for indications of the problem.");
        } else {
            System.out.println("conda , " + envDirPath + " run finished");
        }
    }

    public static void execute(String singleCommand) throws IOException, InterruptedException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(singleCommand);
        DeepSlice.execute(cmdList, null);
    }
}

