/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers.cellpose.ij2commands;

import ch.epfl.biop.wrappers.cellpose.CellposeTaskSettings;
import ch.epfl.biop.wrappers.cellpose.DefaultCellposeTask;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.plugin.Concatenator;
import ij.plugin.Duplicator;
import ij.plugin.frame.Recorder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Cellpose/Omnipose>Cellpose ...")
public class Cellpose
implements Command {
    static String default_conda_env_path;
    @Parameter
    LogService ls;
    @Parameter
    ImagePlus imp;
    @Parameter(label="conda environment path", style="directory")
    File env_path = new File(default_conda_env_path);
    @Parameter(label="virtual environment type", choices={"conda", "venv"})
    String env_type = "conda";
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message = "You can use the pretrained model, specify the model name below";
    @Parameter(required=false, label="--pretrained_model")
    String model = "cyto3";
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message0 = "You can access the list of models by clicking on the button below.";
    @Parameter(label="List of cellpose models", callback="openModelsPage")
    private Button open_models_page_button;
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message1 = "OR To use your own model, specify the path below AND leave --pretrained_model empty";
    @Parameter(required=false, label="model_path")
    File model_path = new File("path/to/own_cellpose_model");
    @Parameter(label="--diameter")
    int diameter = 30;
    @Parameter(label="--chan")
    int ch1 = 0;
    @Parameter(label="--chan2")
    int ch2 = -1;
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message2 = "Add more parameters here. For flags: --use_gpu, --do_3D, or for parameters with values: --cellprob_threshold, -6";
    @Parameter(required=false, label="To add more parameters (use comma separated list of flags")
    String additional_flags = "--use_gpu, --do_3D";
    @Parameter(visibility=ItemVisibility.MESSAGE)
    String message3 = "You can access the full list of parameters by clicking on the button below.";
    @Parameter(label="List of all parameters", callback="openCliPage")
    private Button cli_page_button;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus cellpose_imp;
    @Parameter
    PlatformService ps;
    Boolean verbose = true;

    private void openModelsPage() {
        try {
            this.ps.open(new URL("https://cellpose.readthedocs.io/en/latest/models.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void openCliPage() {
        try {
            this.ps.open(new URL("https://cellpose.readthedocs.io/en/latest/cli.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        if (this.env_path == null || !this.env_path.exists()) {
            this.ls.error((Object)("Error: the cellpose environment path does not exist: " + this.env_path));
            return;
        }
        CellposeTaskSettings settings = new CellposeTaskSettings();
        DefaultCellposeTask cellposeTask = new DefaultCellposeTask();
        Calibration cal = this.imp.getCalibration();
        String tempDir = IJ.getDirectory((String)"Temp");
        File cellposeTempDir = new File(tempDir, "cellposeTemp");
        cellposeTempDir.mkdir();
        File[] contents = cellposeTempDir.listFiles();
        if (contents != null) {
            for (File f : contents) {
                f.delete();
            }
        }
        settings.setEnvPath(this.env_path.toString());
        settings.setEnvType(this.env_type);
        settings.setDatasetDir(cellposeTempDir.toString());
        String model_used = this.model;
        if (this.model == null || this.model.trim().isEmpty()) {
            this.ls.info((Object)("Using cellpose custom model: " + this.model_path));
            model_used = this.model_path.toString();
        }
        settings.setModel(model_used);
        settings.setDiameter(this.diameter);
        settings.setChannel1(this.ch1);
        if (this.ch2 > -1) {
            settings.setChannel2(this.ch2);
        }
        settings.setAdditionalFlags(this.additional_flags);
        cellposeTask.setSettings(settings);
        try {
            int impFrames = this.imp.getNFrames();
            ArrayList<File> t_imp_paths = new ArrayList<File>();
            ArrayList<File> cellpose_masks_paths = new ArrayList<File>();
            ArrayList<File> cellpose_outlines_paths = new ArrayList<File>();
            for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
                boolean tmpRecord = Recorder.record;
                Recorder.record = false;
                ImagePlus t_imp = new Duplicator().run(this.imp, 1, this.imp.getNChannels(), 1, this.imp.getNSlices(), t_idx, t_idx);
                Recorder.record = tmpRecord;
                File t_imp_path = new File(cellposeTempDir, this.imp.getShortTitle() + "-t" + t_idx + ".tif");
                FileSaver fs = new FileSaver(t_imp);
                fs.saveAsTiff(t_imp_path.toString());
                if (this.verbose.booleanValue()) {
                    System.out.println(t_imp_path);
                }
                t_imp_paths.add(t_imp_path);
                File cellpose_imp_path = new File(cellposeTempDir, this.imp.getShortTitle() + "-t" + t_idx + "_cp_masks.tif");
                cellpose_masks_paths.add(cellpose_imp_path);
                File cellpose_outlines_path = new File(cellposeTempDir, this.imp.getShortTitle() + "-t" + t_idx + "_cp_outlines.txt");
                cellpose_outlines_paths.add(cellpose_outlines_path);
            }
            cellposeTask.run();
            ArrayList<ImagePlus> imps = new ArrayList<ImagePlus>(impFrames);
            for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
                ImagePlus cellpose_t_imp = IJ.openImage((String)((File)cellpose_masks_paths.get(t_idx - 1)).toString());
                if (cellpose_t_imp.getBitDepth() != 32) {
                    if (cellpose_t_imp.getNSlices() > 1) {
                        cellpose_t_imp.getStack().setBitDepth(32);
                    } else {
                        cellpose_t_imp.setProcessor(cellpose_t_imp.getProcessor().convertToFloat());
                    }
                }
                imps.add(cellpose_t_imp.duplicate());
            }
            ImagePlus[] impsArray = imps.toArray(new ImagePlus[0]);
            boolean tmpScriptMode = Recorder.scriptMode();
            Field scriptModeField = Recorder.class.getDeclaredField("scriptMode");
            scriptModeField.setAccessible(true);
            scriptModeField.set(null, false);
            this.cellpose_imp = Concatenator.run((ImagePlus[])impsArray);
            scriptModeField.set(null, tmpScriptMode);
            this.cellpose_imp.setCalibration(cal);
            this.cellpose_imp.setTitle(this.imp.getShortTitle() + "-cellpose");
            boolean tmpRecord = Recorder.record;
            Recorder.record = false;
            IJ.run((ImagePlus)this.cellpose_imp, (String)"3-3-2 RGB", (String)"");
            Recorder.record = tmpRecord;
            for (int t_idx = 1; t_idx <= impFrames; ++t_idx) {
                ((File)t_imp_paths.get(t_idx - 1)).delete();
                ((File)cellpose_masks_paths.get(t_idx - 1)).delete();
                ((File)cellpose_outlines_paths.get(t_idx - 1)).delete();
            }
            cellposeTempDir.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (IJ.isLinux()) {
            default_conda_env_path = "/opt/conda/envs/cellpose";
        } else if (IJ.isWindows()) {
            default_conda_env_path = "C:/Users/username/.conda/envs/cellpose";
        } else if (IJ.isMacOSX()) {
            default_conda_env_path = "/Users/username/.conda/envs/cellpose";
        }
    }
}

