/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wrappers;

import ch.epfl.biop.wrappers.Conda;
import ij.IJ;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ExecutePythonInConda {
    public static void execute(String envDirPath, String envType, List<String> arguments, Consumer<InputStream> outputHandler) throws IOException, InterruptedException {
        List<String> module_args_cmd;
        ArrayList<String> cmd = new ArrayList<String>();
        List<String> start_cmd = null;
        if (IJ.isWindows()) {
            start_cmd = Arrays.asList("cmd.exe", "/C");
        } else if (IJ.isMacOSX() || IJ.isLinux()) {
            start_cmd = Arrays.asList("bash", "-c");
        } else {
            throw new RuntimeException("Unknown Operating System");
        }
        cmd.addAll(start_cmd);
        List<String> conda_activate_cmd = null;
        if (envType.equals("conda")) {
            if (IJ.isWindows()) {
                conda_activate_cmd = Arrays.asList("CALL", Conda.getWindowsCondaCommand(), "activate", envDirPath);
                cmd.addAll(conda_activate_cmd);
                cmd.add("&");
                List<String> module_args_cmd2 = Arrays.asList("python", "-Xutf8");
                cmd.addAll(module_args_cmd2);
                cmd.addAll(arguments);
            } else if (IJ.isMacOSX() || IJ.isLinux()) {
                String python_path = envDirPath + File.separatorChar + "bin" + File.separatorChar + "python";
                module_args_cmd = new ArrayList<String>(Collections.singletonList(python_path));
                module_args_cmd.addAll(arguments);
                module_args_cmd = module_args_cmd.stream().map(s -> {
                    if (s.trim().contains(" ")) {
                        return "\"" + s.trim() + "\"";
                    }
                    return s;
                }).collect(Collectors.toList());
                String cmdString = module_args_cmd.toString().replace(",", "");
                cmd.add(cmdString.substring(1, cmdString.length() - 1));
            }
        } else if (envType.equals("venv")) {
            if (IJ.isWindows()) {
                List<String> venv_activate_cmd = Arrays.asList(new File(envDirPath, "Scripts/activate").toString());
                cmd.addAll(venv_activate_cmd);
                cmd.add("&");
                module_args_cmd = Arrays.asList("python", "-Xutf8");
                cmd.addAll(module_args_cmd);
                cmd.addAll(arguments);
            } else if (IJ.isMacOSX() || IJ.isLinux()) {
                throw new UnsupportedOperationException("Mac/Unix not supported yet with virtual environment. Please try conda instead.");
            }
        } else {
            throw new UnsupportedOperationException("Virtual env type unrecognized!");
        }
        System.out.println("Running " + arguments + " with the command in the line below: ");
        System.out.println(((Object)cmd).toString().replace(",", ""));
        ProcessBuilder pb = new ProcessBuilder(cmd).redirectErrorStream(true);
        final Process p = pb.start();
        Thread t = new Thread(Thread.currentThread().getName() + "-" + p.hashCode()){

            @Override
            public void run() {
                BufferedReader stdIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line = stdIn.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = stdIn.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        t.setDaemon(true);
        t.start();
        p.waitFor();
        int exitValue = p.exitValue();
        if (exitValue != 0) {
            System.out.println("Runner " + envDirPath + " exited with value " + exitValue + ". Please check output above for indications of the problem.");
        } else {
            System.out.println(envDirPath + " run finished");
        }
    }
}

