/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.java.utilities.roi.types;

import ch.epfl.biop.java.utilities.roi.types.CompositeFloatPoly;
import ij.gui.Roi;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;

public class IJShapeRoiArray {
    public final List<CompositeFloatPoly> rois = new ArrayList<CompositeFloatPoly>();

    public IJShapeRoiArray(List<Roi> rois_in) {
        rois_in.forEach(roi -> this.rois.add(new CompositeFloatPoly((Roi)roi)));
    }

    public IJShapeRoiArray(IJShapeRoiArray input) {
        for (CompositeFloatPoly cfp : input.rois) {
            this.rois.add(new CompositeFloatPoly(cfp));
        }
    }

    public List<Point2D> getPoints() {
        LinkedList<Point2D> allPts = new LinkedList<Point2D>();
        this.rois.forEach(fp -> allPts.addAll(fp.getControlPoints()));
        return allPts;
    }

    public void setPoints(List<Point2D> controlPoints) {
        int index = 0;
        for (CompositeFloatPoly cfp : this.rois) {
            int nPts = cfp.getNumberOfCtrlPts();
            cfp.setControlPoints(controlPoints.subList(index, index + nPts));
            index += nPts;
        }
    }

    public void transform(UnaryOperator<Point2D> transformer) {
        List<Point2D> ctrlPts = this.getPoints();
        ctrlPts.replaceAll(transformer);
        this.setPoints(ctrlPts);
    }

    public void smoothenWithConstrains(boolean[][] movablePx) {
        for (CompositeFloatPoly cfp : this.rois) {
            cfp.smoothenWithConstrains(movablePx);
        }
    }
}

