/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.java.utilities.roi.types;

import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.process.FloatPolygon;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;

public class CompositeFloatPoly {
    public Color color;
    private static final double SHAPE_TO_ROI = -1.0;
    static final int NO_TYPE = 128;
    private static final int MAXPOLY = 10;
    private boolean forceTrace = false;
    private double maxerror = 0.001;
    static final double MAXERROR = 0.001;
    private boolean forceAngle = false;
    double x = 0.0;
    double y = 0.0;
    ArrayList<FloatPolygon> polys;
    public String name;

    public CompositeFloatPoly(CompositeFloatPoly cfp_in) {
        if (cfp_in != null) {
            this.forceTrace = cfp_in.forceTrace;
            this.maxerror = cfp_in.maxerror;
            this.forceAngle = cfp_in.forceAngle;
            this.name = cfp_in.name;
            this.color = cfp_in.color;
            this.polys = new ArrayList();
            this.x = cfp_in.x;
            this.y = cfp_in.y;
            for (FloatPolygon fp : cfp_in.polys) {
                this.polys.add(new FloatPolygon((float[])fp.xpoints.clone(), (float[])fp.ypoints.clone()));
            }
        } else {
            System.err.println("Error : null roi given as an input in CompositeFloatPoly constructor.");
        }
    }

    public CompositeFloatPoly(Roi roi) {
        if (roi != null) {
            this.name = roi.getName();
            this.color = roi.getStrokeColor();
            this.polys = new ArrayList();
            this.x = roi.getXBase();
            this.y = roi.getYBase();
            if (roi instanceof ShapeRoi) {
                Roi[] rois;
                ShapeRoi sr = (ShapeRoi)roi;
                for (Roi r : rois = this.getRois(sr)) {
                    this.polys.add(r.getFloatPolygon());
                }
            } else {
                this.polys.add(roi.getFloatPolygon());
            }
        } else {
            System.err.println("Error : null roi given as an input in CompositeFloatPoly constructor.");
        }
    }

    public String toString() {
        return this.name;
    }

    public static double getArea(FloatPolygon pr) {
        if (pr.npoints < 3) {
            return 0.0;
        }
        double area = 0.0;
        for (int i = 0; i < pr.npoints - 1; ++i) {
            area += (double)(pr.xpoints[i] * pr.ypoints[i + 1] - pr.ypoints[i] * pr.xpoints[i + 1]);
        }
        return (area += (double)(pr.xpoints[pr.npoints - 1] * pr.ypoints[0] - pr.ypoints[pr.npoints - 1] * pr.xpoints[0])) / 2.0;
    }

    public void smoothenWithConstrains(boolean[][] movablePx) {
        for (FloatPolygon pol : this.polys) {
            int i;
            float[] xout = new float[pol.npoints];
            float[] yout = new float[pol.npoints];
            for (i = 0; i < pol.npoints; ++i) {
                float y;
                float x;
                int iAfter;
                int iBefore = i - 1;
                if (iBefore < 0) {
                    iBefore = pol.npoints - 1;
                }
                if ((iAfter = i + 1) == pol.npoints) {
                    iAfter = 0;
                }
                if (movablePx[(int)(x = pol.xpoints[i])][(int)(y = pol.ypoints[i])]) {
                    float xb = pol.xpoints[iBefore];
                    float xa = pol.xpoints[iAfter];
                    float yb = pol.ypoints[iBefore];
                    float ya = pol.ypoints[iAfter];
                    float dx = xa - xb;
                    float dy = ya - yb;
                    float ld = (float)Math.sqrt(dx * dx + dy * dy);
                    float proj = (x - xb) * (dy /= ld) - (y - yb) * (dx /= ld);
                    x += -0.5f * proj * dy;
                    y += 0.5f * proj * dx;
                }
                xout[i] = x;
                yout[i] = y;
            }
            for (i = 0; i < pol.npoints; ++i) {
                pol.xpoints[i] = xout[i];
                pol.ypoints[i] = yout[i];
            }
        }
    }

    public Roi getRoi() {
        if (this.polys == null) {
            return null;
        }
        if (this.polys.isEmpty()) {
            return null;
        }
        if (this.polys.size() == 1) {
            FloatPolygon fp2 = this.polys.get(0);
            PolygonRoi roi = new PolygonRoi(fp2.xpoints, fp2.ypoints, fp2.npoints, 2);
            roi.setName(this.name);
            return roi;
        }
        Map<Boolean, List<FloatPolygon>> partitionedPolygons = this.polys.stream().collect(Collectors.partitioningBy(fp -> CompositeFloatPoly.getArea(fp) >= 0.0));
        Optional<ShapeRoi> positiveShape = partitionedPolygons.get(true).stream().map(this::getShape).map(ShapeRoi::new).reduce(ShapeRoi::or);
        Optional<ShapeRoi> negativeShape = partitionedPolygons.get(false).stream().map(this::getShape).map(ShapeRoi::new).reduce(ShapeRoi::or);
        if (positiveShape.isPresent()) {
            if (negativeShape.isPresent()) {
                ShapeRoi roi = positiveShape.get().xor(negativeShape.get());
                roi.setName(this.name);
                if (this.color != null) {
                    roi.setStrokeColor(this.color);
                }
                return roi;
            }
            Roi roi = (Roi)positiveShape.get();
            roi.setName(this.name);
            if (this.color != null) {
                roi.setStrokeColor(this.color);
            }
            return roi;
        }
        if (negativeShape.isPresent()) {
            Roi roi = (Roi)negativeShape.get();
            if (this.color != null) {
                roi.setStrokeColor(this.color);
            }
            roi.setName(this.name);
            return roi;
        }
        System.err.println("Could not build ROI : no positive and negative area defined.");
        return null;
    }

    Shape getShape(FloatPolygon fp) {
        GeneralPath polygon = new GeneralPath(0, fp.npoints);
        polygon.moveTo(fp.xpoints[0], fp.ypoints[0]);
        for (int index = 1; index < fp.npoints; ++index) {
            polygon.lineTo(fp.xpoints[index], fp.ypoints[index]);
        }
        polygon.closePath();
        return polygon;
    }

    public int getNumberOfCtrlPts() {
        return this.polys.stream().mapToInt(fp -> fp.npoints).sum();
    }

    public ArrayList<Point2D> getControlPoints() {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        this.polys.forEach(fp -> {
            for (int i = 0; i < fp.npoints; ++i) {
                list.add(new Point2D.Double(fp.xpoints[i], fp.ypoints[i]));
            }
        });
        return list;
    }

    public void setControlPoints(List<Point2D> pts) {
        if (pts.size() == this.getNumberOfCtrlPts()) {
            int ptsIndex = 0;
            for (FloatPolygon fp : this.polys) {
                for (int i = 0; i < fp.npoints; ++i) {
                    Point2D pt = pts.get(ptsIndex);
                    fp.xpoints[i] = (float)pt.getX();
                    fp.ypoints[i] = (float)pt.getY();
                    ++ptsIndex;
                }
            }
        } else {
            System.err.println("Non identical number of points between the shape and the input point list. SetControlPoints function ignored.");
        }
    }

    Roi[] getRois(ShapeRoi sr) {
        Roi r;
        Vector<Roi> rois = new Vector<Roi>();
        Shape shape = sr.getShape();
        if (shape instanceof Rectangle2D.Double) {
            r = new Roi((int)((Rectangle2D.Double)shape).getX(), (int)((Rectangle2D.Double)shape).getY(), (int)((Rectangle2D.Double)shape).getWidth(), (int)((Rectangle2D.Double)shape).getHeight());
            rois.addElement(r);
        } else if (shape instanceof Ellipse2D.Double) {
            r = new OvalRoi((int)((Ellipse2D.Double)shape).getX(), (int)((Ellipse2D.Double)shape).getY(), (int)((Ellipse2D.Double)shape).getWidth(), (int)((Ellipse2D.Double)shape).getHeight());
            rois.addElement(r);
        } else if (shape instanceof Line2D.Double) {
            r = new Line((int)((Line2D.Double)shape).getX1(), (int)((Line2D.Double)shape).getY1(), (int)((Line2D.Double)shape).getX2(), (int)((Line2D.Double)shape).getY2());
            rois.addElement(r);
        } else if (shape instanceof Polygon) {
            r = new PolygonRoi(((Polygon)shape).xpoints, ((Polygon)shape).ypoints, ((Polygon)shape).npoints, 2);
            rois.addElement(r);
        } else if (shape instanceof GeneralPath) {
            PathIterator pIter = shape.getPathIterator(new AffineTransform());
            this.parsePath(pIter, null, null, rois, null);
        }
        Object[] array = new Roi[rois.size()];
        rois.copyInto(array);
        return array;
    }

    boolean parsePath(PathIterator pIter, double[] params, Vector segments, Vector rois, Vector handles) {
        if (pIter == null || pIter.isDone()) {
            return false;
        }
        boolean result = true;
        double pw = 1.0;
        double ph = 1.0;
        Vector<Double> xCoords = new Vector<Double>();
        Vector<Double> yCoords = new Vector<Double>();
        if (segments == null) {
            segments = new Vector<Integer>();
        }
        if (handles == null) {
            handles = new Vector<Point2D.Double>();
        }
        if (params == null) {
            params = new double[1];
        }
        boolean shapeToRoi = params[0] == -1.0;
        int subPaths = 0;
        int count = 0;
        int roiType = 0;
        boolean closed = false;
        boolean linesOnly = true;
        boolean curvesOnly = true;
        double sX = Double.NaN;
        double sY = Double.NaN;
        double x0 = Double.NaN;
        double y0 = Double.NaN;
        double usX = Double.NaN;
        double usY = Double.NaN;
        double ux0 = Double.NaN;
        double uy0 = Double.NaN;
        double pathLength = 0.0;
        boolean done = false;
        while (!done) {
            Roi r;
            double[] coords = new double[6];
            double[] ucoords = new double[6];
            int segType = pIter.currentSegment(coords);
            segments.add(segType);
            ++count;
            System.arraycopy(coords, 0, ucoords, 0, coords.length);
            switch (segType) {
                case 0: {
                    if (subPaths > 0) {
                        boolean bl = closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                        if (closed && (int)ux0 != (int)usX && (int)uy0 != (int)usY) {
                            xCoords.add((Double)xCoords.elementAt(0));
                            yCoords.add((Double)yCoords.elementAt(0));
                        }
                        if (rois != null && (r = this.createRoi(xCoords, yCoords, roiType = this.guessType(count, linesOnly, curvesOnly, closed))) != null) {
                            rois.addElement(r);
                        }
                        xCoords = new Vector();
                        yCoords = new Vector();
                        count = 1;
                    }
                    ++subPaths;
                    usX = ucoords[0];
                    usY = ucoords[1];
                    ux0 = ucoords[0];
                    uy0 = ucoords[1];
                    sX = coords[0];
                    sY = coords[1];
                    x0 = coords[0];
                    y0 = coords[1];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    xCoords.add(ucoords[0]);
                    yCoords.add(ucoords[1]);
                    closed = false;
                    break;
                }
                case 1: {
                    curvesOnly = false;
                    pathLength += Math.sqrt(Math.pow(y0 - coords[1], 2.0) + Math.pow(x0 - coords[0], 2.0));
                    ux0 = ucoords[0];
                    uy0 = ucoords[1];
                    x0 = coords[0];
                    y0 = coords[1];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    xCoords.add(ucoords[0]);
                    yCoords.add(ucoords[1]);
                    closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                    break;
                }
                case 2: {
                    linesOnly = false;
                    Shape curve = new QuadCurve2D.Double(x0, y0, coords[0], coords[2], coords[2], coords[3]);
                    pathLength += this.qBezLength((QuadCurve2D.Double)curve);
                    ux0 = ucoords[2];
                    uy0 = ucoords[3];
                    x0 = coords[2];
                    y0 = coords[3];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    handles.add(new Point2D.Double(ucoords[2], ucoords[3]));
                    xCoords.add(ucoords[2]);
                    yCoords.add(ucoords[3]);
                    closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                    break;
                }
                case 3: {
                    linesOnly = false;
                    Shape curve = new CubicCurve2D.Double(x0, y0, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    pathLength += this.cBezLength((CubicCurve2D.Double)curve);
                    ux0 = ucoords[4];
                    uy0 = ucoords[5];
                    x0 = coords[4];
                    y0 = coords[5];
                    handles.add(new Point2D.Double(ucoords[0], ucoords[1]));
                    handles.add(new Point2D.Double(ucoords[2], ucoords[3]));
                    handles.add(new Point2D.Double(ucoords[4], ucoords[5]));
                    xCoords.add(ucoords[4]);
                    yCoords.add(ucoords[5]);
                    closed = (int)ux0 == (int)usX && (int)uy0 == (int)usY;
                    break;
                }
                case 4: {
                    if ((int)ux0 != (int)usX && (int)uy0 != (int)usY) {
                        pathLength += Math.sqrt(Math.pow(x0 - sX, 2.0) + Math.pow(y0 - sY, 2.0));
                    }
                    closed = true;
                    break;
                }
            }
            pIter.next();
            done = pIter.isDone() || shapeToRoi && rois != null && rois.size() == 1;
            if (!done) continue;
            if (closed && (int)x0 != (int)sX && (int)y0 != (int)sY) {
                xCoords.add((Double)xCoords.elementAt(0));
                yCoords.add((Double)yCoords.elementAt(0));
            }
            if (rois == null || (r = this.createRoi(xCoords, yCoords, roiType = shapeToRoi ? 4 : this.guessType(count + 1, linesOnly, curvesOnly, closed))) == null) continue;
            rois.addElement(r);
        }
        params[0] = pathLength;
        return result;
    }

    private int guessType(int segments, boolean linesOnly, boolean curvesOnly, boolean closed) {
        closed = true;
        int roiType = 0;
        if (linesOnly) {
            switch (segments) {
                case 0: {
                    roiType = 128;
                    break;
                }
                case 1: {
                    roiType = 128;
                    break;
                }
                case 2: {
                    roiType = closed ? 128 : 5;
                    break;
                }
                case 3: {
                    roiType = closed ? 2 : (this.forceAngle ? 8 : 6);
                    break;
                }
                case 4: {
                    roiType = closed ? 0 : 6;
                    break;
                }
                default: {
                    if (segments <= 10) {
                        roiType = closed ? 2 : 6;
                        break;
                    }
                    roiType = closed ? (this.forceTrace ? 4 : 3) : 7;
                    break;
                }
            }
        } else {
            roiType = segments >= 2 ? 9 : 128;
        }
        return roiType;
    }

    double qBezLength(QuadCurve2D.Double c) {
        double l = 0.0;
        double cl = this.qclength(c);
        double pl = this.qplength(c);
        if ((pl - cl) / 2.0 > this.maxerror) {
            QuadCurve2D.Double[] cc = this.qBezSplit(c);
            for (int i = 0; i < 2; ++i) {
                l += this.qBezLength(cc[i]);
            }
            return l;
        }
        l = (2.0 * pl + cl) / 3.0;
        return l;
    }

    double qclength(QuadCurve2D.Double c) {
        return Math.sqrt(Math.pow(c.x2 - c.x1, 2.0) + Math.pow(c.y2 - c.y1, 2.0));
    }

    private Roi createRoi(Vector xCoords, Vector yCoords, int roiType) {
        if (roiType == 128) {
            return null;
        }
        PolygonRoi roi = null;
        if (xCoords.size() != yCoords.size() || xCoords.isEmpty()) {
            return null;
        }
        double[] xPoints = new double[xCoords.size()];
        double[] yPoints = new double[yCoords.size()];
        for (int i = 0; i < xPoints.length; ++i) {
            xPoints[i] = (Double)xCoords.elementAt(i) + this.x;
            yPoints[i] = (Double)yCoords.elementAt(i) + this.y;
        }
        double startX = 0.0;
        double startY = 0.0;
        double width = 0.0;
        double height = 0.0;
        switch (roiType) {
            case 9: {
                System.err.println("Unsupported createRoi operation!");
                break;
            }
            case 1: {
                startX = xPoints[xPoints.length - 4];
                startY = yPoints[yPoints.length - 3];
                width = this.max(xPoints) - this.min(xPoints);
                height = this.max(yPoints) - this.min(yPoints);
                roi = new OvalRoi(startX, startY, width, height);
                break;
            }
            case 0: {
                startX = xPoints[0];
                startY = yPoints[0];
                width = this.max(xPoints) - this.min(xPoints);
                height = this.max(yPoints) - this.min(yPoints);
                roi = new Roi(startX, startY, width, height);
                break;
            }
            case 5: {
                roi = new Line(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                break;
            }
            default: {
                int n = xPoints.length;
                roi = new PolygonRoi(this.toFloatArray(xPoints), this.toFloatArray(yPoints), n, roiType);
                if (roiType != 3) break;
                double length = roi.getLength();
                double mag = 1.0;
                if (!((length *= mag) / (double)n >= 15.0)) break;
                roi = new PolygonRoi(this.toFloatArray(xPoints), this.toFloatArray(yPoints), n, 2);
            }
        }
        return roi;
    }

    float[] toFloatArray(double[] arr) {
        if (arr == null) {
            return null;
        }
        int n = arr.length;
        float[] ret = new float[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = (float)arr[i];
        }
        return ret;
    }

    private int min(int[] array) {
        int val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.min(val, array[i]);
        }
        return val;
    }

    private int max(int[] array) {
        int val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.max(val, array[i]);
        }
        return val;
    }

    private double min(double[] array) {
        double val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.min(val, array[i]);
        }
        return val;
    }

    private double max(double[] array) {
        double val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.max(val, array[i]);
        }
        return val;
    }

    double cBezLength(CubicCurve2D.Double c) {
        double l = 0.0;
        double cl = this.cclength(c);
        double pl = this.cplength(c);
        if ((pl - cl) / 2.0 > this.maxerror) {
            CubicCurve2D.Double[] cc = this.cBezSplit(c);
            for (int i = 0; i < 2; ++i) {
                l += this.cBezLength(cc[i]);
            }
            return l;
        }
        l = 0.5 * pl + 0.5 * cl;
        return l;
    }

    double cclength(CubicCurve2D.Double c) {
        return Math.sqrt(Math.pow(c.x2 - c.x1, 2.0) + Math.pow(c.y2 - c.y1, 2.0));
    }

    double cplength(CubicCurve2D.Double c) {
        double result = Math.sqrt(Math.pow(c.ctrlx1 - c.x1, 2.0) + Math.pow(c.ctrly1 - c.y1, 2.0));
        result += Math.sqrt(Math.pow(c.ctrlx2 - c.ctrlx1, 2.0) + Math.pow(c.ctrly2 - c.ctrly1, 2.0));
        return result += Math.sqrt(Math.pow(c.x2 - c.ctrlx2, 2.0) + Math.pow(c.y2 - c.ctrly2, 2.0));
    }

    CubicCurve2D.Double[] cBezSplit(CubicCurve2D.Double c) {
        CubicCurve2D.Double[] cc = new CubicCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            cc[i] = new CubicCurve2D.Double();
        }
        c.subdivide(cc[0], cc[1]);
        return cc;
    }

    QuadCurve2D.Double[] qBezSplit(QuadCurve2D.Double c) {
        QuadCurve2D.Double[] cc = new QuadCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            cc[i] = new QuadCurve2D.Double();
        }
        c.subdivide(cc[0], cc[1]);
        return cc;
    }

    double qplength(QuadCurve2D.Double c) {
        double result = Math.sqrt(Math.pow(c.ctrlx - c.x1, 2.0) + Math.pow(c.ctrly - c.y1, 2.0));
        return result += Math.sqrt(Math.pow(c.x2 - c.ctrlx, 2.0) + Math.pow(c.y2 - c.ctrly, 2.0));
    }
}

