/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.java.utilities.roi;

import ch.epfl.biop.java.utilities.roi.PathSampler;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.FloatPolygon;
import java.util.ArrayList;
import java.util.List;

public class ROIReShape {
    public static Roi reSample(Roi roiIn, float samplingDistance) {
        ArrayList<Float> xout = new ArrayList<Float>();
        ArrayList<Float> yout = new ArrayList<Float>();
        FloatPolygon pol = roiIn.getFloatPolygon();
        PathSampler ps = new PathSampler(pol.xpoints, pol.ypoints);
        ps.startSampling();
        while (ps.hasLength()) {
            float[] newPos = ps.getNextPtIncrementLenght(samplingDistance);
            xout.add(Float.valueOf(newPos[0]));
            yout.add(Float.valueOf(newPos[1]));
        }
        PolygonRoi roiOut = new PolygonRoi(ROIReShape.convertFloatArray(xout), ROIReShape.convertFloatArray(yout), xout.size(), 2);
        roiOut.setName(roiIn.getName());
        return roiOut;
    }

    public static Roi smoothen(Roi roiIn) {
        ArrayList<Float> xout = new ArrayList<Float>();
        ArrayList<Float> yout = new ArrayList<Float>();
        FloatPolygon pol = roiIn.getFloatPolygon();
        xout.add(Float.valueOf(pol.xpoints[0]));
        yout.add(Float.valueOf(pol.ypoints[0]));
        for (int i = 1; i < pol.npoints - 1; ++i) {
            float x = pol.xpoints[i];
            float y = pol.ypoints[i];
            float xb = pol.xpoints[i - 1];
            float xa = pol.xpoints[i + 1];
            float yb = pol.ypoints[i - 1];
            float ya = pol.ypoints[i + 1];
            float dx = xa - xb;
            float dy = ya - yb;
            float ld = (float)Math.sqrt(dx * dx + dy * dy);
            float proj = (x - xb) * (dy /= ld) - (y - yb) * (dx /= ld);
            xout.add(Float.valueOf(x += -0.5f * proj * dy));
            yout.add(Float.valueOf(y += 0.5f * proj * dx));
        }
        xout.add(Float.valueOf(pol.xpoints[pol.npoints - 1]));
        yout.add(Float.valueOf(pol.ypoints[pol.npoints - 1]));
        PolygonRoi roiOut = new PolygonRoi(ROIReShape.convertFloatArray(xout), ROIReShape.convertFloatArray(yout), xout.size(), 2);
        roiOut.setName(roiIn.getName());
        return roiOut;
    }

    public static Roi smoothenWithConstrains(Roi roiIn, boolean[][] movablePx) {
        ArrayList<Float> xout = new ArrayList<Float>();
        ArrayList<Float> yout = new ArrayList<Float>();
        FloatPolygon pol = roiIn.getFloatPolygon();
        for (int i = 0; i < pol.npoints; ++i) {
            float y;
            float x;
            int iAfter;
            int iBefore = i - 1;
            if (iBefore < 0) {
                iBefore = pol.npoints - 1;
            }
            if ((iAfter = i + 1) == pol.npoints) {
                iAfter = 0;
            }
            if (movablePx[(int)(x = pol.xpoints[i])][(int)(y = pol.ypoints[i])]) {
                float xb = pol.xpoints[iBefore];
                float xa = pol.xpoints[iAfter];
                float yb = pol.ypoints[iBefore];
                float ya = pol.ypoints[iAfter];
                float dx = xa - xb;
                float dy = ya - yb;
                float ld = (float)Math.sqrt(dx * dx + dy * dy);
                float proj = (x - xb) * (dy /= ld) - (y - yb) * (dx /= ld);
                x += -0.5f * proj * dy;
                y += 0.5f * proj * dx;
            }
            xout.add(Float.valueOf(x));
            yout.add(Float.valueOf(y));
        }
        PolygonRoi roiOut = new PolygonRoi(ROIReShape.convertFloatArray(xout), ROIReShape.convertFloatArray(yout), xout.size(), 2);
        roiOut.setName(roiIn.getName());
        return roiOut;
    }

    public static float[] convertFloatArray(List<Float> floatList) {
        float[] floatArray = new float[floatList.size()];
        int i = 0;
        for (Float f : floatList) {
            floatArray[i++] = f != null ? f.floatValue() : Float.NaN;
        }
        return floatArray;
    }
}

