/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.java.utilities.roi;

class PathSampler {
    final float[] xpts;
    final float[] ypts;
    int currentPtIndex;
    float currentLengthInSegment;
    float currentSegmentLength;
    boolean done;
    float xi;
    float yi;
    float xc;
    float yc;
    float dxi;
    float dyi;
    int previousIndex;
    boolean loopDone = false;

    public PathSampler(float[] xpts, float[] ypts) {
        this.xpts = xpts;
        this.ypts = ypts;
    }

    public void startSampling() {
        this.loopDone = false;
        this.currentSegmentLength = 0.0f;
        this.currentLengthInSegment = 0.0f;
        this.previousIndex = 0;
        this.currentPtIndex = 0;
        this.xi = this.xpts[0];
        this.yi = this.ypts[0];
        this.xc = this.xi;
        this.yc = this.yi;
        if (this.xpts.length == 1) {
            this.done = true;
        } else {
            this.dxi = this.xpts[1] - this.xpts[0];
            this.dyi = this.ypts[1] - this.ypts[0];
            this.currentPtIndex = 1;
            this.currentSegmentLength = (float)Math.sqrt(this.dxi * this.dxi + this.dyi * this.dyi);
            this.done = false;
        }
    }

    public float[] getNextPtIncrementLenght(float lengthIncrement) {
        if (this.done) {
            return new float[]{this.xpts[0], this.ypts[0]};
        }
        boolean newSampleFound = false;
        while (!newSampleFound && !this.done) {
            if (this.currentLengthInSegment + lengthIncrement < this.currentSegmentLength) {
                this.currentLengthInSegment += lengthIncrement;
                float ratio = this.currentLengthInSegment / this.currentSegmentLength;
                this.xc = this.xi + ratio * this.dxi;
                this.yc = this.yi + ratio * this.dyi;
                newSampleFound = true;
                continue;
            }
            this.currentLengthInSegment -= this.currentSegmentLength;
            this.previousIndex = this.currentPtIndex++;
            if (this.currentPtIndex == 1 && this.loopDone) {
                this.done = true;
                this.xc = this.xpts[0];
                this.yc = this.ypts[0];
                continue;
            }
            if (this.currentPtIndex == this.xpts.length) {
                this.xi = this.xpts[this.previousIndex];
                this.yi = this.ypts[this.previousIndex];
                this.currentPtIndex = 0;
                this.dxi = this.xpts[this.currentPtIndex] - this.xi;
                this.dyi = this.ypts[this.currentPtIndex] - this.yi;
                this.loopDone = true;
            } else {
                this.xi = this.xpts[this.previousIndex];
                this.yi = this.ypts[this.previousIndex];
                this.dxi = this.xpts[this.currentPtIndex] - this.xi;
                this.dyi = this.ypts[this.currentPtIndex] - this.yi;
            }
            this.currentSegmentLength = (float)Math.sqrt(this.dxi * this.dxi + this.dyi * this.dyi);
        }
        return new float[]{this.xc, this.yc};
    }

    public boolean hasLength() {
        return !this.done;
    }
}

