/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.java.utilities.roi;

import ch.epfl.biop.java.utilities.Converter;
import ch.epfl.biop.java.utilities.ConvertibleObject;
import ch.epfl.biop.java.utilities.roi.SelectToROIKeepLines;
import ch.epfl.biop.java.utilities.roi.Svg2Roi;
import ch.epfl.biop.java.utilities.roi.types.CompositeFloatPoly;
import ch.epfl.biop.java.utilities.roi.types.IJShapeRoiArray;
import ch.epfl.biop.java.utilities.roi.types.ImageJRoisFile;
import ch.epfl.biop.java.utilities.roi.types.RealPointList;
import ch.epfl.biop.java.utilities.roi.types.SVGRoisFormat;
import ch.epfl.biop.java.utilities.roi.types.SVGURL;
import ch.epfl.biop.java.utilities.roi.types.TransformixInputRoisFile;
import ch.epfl.biop.java.utilities.roi.types.TransformixOutputRoisFile;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.RoiManager;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.imglib2.RealPoint;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.svg.SVGDocument;

public class ConvertibleRois
extends ConvertibleObject {
    @Converter
    public static ImageJRoisFile arrayToImageJFileFormat(IJShapeRoiArray rois) {
        HashMap avoidDuplicates = new HashMap();
        try {
            File temp = File.createTempFile("trois", ".zip");
            temp.deleteOnExit();
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            RoiEncoder re = new RoiEncoder((OutputStream)out);
            rois.rois.stream().map(CompositeFloatPoly::getRoi).forEach(roi -> {
                if (roi != null) {
                    String label = roi.getName();
                    if (avoidDuplicates.containsKey(label)) {
                        avoidDuplicates.put(label, (Integer)avoidDuplicates.get(label) + 1);
                        label = label + "-" + avoidDuplicates.get(label);
                    } else {
                        avoidDuplicates.put(label, 0);
                    }
                    try {
                        zos.putNextEntry(new ZipEntry(label + ".roi"));
                        re.write(roi);
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            out.close();
            return new ImageJRoisFile(temp);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static IJShapeRoiArray imageJFileFormatToArray(ImageJRoisFile ijf) {
        ArrayList<Roi> list = new ArrayList<Roi>();
        ZipInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new ZipInputStream(new FileInputStream(ijf.f));
            byte[] buf = new byte[1024];
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(".roi")) {
                    int len;
                    out = new ByteArrayOutputStream();
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    byte[] bytes = out.toByteArray();
                    RoiDecoder rd = new RoiDecoder(bytes, name);
                    Roi roi = rd.getRoi();
                    if (roi != null) {
                        list.add(roi);
                    }
                }
                entry = in.getNextEntry();
            }
            in.close();
            IJShapeRoiArray iJShapeRoiArray = new IJShapeRoiArray(list);
            return iJShapeRoiArray;
        }
        catch (IOException e) {
            IJShapeRoiArray iJShapeRoiArray = null;
            return iJShapeRoiArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Converter
    public static IJShapeRoiArray svgFileFormatToArray(SVGRoisFormat svg) {
        SVGDocument svgDoc = Svg2Roi.getSVGDocumentFromFilePath(svg.f.getAbsolutePath());
        return new IJShapeRoiArray(Svg2Roi.getRoisFromSVGNodeList(svgDoc.getElementsByTagName("path"), svg.sampleLength * svg.downscaleFactor, svg.downscaleFactor));
    }

    @Converter
    public static SVGRoisFormat urlToSvgFileFormat(SVGURL svgurl) {
        try {
            File temp = File.createTempFile("timg", ".svg");
            temp.deleteOnExit();
            FileUtils.copyURLToFile((URL)svgurl.url, (File)temp, (int)10000, (int)10000);
            return new SVGRoisFormat(temp);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static TransformixInputRoisFile arrayToElastixFileFormat(IJShapeRoiArray rois) {
        BufferedWriter writer = null;
        try {
            File temp = File.createTempFile("tpts", ".txt");
            TransformixInputRoisFile erf = new TransformixInputRoisFile(temp);
            erf.shapeRoiList = rois;
            List<Point2D> ctrlPts = rois.getPoints();
            int nPts = ctrlPts.size();
            writer = new BufferedWriter(new FileWriter(temp));
            writer.write("point");
            writer.newLine();
            writer.write(Integer.toString(nPts));
            writer.newLine();
            for (Point2D pt : ctrlPts) {
                writer.write(Double.toString(pt.getX()));
                writer.write("\t");
                writer.write(Double.toString(pt.getY()));
                writer.newLine();
            }
            writer.close();
            TransformixInputRoisFile transformixInputRoisFile = erf;
            return transformixInputRoisFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            TransformixInputRoisFile transformixInputRoisFile = null;
            return transformixInputRoisFile;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Converter
    public static IJShapeRoiArray roiManagerToArray(RoiManager rm) {
        ArrayList<Roi> rois = new ArrayList<Roi>();
        Roi[] roisArray = rm.getRoisAsArray();
        Collections.addAll(rois, roisArray);
        return new IJShapeRoiArray(rois);
    }

    @Converter
    public RealPointList roiArrayToRealPointList(IJShapeRoiArray rois) {
        ArrayList<RealPoint> out = new ArrayList<RealPoint>();
        for (Point2D pt : rois.getPoints()) {
            out.add(new RealPoint(new double[]{pt.getX(), pt.getY()}));
        }
        RealPointList rpl = new RealPointList(out);
        rpl.shapeRoiList = rois;
        return rpl;
    }

    @Converter
    public IJShapeRoiArray realPointListToRoiArray(RealPointList in) {
        IJShapeRoiArray out = new IJShapeRoiArray(in.shapeRoiList);
        out.setPoints(in.ptList.stream().map(rp -> new Point2D.Double(rp.getDoublePosition(0), rp.getDoublePosition(1))).collect(Collectors.toList()));
        return out;
    }

    @Converter
    public static RoiManager arrayToRoiManager(IJShapeRoiArray rois) {
        RoiManager roiManager = RoiManager.getRoiManager();
        if (roiManager == null) {
            roiManager = new RoiManager();
        }
        roiManager.reset();
        for (int i = 0; i < rois.rois.size(); ++i) {
            roiManager.addRoi(rois.rois.get(i).getRoi());
        }
        return roiManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static IJShapeRoiArray elastixFileFormatToArray(TransformixOutputRoisFile erf) {
        BufferedReader reader = null;
        try {
            String line;
            IJShapeRoiArray out = new IJShapeRoiArray(erf.shapeRoiList);
            reader = new BufferedReader(new FileReader(erf.f));
            ArrayList<Point2D> ptList = new ArrayList<Point2D>();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(";");
                String[] part = parts[4].split("[\\s]");
                double x = Double.parseDouble(part[4].trim());
                double y = Double.parseDouble(part[5].trim());
                ptList.add(new Point2D.Double(x, y));
            }
            out.setPoints(ptList);
            reader.close();
            IJShapeRoiArray iJShapeRoiArray = out;
            return iJShapeRoiArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            IJShapeRoiArray iJShapeRoiArray = null;
            return iJShapeRoiArray;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Converter
    public ImagePlus roiArrayToLabelImage(IJShapeRoiArray rois) {
        float xmin = 0.0f;
        float xmax = 100.0f;
        float ymin = 0.0f;
        float ymax = 100.0f;
        for (CompositeFloatPoly cfp : rois.rois) {
            Roi roi = cfp.getRoi();
            if ((float)roi.getBounds().x < xmin) {
                xmin = roi.getBounds().x;
            }
            if ((float)roi.getBounds().y < ymin) {
                ymin = roi.getBounds().y;
            }
            if ((float)(roi.getBounds().x + roi.getBounds().width) > xmax) {
                xmax = roi.getBounds().x + roi.getBounds().width;
            }
            if (!((float)(roi.getBounds().y + roi.getBounds().height) > ymax)) continue;
            ymax = roi.getBounds().y + roi.getBounds().height;
        }
        ImagePlus imp = IJ.createImage((String)("Labels_" + this), (String)"16-bit black", (int)((int)xmax), (int)((int)ymax), (int)1);
        ImageProcessor ip = imp.getProcessor();
        int roiIndex = 0;
        for (CompositeFloatPoly cfp : rois.rois) {
            Roi roi = cfp.getRoi();
            imp.setRoi(roi);
            ip.setColor(++roiIndex);
            ip.fill(roi);
            ++roiIndex;
        }
        return imp;
    }

    public static IJShapeRoiArray labelImageToRoiArrayVectorize(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        float[][] pixels = ip.getFloatArray();
        FloatProcessor fp = new FloatProcessor(ip.getWidth(), ip.getHeight());
        fp.setFloatArray(pixels);
        ImagePlus imgFloatCopy = new ImagePlus("FloatLabel", (ImageProcessor)fp);
        boolean[][] movablePx = new boolean[ip.getWidth() + 1][ip.getHeight() + 1];
        for (int x = 1; x < ip.getWidth(); ++x) {
            for (int y = 1; y < ip.getHeight(); ++y) {
                float max;
                boolean is3Colored = false;
                boolean isCrossed = false;
                float p1p1 = pixels[x][y];
                float p1m1 = pixels[x][y - 1];
                float m1p1 = pixels[x - 1][y];
                float m1m1 = pixels[x - 1][y - 1];
                float min = p1p1;
                if (p1m1 < min) {
                    min = p1m1;
                }
                if (m1p1 < min) {
                    min = m1p1;
                }
                if (m1m1 < min) {
                    min = m1m1;
                }
                if (p1m1 > (max = p1p1)) {
                    max = p1m1;
                }
                if (m1p1 > max) {
                    max = m1p1;
                }
                if (m1m1 > max) {
                    max = m1m1;
                }
                if (min != max) {
                    if (p1p1 != min && p1p1 != max) {
                        is3Colored = true;
                    }
                    if (m1p1 != min && m1p1 != max) {
                        is3Colored = true;
                    }
                    if (p1m1 != min && p1m1 != max) {
                        is3Colored = true;
                    }
                    if (m1m1 != min && m1m1 != max) {
                        is3Colored = true;
                    }
                    if (!is3Colored && p1p1 == m1m1 && p1m1 == m1p1) {
                        isCrossed = true;
                    }
                }
                movablePx[x][y] = !is3Colored && !isCrossed;
            }
        }
        ArrayList<Roi> roiArray = new ArrayList<Roi>();
        HashSet<Float> existingPixelValues = new HashSet<Float>();
        for (int x = 0; x < ip.getWidth(); ++x) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                existingPixelValues.add(Float.valueOf(pixels[x][y]));
            }
        }
        existingPixelValues.forEach(v -> {
            fp.setThreshold((double)v.floatValue(), (double)v.floatValue(), 2);
            Roi roi = SelectToROIKeepLines.run(imgFloatCopy, movablePx, true);
            roi.setName(Integer.toString((int)v.floatValue()));
            roiArray.add(roi);
        });
        IJShapeRoiArray output = new IJShapeRoiArray(roiArray);
        output.smoothenWithConstrains(movablePx);
        return output;
    }

    @Converter
    public static IJShapeRoiArray labelImageToRoiArrayKeepSinglePixelPrecision(ImagePlus imp) {
        ArrayList<Roi> roiArray = new ArrayList<Roi>();
        ImageProcessor ip = imp.getProcessor();
        float[][] pixels = ip.getFloatArray();
        HashSet<Float> existingPixelValues = new HashSet<Float>();
        for (int x = 0; x < ip.getWidth(); ++x) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                existingPixelValues.add(Float.valueOf(pixels[x][y]));
            }
        }
        FloatProcessor fp = new FloatProcessor(ip.getWidth(), ip.getHeight());
        fp.setFloatArray(pixels);
        ImagePlus imgFloatCopy = new ImagePlus("FloatLabel", (ImageProcessor)fp);
        existingPixelValues.forEach(v -> {
            fp.setThreshold((double)v.floatValue(), (double)v.floatValue(), 2);
            Roi roi = SelectToROIKeepLines.run(imgFloatCopy, null, false);
            roi.setName(Integer.toString((int)v.floatValue()));
            roiArray.add(roi);
        });
        return new IJShapeRoiArray(roiArray);
    }

    @Converter
    public static IJShapeRoiArray labelImageToRoiArray(ImagePlus imp) {
        ArrayList<Roi> roiArray = new ArrayList<Roi>();
        ImageProcessor ip = imp.getProcessor();
        float[][] pixels = ip.getFloatArray();
        HashSet<Float> existingPixelValues = new HashSet<Float>();
        for (int x = 0; x < ip.getWidth(); ++x) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                existingPixelValues.add(Float.valueOf(pixels[x][y]));
            }
        }
        FloatProcessor fp = new FloatProcessor(ip.getWidth(), ip.getHeight());
        fp.setFloatArray(pixels);
        ImagePlus imgFloatCopy = new ImagePlus("FloatLabel", (ImageProcessor)fp);
        existingPixelValues.forEach(v -> {
            fp.setThreshold((double)v.floatValue(), (double)v.floatValue(), 2);
            Roi roi = ThresholdToSelection.run((ImagePlus)imgFloatCopy);
            roi.setName(Integer.toString((int)v.floatValue()));
            roiArray.add(roi);
        });
        return new IJShapeRoiArray(roiArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static TransformixInputRoisFile realPointListToTransformixFile(RealPointList rpl) {
        BufferedWriter writer = null;
        try {
            File temp = File.createTempFile("tpts", ".txt");
            temp.deleteOnExit();
            TransformixInputRoisFile erf = new TransformixInputRoisFile(temp);
            writer = new BufferedWriter(new FileWriter(temp));
            writer.write("point");
            writer.newLine();
            writer.write(Integer.toString(rpl.ptList.size()));
            writer.newLine();
            for (RealPoint pt : rpl.ptList) {
                for (int i = 0; i < pt.numDimensions(); ++i) {
                    writer.write(Double.toString(pt.getDoublePosition(i)));
                    if (i == pt.numDimensions() - 1) continue;
                    writer.write("\t");
                }
                writer.newLine();
            }
            writer.close();
            erf.shapeRoiList = rpl.shapeRoiList;
            TransformixInputRoisFile transformixInputRoisFile = erf;
            return transformixInputRoisFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            TransformixInputRoisFile transformixInputRoisFile = null;
            return transformixInputRoisFile;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static RealPointList transformixFileToRealPointList(TransformixOutputRoisFile erf) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(erf.f));
            ArrayList<RealPoint> out = new ArrayList<RealPoint>();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(";");
                String[] part = parts[4].split("[\\s]");
                int nDim = 2;
                double[] coords = new double[nDim];
                for (int d = 0; d < nDim; ++d) {
                    coords[d] = Double.parseDouble(part[4 + d].trim());
                }
                RealPoint rp = new RealPoint(coords);
                out.add(rp);
            }
            reader.close();
            RealPointList outrpl = new RealPointList(out);
            outrpl.shapeRoiList = erf.shapeRoiList;
            RealPointList realPointList = outrpl;
            return realPointList;
        }
        catch (IOException e) {
            e.printStackTrace();
            RealPointList realPointList = null;
            return realPointList;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

