/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.java.utilities.image;

import ch.epfl.biop.java.utilities.Converter;
import ch.epfl.biop.java.utilities.ConvertibleObject;
import ch.epfl.biop.java.utilities.image.ElastixMultiFile;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.ChannelSplitter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.imagej.Dataset;
import net.imagej.ImageJ;
import org.apache.commons.io.FileUtils;

public class ConvertibleImage
extends ConvertibleObject {
    @Converter
    public static ImagePlus fileToImagePlus(File f) {
        return IJ.openImage((String)f.getAbsolutePath());
    }

    @Converter
    public static File imagePlusToFile(ImagePlus imp) {
        try {
            File temp = File.createTempFile("timg", ".tif");
            temp.deleteOnExit();
            IJ.save((ImagePlus)imp, (String)temp.getAbsolutePath());
            return temp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Converter
    public static ElastixMultiFile imagePlusToElastixMultiFile(ImagePlus imp) {
        try {
            ElastixMultiFile emf = new ElastixMultiFile();
            emf.files = new File[imp.getNChannels()];
            if (imp.getNChannels() > 1) {
                ImagePlus[] images = ChannelSplitter.split((ImagePlus)imp);
                for (int iCh = 0; iCh < images.length; ++iCh) {
                    File temp = File.createTempFile("timg", ".tif");
                    temp.deleteOnExit();
                    IJ.save((ImagePlus)images[iCh], (String)temp.getAbsolutePath());
                    emf.files[iCh] = temp;
                }
                return emf;
            }
            File temp = File.createTempFile("timg", ".tif");
            temp.deleteOnExit();
            IJ.save((ImagePlus)imp, (String)temp.getAbsolutePath());
            emf.files[0] = temp;
            return emf;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Converter
    public static Dataset fileToDataSet(File f) {
        try {
            return (Dataset)new ImageJ().io().open(f.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Converter
    public static File urlToFile(URL url) {
        try {
            File temp = File.createTempFile("timg", ".jpg");
            temp.deleteOnExit();
            FileUtils.copyURLToFile((URL)url, (File)temp, (int)10000, (int)10000);
            return temp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Converter
    public static ImagePlus downcastCompositeImageToImagePlus(CompositeImage ci) {
        return ci;
    }
}

