/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.java.utilities;

import ch.epfl.biop.java.utilities.Converter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConvertibleObject {
    final Map<Class<?>, ArrayList<Method>> convertFwd = new HashMap();
    final Map<Class<?>, ArrayList<Method>> convertBwd = new HashMap();
    public final Map<Class<?>, Object> states = new HashMap();
    public int MaxRecursivity = 3;
    String name = null;

    public ConvertibleObject() {
        for (Method m : this.getClass().getMethods()) {
            if (!m.isAnnotationPresent(Converter.class)) continue;
            this.registerConverter(m);
        }
        this.states.put(this.getClass(), this);
    }

    private void registerConverter(Method m) {
        ArrayList<Method> methodArray;
        Class<?> c_in = m.getParameterTypes()[0].getComponentType();
        Class<?> c_out = m.getReturnType();
        if (this.convertFwd.containsKey(c_in)) {
            this.convertFwd.get(c_in).add(m);
        } else {
            methodArray = new ArrayList<Method>();
            methodArray.add(m);
            this.convertFwd.put(c_in, methodArray);
        }
        if (this.convertBwd.containsKey(c_out)) {
            this.convertBwd.get(c_out).add(m);
        } else {
            methodArray = new ArrayList();
            methodArray.add(m);
            this.convertBwd.put(c_out, methodArray);
        }
    }

    public Object to(Class<?> c_out, int recursivityLevel) {
        if (recursivityLevel == 0) {
            return null;
        }
        if (this.states.containsKey(c_out)) {
            return this.states.get(c_out);
        }
        if (!this.states.isEmpty()) {
            if (this.convertBwd.get(c_out) != null) {
                Class<?> c_in;
                for (Method m : this.convertBwd.get(c_out)) {
                    c_in = m.getParameterTypes()[0];
                    if (!this.states.containsKey(c_in)) continue;
                    try {
                        Object obj_out = m.invoke((Object)this, this.states.get(c_in));
                        this.states.put(c_out, obj_out);
                        return obj_out;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                for (Method m : this.convertBwd.get(c_out)) {
                    c_in = m.getParameterTypes()[0];
                    Object obj_in = this.to(c_in, recursivityLevel - 1);
                    if (obj_in == null) continue;
                    try {
                        Object obj_out = m.invoke((Object)this, this.states.get(c_in));
                        this.states.put(c_out, obj_out);
                        return obj_out;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public Object to(Class<?> c_out) {
        return this.to(c_out, this.MaxRecursivity);
    }

    public void clear() {
        this.states.clear();
    }

    public void clear(Class<?> c) {
        this.states.remove(c);
    }

    public void set(Object o) {
        this.states.put(o.getClass(), o);
    }

    public void set(Object o, Class<?> c) {
        this.states.put((Class<?>)c.getClass().cast(o), o);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }
}

