/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.fiji.imageplusutils;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.ChannelSplitter;
import ij.plugin.RGBStackMerge;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.StackConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ImagePlusFunctions {
    public static ImagePlus splitApplyRecompose(Function<ImagePlus, ImagePlus> ipOperator, ImagePlus img_in) {
        ImagePlus img_out_temp;
        int i;
        boolean isRGB = false;
        ImagePlus[] channels = null;
        int nTimepointsRGB = 0;
        ArrayList<ImageProcessor> ips = new ArrayList<ImageProcessor>();
        if (img_in.getType() == 4) {
            isRGB = true;
            channels = ChannelSplitter.split((ImagePlus)img_in);
            nTimepointsRGB = channels[0].getStack().getSize();
            for (i = 0; i < channels[0].getStack().getSize(); ++i) {
                ips.add(channels[0].getStack().getProcessor(i + 1).convertToFloat());
            }
            for (i = 0; i < channels[1].getStack().getSize(); ++i) {
                ips.add(channels[1].getStack().getProcessor(i + 1).convertToFloat());
            }
            for (i = 0; i < channels[2].getStack().getSize(); ++i) {
                ips.add(channels[2].getStack().getProcessor(i + 1).convertToFloat());
            }
        } else {
            for (i = 0; i < img_in.getStack().getSize(); ++i) {
                ips.add(img_in.getStack().getProcessor(i + 1).convertToFloat());
            }
        }
        List tr_imps = ips.parallelStream().map(ip -> {
            ImagePlus imp = new ImagePlus();
            imp.setProcessor(ip);
            imp.setTitle(ip.toString());
            return ((ImagePlus)ipOperator.apply(imp)).getProcessor();
        }).collect(Collectors.toList());
        int newH = ((ImageProcessor)tr_imps.get(0)).getHeight();
        int newW = ((ImageProcessor)tr_imps.get(0)).getWidth();
        if (isRGB) {
            int i2;
            int i_IP = 0;
            ImagePlus red = IJ.createImage((String)"Red", (String)"8-bit", (int)newW, (int)newH, (int)nTimepointsRGB);
            for (i2 = 0; i2 < nTimepointsRGB; ++i2) {
                red.getStack().setProcessor(((ImageProcessor)tr_imps.get(i_IP)).convertToByte(false), i2 + 1);
                ++i_IP;
            }
            ImagePlus green = IJ.createImage((String)"Green", (String)"8-bit", (int)newW, (int)newH, (int)nTimepointsRGB);
            for (i2 = 0; i2 < nTimepointsRGB; ++i2) {
                green.getStack().setProcessor(((ImageProcessor)tr_imps.get(i_IP)).convertToByte(false), i2 + 1);
                ++i_IP;
            }
            ImagePlus blue = IJ.createImage((String)"Blue", (String)"8-bit", (int)newW, (int)newH, (int)nTimepointsRGB);
            for (i2 = 0; i2 < nTimepointsRGB; ++i2) {
                blue.getStack().setProcessor(((ImageProcessor)tr_imps.get(i_IP)).convertToByte(false), i2 + 1);
                ++i_IP;
            }
            RGBStackMerge rgbsm = new RGBStackMerge();
            img_out_temp = rgbsm.mergeHyperstacks(new ImagePlus[]{red, green, blue}, false);
            if (channels != null) {
                assert (channels.length == 3);
                channels[0].close();
                channels[1].close();
                channels[2].close();
            }
        } else {
            img_out_temp = new ImagePlusBuilder().allAs(img_in).type32Bit().height(newH).width(newW).createImagePlus();
            img_out_temp.setSlice(0);
            for (int i3 = 0; i3 < img_in.getStack().getSize(); ++i3) {
                img_out_temp.getStack().setProcessor(((ImageProcessor)tr_imps.get(i3)).convertToFloat(), i3 + 1);
            }
            img_out_temp.getProcessor().setPixels(((ImageProcessor)tr_imps.get(0)).convertToFloat().getPixels());
        }
        if (isRGB) {
            new StackConverter(img_out_temp).convertToRGB();
        }
        img_out_temp.setTitle("Transformed_" + img_in.getTitle());
        ImagePlus img_out = img_out_temp.duplicate();
        img_out.setTitle(img_out.getTitle().substring(4));
        return img_out;
    }

    public static class ImagePlusBuilder {
        public String title = "Undefined";
        public String type;
        public int width;
        public int height;
        public int c;
        public int z;
        public int t;
        public LUT[] luts;
        public boolean[] activeChannels;
        public float[] minMax;
        public int display_mode = 3;

        public ImagePlusBuilder with(Consumer<ImagePlusBuilder> builderFunction) {
            builderFunction.accept(this);
            return this;
        }

        public ImagePlusBuilder width(int w) {
            this.width = w;
            return this;
        }

        public ImagePlusBuilder height(int h) {
            this.height = h;
            return this;
        }

        public ImagePlusBuilder nChannels(int c) {
            this.c = c;
            return this;
        }

        public ImagePlusBuilder nFrames(int f) {
            this.t = f;
            return this;
        }

        public ImagePlusBuilder nSlices(int z) {
            this.z = z;
            return this;
        }

        public ImagePlusBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ImagePlusBuilder type8Bit() {
            this.type = "8-bit";
            return this;
        }

        public ImagePlusBuilder type16Bit() {
            this.type = "16-bit";
            return this;
        }

        public ImagePlusBuilder type32Bit() {
            this.type = "32-bit";
            return this;
        }

        public ImagePlusBuilder typeRGB() {
            this.type = "RGB";
            return this;
        }

        public ImagePlusBuilder allAs(ImagePlus imp) {
            return this.dimensionsAs(imp).typeAs(imp).lutsAs(imp).minMaxAs(imp);
        }

        public ImagePlusBuilder dimensionsAs(ImagePlus imp) {
            this.width = imp.getWidth();
            this.height = imp.getHeight();
            this.c = imp.getNChannels();
            this.t = imp.getNFrames();
            this.z = imp.getNSlices();
            return this;
        }

        public ImagePlusBuilder lutsAs(ImagePlus imp) {
            this.luts = new LUT[imp.getNChannels()];
            this.luts = imp.getLuts();
            this.display_mode = imp.getDisplayMode();
            return this;
        }

        public ImagePlusBuilder minMaxAs(ImagePlus imp) {
            this.minMax = new float[2 * imp.getNChannels()];
            for (int i = 0; i < imp.getNChannels(); ++i) {
                imp.setC(i + 1);
                this.minMax[2 * i] = (float)imp.getDisplayRangeMin();
                this.minMax[2 * i + 1] = (float)imp.getDisplayRangeMax();
            }
            return this;
        }

        public ImagePlusBuilder typeAs(ImagePlus imp) {
            switch (imp.getType()) {
                case 0: {
                    this.type = "8-bit";
                    break;
                }
                case 3: {
                    System.err.println("Unsupported operation : 8 bit color.");
                    this.type = "8-bit";
                    break;
                }
                case 1: {
                    this.type = "16-bit";
                    break;
                }
                case 2: {
                    this.type = "32-bit";
                    break;
                }
                case 4: {
                    this.type = "RGB";
                }
            }
            return this;
        }

        public ImagePlus createImagePlus() {
            int ic;
            if (this.display_mode == 1) {
                this.type = this.type + " composite";
            }
            ImagePlus imp = IJ.createImage((String)this.title, (String)this.type, (int)this.width, (int)this.height, (int)this.c, (int)this.z, (int)this.t);
            if (this.luts != null) {
                for (ic = 0; ic < this.c; ++ic) {
                    if (this.luts.length <= ic) continue;
                    imp.setC(ic + 1);
                    imp.getProcessor().setLut(this.luts[ic]);
                }
            }
            if (this.minMax != null) {
                for (ic = 0; ic < this.c; ++ic) {
                    if (this.minMax.length <= 2 * ic) continue;
                    imp.setC(ic + 1);
                    imp.setDisplayRange((double)this.minMax[2 * ic], (double)this.minMax[2 * ic + 1]);
                }
            }
            imp.setDisplayMode(this.display_mode);
            return imp;
        }
    }
}

